/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.measurement.view;

import com.sun.opengl.util.texture.TextureData;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.Drawing;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.Figure;
import org.openmicroscopy.shoola.agents.events.SaveData;
import org.openmicroscopy.shoola.agents.events.iviewer.SaveRelatedData;
import org.openmicroscopy.shoola.agents.measurement.Analyser;
import org.openmicroscopy.shoola.agents.measurement.MeasurementAgent;
import org.openmicroscopy.shoola.agents.measurement.MeasurementViewerLoader;
import org.openmicroscopy.shoola.agents.measurement.ROILoader;
import org.openmicroscopy.shoola.agents.measurement.ROISaver;
import org.openmicroscopy.shoola.agents.measurement.ServerSideROILoader;
import org.openmicroscopy.shoola.agents.measurement.WorkflowLoader;
import org.openmicroscopy.shoola.agents.measurement.WorkflowSaver;
import org.openmicroscopy.shoola.agents.measurement.util.FileMap;
import org.openmicroscopy.shoola.agents.measurement.view.MeasurementViewer;
import org.openmicroscopy.shoola.agents.util.EditorUtil;
import org.openmicroscopy.shoola.env.data.DSAccessException;
import org.openmicroscopy.shoola.env.data.DSOutOfServiceException;
import org.openmicroscopy.shoola.env.data.OmeroImageService;
import org.openmicroscopy.shoola.env.data.model.ROIResult;
import org.openmicroscopy.shoola.env.event.EventBus;
import org.openmicroscopy.shoola.env.log.Logger;
import org.openmicroscopy.shoola.util.file.IOUtil;
import org.openmicroscopy.shoola.util.roi.ROIComponent;
import org.openmicroscopy.shoola.util.roi.exception.NoSuchROIException;
import org.openmicroscopy.shoola.util.roi.exception.ParsingException;
import org.openmicroscopy.shoola.util.roi.exception.ROICreationException;
import org.openmicroscopy.shoola.util.roi.figures.ROIFigure;
import org.openmicroscopy.shoola.util.roi.model.ROI;
import org.openmicroscopy.shoola.util.roi.model.ROIShape;
import org.openmicroscopy.shoola.util.roi.model.ShapeList;
import org.openmicroscopy.shoola.util.roi.model.annotation.AnnotationKeys;
import org.openmicroscopy.shoola.util.roi.model.annotation.MeasurementAttributes;
import org.openmicroscopy.shoola.util.roi.model.util.Coord3D;
import org.openmicroscopy.shoola.util.roi.model.util.MeasurementUnits;
import org.openmicroscopy.shoola.util.ui.drawingtools.DrawingComponent;
import org.openmicroscopy.shoola.util.ui.drawingtools.canvas.DrawingCanvasView;
import pojos.ChannelData;
import pojos.ExperimenterData;
import pojos.FileAnnotationData;
import pojos.ImageData;
import pojos.PixelsData;
import pojos.ROIData;
import pojos.WorkflowData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MeasurementViewerModel {
    private long imageID;
    private String name;
    private Rectangle requesterBounds;
    private int state;
    private DrawingComponent drawingComponent;
    private ROIComponent roiComponent;
    private Coord3D currentPlane;
    private PixelsData pixels;
    private double magnification;
    private Map activeChannels;
    private Map analysisResults;
    private List<ChannelData> metadata;
    private MeasurementViewerLoader currentLoader;
    private MeasurementViewerLoader currentSaver;
    private MeasurementViewer component;
    private SaveRelatedData event;
    private Object rndImage;
    private String fileSaved;
    private List<FileAnnotationData> measurements;
    private Collection measurementResults;
    private String workflowNamespace;
    private Map<String, WorkflowData> workflows;
    private List<String> keyword;
    private boolean HCSData;
    private List<ROI> roiToDelete;
    private boolean dataToDelete;

    private List sortROIShape(List nodes) {
        Comparator c = new Comparator(){

            public int compare(Object o1, Object o2) {
                long i1 = ((ROIShape)o1).getID();
                long i2 = ((ROIShape)o2).getID();
                int v = 0;
                if (i1 < i2) {
                    v = -1;
                } else if (i1 > i2) {
                    v = 1;
                }
                return v;
            }
        };
        Collections.sort(nodes, c);
        return nodes;
    }

    private void mapFigureAttributeToROIAnnotation(AttributeKey attribute, ROIFigure figure) {
        if (MeasurementAttributes.TEXT.getKey().equals(attribute.getKey())) {
            ROIShape shape = figure.getROIShape();
            AnnotationKeys.TEXT.set(shape, (String)MeasurementAttributes.TEXT.get((Figure)figure));
        }
    }

    private void checkIfHasROIToDelete() {
        if (this.dataToDelete) {
            return;
        }
        ExperimenterData exp = MeasurementAgent.getUserDetails();
        long ownerID = exp.getId();
        Collection<ROI> rois = this.roiComponent.getROIMap().values();
        Iterator<ROI> i = rois.iterator();
        ArrayList<ROI> ownedRois = new ArrayList<ROI>();
        ArrayList<ROIFigure> figures = new ArrayList<ROIFigure>();
        while (i.hasNext()) {
            ROI roi = i.next();
            if (roi.getOwnerID() != ownerID && roi.getOwnerID() != -1L) continue;
            figures.addAll(roi.getAllFigures());
            ownedRois.add(roi);
        }
        this.dataToDelete = ownedRois.size() > 0;
    }

    MeasurementViewerModel(long imageID, PixelsData pixels, String name, Rectangle bounds, List<ChannelData> channelsData) {
        this.metadata = channelsData;
        this.imageID = imageID;
        this.pixels = pixels;
        this.name = name;
        this.requesterBounds = bounds;
        this.state = 1;
        this.drawingComponent = new DrawingComponent();
        this.roiComponent = new ROIComponent();
        this.fileSaved = null;
        this.roiComponent.setMicronsPixelX(this.getPixelSizeX());
        this.roiComponent.setMicronsPixelY(this.getPixelSizeY());
        this.roiComponent.setMicronsPixelZ(this.getPixelSizeZ());
        this.workflows = new HashMap<String, WorkflowData>();
        this.workflowNamespace = WorkflowData.DEFAULTWORKFLOW;
        this.keyword = new ArrayList<String>();
    }

    void initialize(MeasurementViewer component) {
        this.component = component;
    }

    ROIComponent getROIComponent() {
        return this.roiComponent;
    }

    String getUserName() {
        return MeasurementAgent.getRegistry().getAdminService().getLoggingName();
    }

    String getServerName() {
        return MeasurementAgent.getRegistry().getAdminService().getServerName();
    }

    void setPlane(int z, int t) {
        this.currentPlane = new Coord3D(z, t);
    }

    boolean isSameDisplay(MeasurementViewerModel other) {
        if (other == null) {
            return false;
        }
        return other.pixels.getId() == this.getPixelsID() && other.imageID == this.imageID;
    }

    long getImageID() {
        return this.imageID;
    }

    long getPixelsID() {
        return this.pixels.getId();
    }

    String getImageName() {
        return this.name;
    }

    String getImageTitle() {
        return "[ID: " + this.getImageID() + "] " + EditorUtil.getPartialName(this.getImageName());
    }

    Rectangle getRequesterBounds() {
        return this.requesterBounds;
    }

    int getState() {
        return this.state;
    }

    DrawingEditor getDrawingEditor() {
        return this.drawingComponent.getEditor();
    }

    Drawing getDrawing() {
        return this.drawingComponent.getDrawing();
    }

    void discard() {
        this.cancel();
        this.state = 6;
    }

    void cancel() {
        if (this.currentLoader != null) {
            this.currentLoader.cancel();
        }
        this.state = 5;
    }

    int getDefaultZ() {
        return this.currentPlane.getZSection();
    }

    int getDefaultT() {
        return this.currentPlane.getTimePoint();
    }

    double getMagnification() {
        return this.magnification;
    }

    void setMagnification(double magnification) {
        this.magnification = magnification;
        if (this.state != 1) {
            this.getDrawingView().setScaleFactor(magnification, new Dimension(this.getSizeX(), this.getSizeY()));
        } else {
            this.getDrawingView().setScaleFactor(magnification);
        }
    }

    void setAttributes(AttributeKey key, Object value) {
        List figures = this.getDrawing().getFigures();
        for (Figure f : figures) {
            f.setAttribute(key, value);
        }
        this.getDrawingView().repaint();
    }

    boolean setROI(InputStream input) throws ROICreationException, NoSuchROIException, ParsingException {
        this.state = 5;
        if (input == null) {
            return false;
        }
        List<ROI> roiList = this.roiComponent.loadROI(input);
        if (roiList == null) {
            return false;
        }
        Iterator<ROI> i = roiList.iterator();
        int sizeZ = this.pixels.getSizeZ();
        int sizeT = this.pixels.getSizeT();
        while (i.hasNext()) {
            ROI roi = i.next();
            TreeMap<Coord3D, ROIShape> shapeList = roi.getShapes();
            for (ROIShape shape : shapeList.values()) {
                Coord3D c = shape.getCoord3D();
                if (c.getTimePoint() > sizeT) {
                    return false;
                }
                if (c.getZSection() <= sizeZ) continue;
                return false;
            }
        }
        this.component.attachListeners(roiList);
        return true;
    }

    FileAnnotationData getMeasurement(long fileID) {
        if (this.measurements == null) {
            return null;
        }
        for (FileAnnotationData fa : this.measurements) {
            if (fa.getId() != fileID) continue;
            return fa;
        }
        return null;
    }

    List<FileAnnotationData> getMeasurements() {
        return this.measurements;
    }

    Collection getMeasurementResults() {
        return this.measurementResults;
    }

    boolean setServerROI(Collection rois, boolean readOnly) throws ROICreationException, NoSuchROIException {
        this.measurementResults = rois;
        this.state = 5;
        ArrayList<ROI> roiList = new ArrayList<ROI>();
        Iterator r = rois.iterator();
        long userID = MeasurementAgent.getUserDetails().getId();
        while (r.hasNext()) {
            ROIResult result = (ROIResult)r.next();
            roiList.addAll(this.roiComponent.loadROI(result.getFileID(), result.getROIs(), readOnly, userID));
        }
        if (roiList == null) {
            return false;
        }
        Iterator i = roiList.iterator();
        int sizeZ = this.pixels.getSizeZ();
        int sizeT = this.pixels.getSizeT();
        while (i.hasNext()) {
            ROI roi = (ROI)i.next();
            TreeMap<Coord3D, ROIShape> shapeList = roi.getShapes();
            for (ROIShape shape : shapeList.values()) {
                Coord3D c = shape.getCoord3D();
                if (c.getTimePoint() > sizeT) {
                    return false;
                }
                if (c.getZSection() <= sizeZ) continue;
                return false;
            }
        }
        this.component.attachListeners(roiList);
        this.checkIfHasROIToDelete();
        return true;
    }

    TreeMap getROI() {
        return this.roiComponent.getROIMap();
    }

    Coord3D getCurrentView() {
        return this.currentPlane;
    }

    double getPixelSizeX() {
        return this.pixels.getPixelSizeX();
    }

    double getPixelSizeY() {
        return this.pixels.getPixelSizeY();
    }

    double getPixelSizeZ() {
        return this.pixels.getPixelSizeZ();
    }

    int getNumZSections() {
        return this.pixels.getSizeZ();
    }

    int getNumTimePoints() {
        return this.pixels.getSizeT();
    }

    int getSizeX() {
        return this.pixels.getSizeX();
    }

    int getSizeY() {
        return this.pixels.getSizeY();
    }

    DrawingCanvasView getDrawingView() {
        return this.drawingComponent.getDrawingView();
    }

    Collection<ROI> getSelectedROI() {
        Set selectedFigs = this.getDrawingView().getSelectedFigures();
        ArrayList<ROI> roiList = new ArrayList<ROI>();
        for (ROIFigure fig : selectedFigs) {
            roiList.add(fig.getROI());
        }
        return roiList;
    }

    void removeROIShape(long id) throws NoSuchROIException {
        ROIShape shape = this.roiComponent.getShape(id, this.getCurrentView());
        if (shape != null) {
            if (this.drawingComponent.contains(shape.getFigure())) {
                this.drawingComponent.removeFigure(shape.getFigure());
            } else {
                this.roiComponent.deleteShape(id, this.getCurrentView());
            }
        }
    }

    void removeROIShape(long id, Coord3D coord) throws NoSuchROIException {
        ROIShape shape = this.roiComponent.getShape(id, coord);
        if (shape != null) {
            if (this.drawingComponent.contains(shape.getFigure())) {
                this.drawingComponent.removeFigure(shape.getFigure());
            } else {
                this.roiComponent.deleteShape(id, coord);
            }
        }
    }

    void removeROI(long id) throws NoSuchROIException {
        ROIShape shape = this.roiComponent.getShape(id, this.getCurrentView());
        if (shape != null && this.drawingComponent.contains(shape.getFigure())) {
            this.drawingComponent.removeFigure(shape.getFigure());
        }
        if (this.roiComponent.containsROI(id)) {
            this.roiComponent.deleteROI(id);
        }
    }

    void removeAllROI() throws NoSuchROIException {
        this.drawingComponent.removeAllFigures();
        int size = this.roiComponent.getROIMap().values().size();
        ROI[] valueList = new ROI[size];
        this.roiComponent.getROIMap().values().toArray(valueList);
        if (valueList != null) {
            for (ROI roi : valueList) {
                this.roiComponent.deleteROI(roi.getID());
            }
        }
    }

    List<ROIFigure> removeAllROI(long ownerID) throws NoSuchROIException {
        Collection<ROI> rois = this.roiComponent.getROIMap().values();
        Iterator<ROI> i = rois.iterator();
        ArrayList<ROI> ownedRois = new ArrayList<ROI>();
        ArrayList<ROIFigure> figures = new ArrayList<ROIFigure>();
        while (i.hasNext()) {
            ROI roi = i.next();
            if (roi.getOwnerID() != ownerID && roi.getOwnerID() != -1L) continue;
            figures.addAll(roi.getAllFigures());
            ownedRois.add(roi);
        }
        for (ROI roi : ownedRois) {
            this.roiComponent.deleteROI(roi.getID());
        }
        Iterator j = figures.iterator();
        while (j.hasNext()) {
            this.drawingComponent.removeFigure((Figure)j.next());
        }
        this.event = null;
        this.notifyDataChanged(false);
        this.dataToDelete = false;
        return figures;
    }

    ROI getROI(long id) throws NoSuchROIException {
        return this.roiComponent.getROI(id);
    }

    ROI createROI(ROIFigure figure, boolean addAttribs) throws ROICreationException, NoSuchROIException {
        ROI roi = this.roiComponent.addROI(figure, this.getCurrentView(), addAttribs);
        roi.setAnnotation(AnnotationKeys.NAMESPACE, this.workflowNamespace);
        String keywordString = "";
        for (int i = 0; i < this.keyword.size(); ++i) {
            keywordString = keywordString + this.keyword.get(i);
            if (i >= this.keyword.size() - 1) continue;
            keywordString = keywordString + ",";
        }
        roi.setAnnotation(AnnotationKeys.KEYWORDS, keywordString);
        return roi;
    }

    ShapeList getShapeList() throws NoSuchROIException {
        return this.roiComponent.getShapeList(this.currentPlane);
    }

    void figureAttributeChanged(AttributeKey attribute, ROIFigure figure) {
        this.mapFigureAttributeToROIAnnotation(attribute, figure);
    }

    void fireLoadROIFromServer(List<FileAnnotationData> measurements) {
        this.measurements = measurements;
        ArrayList<Long> files = null;
        if (measurements != null) {
            files = new ArrayList<Long>();
            Iterator<FileAnnotationData> i = measurements.iterator();
            while (i.hasNext()) {
                files.add(i.next().getId());
            }
        }
        this.state = 3;
        ExperimenterData exp = MeasurementAgent.getUserDetails();
        this.currentLoader = new ROILoader(this.component, this.getImageID(), files, exp.getId());
        this.currentLoader.load();
    }

    void fireLoadROIServerOrClient(boolean dataChanged) {
        this.state = 3;
        ExperimenterData exp = MeasurementAgent.getUserDetails();
        this.currentLoader = new ServerSideROILoader(this.component, this.getImageID(), exp.getId());
        this.currentLoader.load();
        this.notifyDataChanged(dataChanged);
    }

    void fireLoadWorkflow() {
        ExperimenterData exp = MeasurementAgent.getUserDetails();
        this.currentLoader = new WorkflowLoader(this.component, exp.getId());
        this.currentLoader.load();
    }

    void retrieveWorkflowsFromServer() {
        ExperimenterData exp = MeasurementAgent.getUserDetails();
        OmeroImageService svc = MeasurementAgent.getRegistry().getImageService();
        try {
            List<WorkflowData> result = svc.retrieveWorkflows(exp.getId());
            this.workflows.clear();
            this.component.setWorkflowList(result);
        }
        catch (DSAccessException e) {
            Logger log = MeasurementAgent.getRegistry().getLogger();
            log.error((Object)this, "Cannot load workflows");
        }
        catch (DSOutOfServiceException e) {
            Logger log = MeasurementAgent.getRegistry().getLogger();
            log.error((Object)this, "Cannot load workflows");
        }
    }

    void fireROILoading(String fileName) {
        Logger log;
        this.state = 3;
        InputStream stream = null;
        try {
            if (fileName == null) {
                fileName = FileMap.getSavedFile(this.getServerName(), this.getUserName(), this.getPixelsID());
            }
            this.fileSaved = fileName;
            if (this.fileSaved != null) {
                stream = IOUtil.readFileAsInputStream(fileName);
            }
        }
        catch (Exception e) {
            log = MeasurementAgent.getRegistry().getLogger();
            log.warn((Object)this, "Cannot load the ROI " + e.getMessage());
        }
        this.component.setROI(stream);
        try {
            if (stream != null) {
                stream.close();
            }
        }
        catch (Exception e) {
            log = MeasurementAgent.getRegistry().getLogger();
            log.warn((Object)this, "Cannot close the stream " + e.getMessage());
        }
    }

    String getFileSaved() {
        return this.fileSaved;
    }

    void saveROI(String fileName, boolean post) throws ParsingException {
        Logger log;
        OutputStream stream = null;
        try {
            stream = IOUtil.writeFile(fileName);
        }
        catch (Exception e) {
            log = MeasurementAgent.getRegistry().getLogger();
            log.warn((Object)this, "Cannot save the ROI " + e.getMessage());
        }
        this.roiComponent.saveROI(stream);
        try {
            if (stream != null) {
                stream.close();
            }
            FileMap.setSavedFile(this.getServerName(), this.getUserName(), this.getPixelsID(), fileName);
            if (!post) {
                this.event = null;
            }
            this.notifyDataChanged(false);
        }
        catch (Exception e) {
            log = MeasurementAgent.getRegistry().getLogger();
            log.warn((Object)this, "Cannot close the stream " + e.getMessage());
        }
    }

    void saveROIToServer(boolean async) {
        try {
            List<ROIData> roiList = this.getROIData();
            ExperimenterData exp = MeasurementAgent.getUserDetails();
            if (roiList.size() == 0) {
                return;
            }
            if (async) {
                this.currentSaver = new ROISaver(this.component, this.getImageID(), exp.getId(), roiList);
                this.currentSaver.load();
                this.notifyDataChanged(false);
            } else {
                OmeroImageService svc = MeasurementAgent.getRegistry().getImageService();
                svc.saveROI(this.getImageID(), exp.getId(), roiList);
                this.event = null;
            }
            this.checkIfHasROIToDelete();
        }
        catch (Exception e) {
            Logger log = MeasurementAgent.getRegistry().getLogger();
            log.warn((Object)this, "Cannot save to server " + e.getMessage());
        }
    }

    List<ROIData> getROIData() {
        ExperimenterData exp = MeasurementAgent.getUserDetails();
        try {
            return this.roiComponent.saveROI(this.getImage(), exp.getId());
        }
        catch (Exception e) {
            Logger log = MeasurementAgent.getRegistry().getLogger();
            log.warn((Object)this, "Cannot transform the ROI: " + e.getMessage());
            return new ArrayList<ROIData>();
        }
    }

    ImageData getImage() {
        return this.pixels.getImage();
    }

    void saveWorkflowToServer(boolean async) {
        ArrayList<WorkflowData> workflowList = new ArrayList<WorkflowData>();
        Iterator<WorkflowData> workflowIterator = this.workflows.values().iterator();
        while (workflowIterator.hasNext()) {
            workflowList.add(workflowIterator.next());
        }
        try {
            ExperimenterData exp = MeasurementAgent.getUserDetails();
            if (async) {
                this.currentSaver = new WorkflowSaver(this.component, workflowList, exp.getId());
                this.currentSaver.load();
                this.notifyDataChanged(false);
            } else {
                OmeroImageService svc = MeasurementAgent.getRegistry().getImageService();
                svc.storeWorkflows(workflowList, exp.getId());
                this.event = null;
            }
        }
        catch (Exception e) {
            Logger log = MeasurementAgent.getRegistry().getLogger();
            log.warn((Object)this, "Cannot save workflows to server " + e.getMessage());
        }
    }

    List<ROIShape> propagateShape(ROIShape shape, int timePoint, int zSection) throws ROICreationException, NoSuchROIException {
        this.notifyDataChanged(true);
        Coord3D coord = new Coord3D(zSection, timePoint);
        return this.roiComponent.propagateShape(shape.getID(), shape.getCoord3D(), shape.getCoord3D(), coord);
    }

    void deleteShape(ROIShape shape, int timePoint, int zSection) throws NoSuchROIException {
        if (this.drawingComponent.contains(shape.getFigure())) {
            this.drawingComponent.getDrawing().remove((Figure)shape.getFigure());
        } else {
            this.notifyDataChanged(true);
            this.roiComponent.deleteShape(shape.getID(), shape.getCoord3D(), new Coord3D(zSection, timePoint));
        }
    }

    void showMeasurementsInMicrons(boolean inMicrons) {
        this.roiComponent.showMeasurementsInMicrons(inMicrons);
    }

    MeasurementUnits getMeasurementUnits() {
        return this.roiComponent.getMeasurementUnits();
    }

    void setActiveChannels(Map activeChannels) {
        this.activeChannels = activeChannels;
    }

    void fireAnalyzeShape(List<ROIShape> shapeList) {
        this.state = 4;
        ArrayList channels = new ArrayList(this.activeChannels.size());
        channels.addAll(this.activeChannels.keySet());
        if (this.currentLoader != null) {
            this.currentLoader.cancel();
        }
        this.currentLoader = new Analyser(this.component, this.pixels, channels, shapeList);
        this.currentLoader.load();
    }

    List<ChannelData> getMetadata() {
        return this.metadata;
    }

    ChannelData getMetadata(int index) {
        if (index < 0 || index >= this.metadata.size()) {
            return null;
        }
        for (ChannelData d : this.metadata) {
            if (d.getIndex() != index) continue;
            return d;
        }
        return null;
    }

    void setAnalysisResults(Map analysisResults) {
        this.analysisResults = analysisResults;
        if (analysisResults != null) {
            Iterator i = analysisResults.entrySet().iterator();
            ArrayList<ROIShape> l = new ArrayList<ROIShape>(analysisResults.size());
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                ROIShape shape = (ROIShape)entry.getKey();
                l.add(shape);
            }
            List newList = this.sortROIShape(l);
            LinkedHashMap m = new LinkedHashMap(analysisResults.size());
            for (ROIShape shape : newList) {
                m.put(shape, analysisResults.get(shape));
            }
            this.analysisResults = m;
        }
        this.state = 5;
    }

    Map getAnalysisResults() {
        return this.analysisResults;
    }

    Map getActiveChannels() {
        return this.activeChannels;
    }

    Color getActiveChannelColor(int index) {
        return (Color)this.activeChannels.get(index);
    }

    Collection<Figure> getSelectedFigures() {
        return this.getDrawingView().getSelectedFigures();
    }

    boolean isChannelActive(int index) {
        return this.activeChannels.get(index) != null;
    }

    void notifyDataChanged(boolean toSave) {
        if (this.isHCSData()) {
            return;
        }
        if (this.event != null && toSave) {
            return;
        }
        EventBus bus = MeasurementAgent.getRegistry().getEventBus();
        this.event = new SaveRelatedData(this.getPixelsID(), new SaveData(this.getPixelsID(), 0), "The ROI", toSave);
        this.checkIfHasROIToDelete();
        bus.post(this.event);
        if (!toSave) {
            this.event = null;
        }
    }

    void calculateStats(List<ROIShape> shapeList) {
        this.component.analyseShapeList(shapeList);
    }

    List<ROI> getROIList(long fileID) {
        return this.roiComponent.getROIList(fileID);
    }

    ROI cloneROI(long id) throws ROICreationException, NoSuchROIException {
        return this.roiComponent.cloneROI(id);
    }

    void deleteShape(long id, Coord3D coord) throws NoSuchROIException {
        this.roiComponent.deleteShape(id, coord);
    }

    void addShape(long id, Coord3D coord, ROIShape shape) throws ROICreationException, NoSuchROIException {
        this.roiComponent.addShape(id, coord, shape);
    }

    void setRenderedImage(Object rndImage) {
        this.rndImage = rndImage;
    }

    BufferedImage getRenderedImage() {
        if (this.rndImage instanceof BufferedImage) {
            return (BufferedImage)this.rndImage;
        }
        if (this.rndImage instanceof TextureData) {
            TextureData data = (TextureData)this.rndImage;
            data.getBuffer();
            return null;
        }
        return null;
    }

    Object getRefObject() {
        return this.pixels;
    }

    boolean hasROIToSave() {
        if (this.isHCSData()) {
            return false;
        }
        return this.event != null;
    }

    boolean hasROIToDelete() {
        if (this.hasROIToSave()) {
            return true;
        }
        return this.dataToDelete;
    }

    void setWorkflow(String workflowNamespace) {
        if (workflowNamespace == null) {
            return;
        }
        if (WorkflowData.DEFAULTWORKFLOW.equals(workflowNamespace)) {
            this.workflowNamespace = workflowNamespace;
            this.keyword = new ArrayList<String>();
        } else {
            if (!this.workflows.containsKey(workflowNamespace)) {
                throw new IllegalArgumentException("Workflow " + workflowNamespace + " does not exist");
            }
            this.workflowNamespace = workflowNamespace;
            this.keyword = this.getWorkflow().getKeywordsAsList();
        }
    }

    WorkflowData getWorkflow() {
        if (this.workflowNamespace != WorkflowData.DEFAULTWORKFLOW) {
            return this.workflows.get(this.workflowNamespace);
        }
        return null;
    }

    void addWorkflow(WorkflowData workflow) {
        if (workflow != null) {
            this.workflows.put(workflow.getNameSpace(), workflow);
        }
    }

    void resetWorkflows(List<WorkflowData> workflowList) {
        this.workflows.clear();
        for (WorkflowData workflow : workflowList) {
            this.workflows.put(workflow.getNameSpace(), workflow);
        }
    }

    List<String> getWorkflows() {
        ArrayList<String> workflowList = new ArrayList<String>();
        Iterator<String> i = this.workflows.keySet().iterator();
        workflowList.add(WorkflowData.DEFAULTWORKFLOW);
        while (i.hasNext()) {
            workflowList.add(i.next());
        }
        return workflowList;
    }

    List<WorkflowData> getWorkflowDataList() {
        ArrayList<WorkflowData> workflowList = new ArrayList<WorkflowData>();
        Iterator<WorkflowData> i = this.workflows.values().iterator();
        while (i.hasNext()) {
            workflowList.add(i.next());
        }
        return workflowList;
    }

    void setKeyword(List<String> keywords) {
        if (keywords == null) {
            return;
        }
        if (keywords.size() == 0) {
            this.keyword = keywords;
        } else {
            WorkflowData workflow = this.getWorkflow();
            if (workflow == null) {
                return;
            }
            boolean b = true;
            for (String word : keywords) {
                if (workflow.contains(word) || word.trim().length() == 0) continue;
                b = false;
            }
            this.keyword = b ? keywords : new ArrayList<String>();
        }
    }

    List<String> getKeywords() {
        return this.keyword;
    }

    boolean isHCSData() {
        return this.HCSData;
    }

    void setHCSData(boolean value) {
        this.HCSData = value;
    }

    void markROIForDelete(long id, ROI roi) {
        if (roi == null) {
            return;
        }
        if (this.roiToDelete == null) {
            this.roiToDelete = new ArrayList<ROI>();
        }
        if (!this.roiComponent.containsROI(id) && !roi.isClientSide()) {
            this.roiToDelete.add(roi);
        }
    }

    List<ROI> getROIToDelete() {
        return this.roiToDelete;
    }

    void onROIDeleted(long imageID) {
        if (this.imageID != imageID) {
            return;
        }
        this.roiToDelete.clear();
        if (this.getROIData().size() == 0) {
            this.notifyDataChanged(false);
        }
    }
}

