/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.measurement.util.roitable;

import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.tree.TreeCellRenderer;
import org.openmicroscopy.shoola.agents.measurement.IconManager;
import org.openmicroscopy.shoola.agents.measurement.MeasurementAgent;
import org.openmicroscopy.shoola.agents.measurement.util.roitable.ROINode;
import org.openmicroscopy.shoola.util.roi.model.ROI;
import org.openmicroscopy.shoola.util.roi.model.ROIShape;

public class ROITableCellRenderer
extends JLabel
implements TreeCellRenderer {
    private static Icon SHAPE_ICON;
    private static Icon ROI_ICON;
    private static Icon ROI__OTHER_OWNER_ICON;
    private long userID;

    public ROITableCellRenderer() {
        this.setOpaque(false);
        this.userID = MeasurementAgent.getUserDetails().getId();
    }

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        Object thisObject = ((ROINode)((Object)value)).getUserObject();
        if (thisObject instanceof ROI) {
            ROI roi = (ROI)thisObject;
            if (this.userID == roi.getOwnerID() || roi.getOwnerID() == -1L) {
                this.setIcon(ROI_ICON);
            } else {
                this.setIcon(ROI__OTHER_OWNER_ICON);
            }
        } else if (thisObject instanceof ROIShape) {
            this.setIcon(SHAPE_ICON);
        }
        return this;
    }

    static {
        IconManager icons = IconManager.getInstance();
        SHAPE_ICON = icons.getIcon(29);
        ROI_ICON = icons.getIcon(28);
        ROI__OTHER_OWNER_ICON = icons.getIcon(46);
    }
}

