/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.measurement.util.roimenu;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.openmicroscopy.shoola.agents.measurement.util.actions.ROIAction;
import org.openmicroscopy.shoola.agents.measurement.util.roitable.ROIActionController;

public class ROIPopupMenu {
    static final String POPUP_MENU_DESCRIPTION = "Manager Options";
    static final String ROI_CREATION_OPTIONS = "ROI Management Options";
    static final String ROI_STATS_OPTIONS = "ROI Stats Options";
    private JPopupMenu popupMenu;
    private ROIActionController controller;
    private List<ROIAction> actions;

    public ROIPopupMenu(ROIActionController controller) {
        this.controller = controller;
        this.actions = new ArrayList<ROIAction>();
        this.createPopupMenu();
    }

    private JMenu createROICreationOptions() {
        JMenu roiOptionsParent = new JMenu(ROI_CREATION_OPTIONS);
        ROIActionController.CreationActionType[] values = ROIActionController.CreationActionType.values();
        for (int indexCnt = 0; indexCnt < values.length; ++indexCnt) {
            ROIAction action = new ROIAction(this.controller, values[indexCnt]);
            this.actions.add(action);
            JMenuItem roiOption = new JMenuItem(action);
            roiOptionsParent.add(roiOption);
        }
        return roiOptionsParent;
    }

    private void createPopupMenu() {
        this.popupMenu = new JPopupMenu(POPUP_MENU_DESCRIPTION);
        this.popupMenu.add(new JMenuItem(POPUP_MENU_DESCRIPTION));
        this.popupMenu.addSeparator();
        this.popupMenu.add(this.createROICreationOptions());
    }

    public void setActionsEnabled(boolean enabled) {
        Iterator<ROIAction> i = this.actions.iterator();
        while (i.hasNext()) {
            i.next().setEnabled(enabled);
        }
    }

    public JPopupMenu getPopupMenu() {
        return this.popupMenu;
    }
}

