/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.measurement;

import org.openmicroscopy.shoola.agents.measurement.MeasurementAgent;
import org.openmicroscopy.shoola.agents.measurement.view.MeasurementViewer;
import org.openmicroscopy.shoola.env.config.Registry;
import org.openmicroscopy.shoola.env.data.events.DSCallAdapter;
import org.openmicroscopy.shoola.env.data.views.ImageDataView;
import org.openmicroscopy.shoola.env.log.LogMessage;

public abstract class MeasurementViewerLoader
extends DSCallAdapter {
    protected final MeasurementViewer viewer;
    protected final Registry registry;
    protected final ImageDataView idView;

    protected MeasurementViewerLoader(MeasurementViewer viewer) {
        if (viewer == null) {
            throw new NullPointerException("No viewer.");
        }
        this.viewer = viewer;
        this.registry = MeasurementAgent.getRegistry();
        this.idView = (ImageDataView)this.registry.getDataServicesView(ImageDataView.class);
    }

    public void onEnd() {
    }

    public void handleNullResult() {
        this.handleException(new Exception("No data available."));
    }

    public void handleCancellation() {
        String info = "The data retrieval has been cancelled.";
        this.registry.getLogger().info((Object)this, info);
    }

    public void handleException(Throwable exc) {
        int state = this.viewer.getState();
        String s = "Data Retrieval Failure: ";
        LogMessage msg = new LogMessage();
        msg.print("State: " + state);
        msg.print(s);
        msg.print(exc);
        this.registry.getLogger().error((Object)this, msg);
        if (state != 6) {
            this.registry.getUserNotifier().notifyError("Data Retrieval Failure", s, exc);
        }
        this.viewer.cancel();
    }

    public abstract void load();

    public abstract void cancel();
}

