/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.imviewer.view;

import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.prefs.Preferences;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openmicroscopy.shoola.agents.events.iviewer.SaveRelatedData;
import org.openmicroscopy.shoola.agents.imviewer.ImViewerAgent;
import org.openmicroscopy.shoola.agents.imviewer.actions.ActivateRecentAction;
import org.openmicroscopy.shoola.agents.imviewer.actions.ActivationAction;
import org.openmicroscopy.shoola.agents.imviewer.view.ImViewer;
import org.openmicroscopy.shoola.agents.imviewer.view.ImViewerComponent;
import org.openmicroscopy.shoola.agents.imviewer.view.ImViewerModel;
import org.openmicroscopy.shoola.agents.imviewer.view.ImViewerRecentObject;
import org.openmicroscopy.shoola.agents.imviewer.view.ViewerPreferences;
import org.openmicroscopy.shoola.env.rnd.RndProxyDef;
import org.openmicroscopy.shoola.env.ui.TaskBar;
import pojos.DataObject;
import pojos.ImageData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImViewerFactory
implements ChangeListener,
PropertyChangeListener {
    private static final String OMERO_VIEWER_COMPRESSION = "omeroViewerCompression";
    private static final String NAME = "Viewer: ";
    private static final String MENU_NAME = "Image Viewer";
    private static final String RECENT_MENU = "Open Recent";
    private static final String CLEAR_MENU = "Clear menu";
    private static final int MAX_RECENT = 10;
    private static final ImViewerFactory singleton = new ImViewerFactory();
    private Set<ImViewer> viewers = new HashSet<ImViewer>();
    private List<ImViewerRecentObject> recentViewers = new ArrayList<ImViewerRecentObject>();
    private JMenu windowMenu = new JMenu("Image Viewer");
    private JMenu recentMenu = new JMenu("Open Recent");
    private JMenuItem clearMenu = new JMenuItem("Clear menu");
    private boolean isAttached = false;
    private ImageData refImage;
    private ViewerPreferences pref;

    static void register(JMenu menu) {
        if (menu == null) {
            return;
        }
        Iterator<ImViewer> i = ImViewerFactory.singleton.viewers.iterator();
        menu.removeAll();
        while (i.hasNext()) {
            menu.add(new JMenuItem(new ActivationAction(i.next())));
        }
        int n = ImViewerFactory.singleton.recentViewers.size();
        if (n > 0) {
            Iterator<ImViewerRecentObject> j = ImViewerFactory.singleton.recentViewers.iterator();
            ImViewerFactory.singleton.recentMenu.removeAll();
            while (j.hasNext()) {
                ImViewerFactory.singleton.recentMenu.add(new JMenuItem(new ActivateRecentAction(j.next())));
            }
            ImViewerFactory.singleton.recentMenu.add(new JSeparator());
            ImViewerFactory.singleton.recentMenu.add(ImViewerFactory.singleton.clearMenu);
            menu.add(ImViewerFactory.singleton.recentMenu);
        }
    }

    static JMenu getWindowMenu() {
        return ImViewerFactory.singleton.windowMenu;
    }

    static void attachWindowMenuToTaskBar() {
        if (ImViewerFactory.singleton.isAttached) {
            return;
        }
        TaskBar tb = ImViewerAgent.getRegistry().getTaskBar();
        tb.addToMenu(0, ImViewerFactory.singleton.windowMenu);
        ImViewerFactory.singleton.isAttached = true;
    }

    public static void onGroupSwitched(boolean success) {
        if (!success) {
            return;
        }
        singleton.clear();
    }

    public static ImViewer getImageViewer(DataObject image, Rectangle bounds, boolean separateWindow) {
        ImViewerModel model = new ImViewerModel(image, bounds, separateWindow);
        return singleton.getViewer(model);
    }

    public static ImViewer getImageViewer(long imageID, Rectangle bounds, boolean separateWindow) {
        ImViewerModel model = new ImViewerModel(imageID, bounds, separateWindow);
        return singleton.getViewer(model);
    }

    public static ImViewer getImageViewer(long pixelsID) {
        for (ImViewerComponent imViewerComponent : ImViewerFactory.singleton.viewers) {
            if (imViewerComponent.getModel().getPixelsID() != pixelsID) continue;
            return imViewerComponent;
        }
        return null;
    }

    public static ImViewer getImageViewerFromParent(DataObject parent) {
        if (parent == null) {
            return null;
        }
        for (ImViewerComponent imViewerComponent : ImViewerFactory.singleton.viewers) {
            if (!imViewerComponent.getModel().isSameParent(parent)) continue;
            return imViewerComponent;
        }
        return null;
    }

    public static void copyRndSettings(ImageData image) {
        ImViewerFactory.singleton.refImage = image;
        for (ImViewerComponent imViewerComponent : ImViewerFactory.singleton.viewers) {
            if (imViewerComponent.getModel().getImageID() == image.getId()) continue;
            imViewerComponent.copyRndSettings();
        }
    }

    public static void rndSettingsSaved(long pixelsID, RndProxyDef settings) {
        for (ImViewerComponent imViewerComponent : ImViewerFactory.singleton.viewers) {
            if (imViewerComponent.getModel().getPixelsID() != pixelsID) continue;
            imViewerComponent.onRndSettingsSaved(settings);
        }
    }

    public static void storeEvent(SaveRelatedData evt) {
        Iterator<ImViewer> v = ImViewerFactory.singleton.viewers.iterator();
        long pixelsID = evt.getPixelsID();
        while (v.hasNext()) {
            ImViewerComponent comp = (ImViewerComponent)v.next();
            if (comp.getModel().getPixelsID() != pixelsID) continue;
            comp.storeEvent(evt);
        }
    }

    public static List<Object> getInstancesToSave() {
        if (ImViewerFactory.singleton.viewers.size() == 0) {
            return null;
        }
        ArrayList<Object> instances = new ArrayList<Object>();
        for (ImViewerComponent imViewerComponent : ImViewerFactory.singleton.viewers) {
            if (imViewerComponent.isOriginalSettings()) continue;
            instances.add(imViewerComponent);
        }
        return instances;
    }

    public static void saveInstances(List<Object> instances) {
        if (instances != null) {
            for (Object o : instances) {
                if (!(o instanceof ImViewerComponent)) continue;
                ImViewerComponent comp = (ImViewerComponent)o;
                comp.close(false);
                ImViewerFactory.singleton.viewers.remove(comp);
                ImViewerFactory.singleton.recentViewers.remove(comp);
            }
        }
    }

    static ImageData getRefImage() {
        return ImViewerFactory.singleton.refImage;
    }

    static ViewerPreferences getPreferences() {
        return ImViewerFactory.singleton.pref;
    }

    static void setPreferences(ViewerPreferences pref) {
        ImViewerFactory.singleton.pref = null;
    }

    static void setCompressionLevel(int level) {
        Preferences p = Preferences.userNodeForPackage(ImViewerFactory.class);
        p.put(OMERO_VIEWER_COMPRESSION, "" + level);
    }

    static int getCompressionLevel() {
        Preferences p = Preferences.userNodeForPackage(ImViewerFactory.class);
        String value = p.get(OMERO_VIEWER_COMPRESSION, null);
        if (value != null && value.trim().length() > 0) {
            return Integer.parseInt(value);
        }
        return -1;
    }

    private ImViewerFactory() {
        this.clearMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                singleton.recentViewers.clear();
            }
        });
    }

    private void clear() {
        for (ImViewerComponent imViewerComponent : this.viewers) {
            imViewerComponent.removeChangeListener(this);
            imViewerComponent.discard();
        }
        ImViewerFactory.singleton.viewers.clear();
        ImViewerFactory.singleton.recentViewers.clear();
    }

    private ImViewer getViewer(ImViewerModel model) {
        for (ImViewerComponent imViewerComponent : this.viewers) {
            if (imViewerComponent.getModel().getPixelsID() != model.getPixelsID()) continue;
            return imViewerComponent;
        }
        ImViewerComponent imViewerComponent = new ImViewerComponent(model);
        imViewerComponent.initialize();
        imViewerComponent.addChangeListener(this);
        imViewerComponent.addPropertyChangeListener(this);
        this.viewers.add(imViewerComponent);
        long id = model.getImageID();
        if (id < 0L) {
            return null;
        }
        Iterator<ImViewerRecentObject> j = this.recentViewers.iterator();
        ImViewerRecentObject toRemove = null;
        while (j.hasNext()) {
            ImViewerRecentObject obj = j.next();
            if (obj.getImageID() != id) continue;
            toRemove = obj;
        }
        if (toRemove != null) {
            this.recentViewers.remove(toRemove);
        }
        return imViewerComponent;
    }

    @Override
    public void stateChanged(ChangeEvent ce) {
        ImViewerComponent comp = (ImViewerComponent)ce.getSource();
        if (comp.getState() == 7) {
            this.viewers.remove(comp);
            this.recentViewers.remove(comp);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String name = evt.getPropertyName();
        if ("reventViewer".equals(name)) {
            Iterator<ImViewerRecentObject> i = this.recentViewers.iterator();
            ImViewerRecentObject v = (ImViewerRecentObject)evt.getNewValue();
            ImViewerRecentObject exist = null;
            while (i.hasNext()) {
                ImViewerRecentObject old = i.next();
                if (old.getImageID() != v.getImageID()) continue;
                exist = old;
            }
            if (exist != null) {
                this.recentViewers.remove(exist);
            }
            if (this.recentViewers.size() >= 10) {
                this.recentViewers.remove(0);
            }
            this.recentViewers.add(v);
        }
    }
}

