/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.imviewer.view;

import java.awt.Color;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuKeyEvent;
import javax.swing.event.MenuKeyListener;
import javax.swing.event.MenuListener;
import org.openmicroscopy.shoola.agents.imviewer.actions.ActivityImageAction;
import org.openmicroscopy.shoola.agents.imviewer.actions.ChannelMovieAction;
import org.openmicroscopy.shoola.agents.imviewer.actions.ChannelsSelectionAction;
import org.openmicroscopy.shoola.agents.imviewer.actions.ClearHistoryAction;
import org.openmicroscopy.shoola.agents.imviewer.actions.CloseAction;
import org.openmicroscopy.shoola.agents.imviewer.actions.ColorModelAction;
import org.openmicroscopy.shoola.agents.imviewer.actions.ColorPickerAction;
import org.openmicroscopy.shoola.agents.imviewer.actions.CompressionAction;
import org.openmicroscopy.shoola.agents.imviewer.actions.DetachAction;
import org.openmicroscopy.shoola.agents.imviewer.actions.HistoryAction;
import org.openmicroscopy.shoola.agents.imviewer.actions.LensAction;
import org.openmicroscopy.shoola.agents.imviewer.actions.ManageRndSettingsAction;
import org.openmicroscopy.shoola.agents.imviewer.actions.MetadataAction;
import org.openmicroscopy.shoola.agents.imviewer.actions.MovieAction;
import org.openmicroscopy.shoola.agents.imviewer.actions.PlayMovieAction;
import org.openmicroscopy.shoola.agents.imviewer.actions.PreferencesAction;
import org.openmicroscopy.shoola.agents.imviewer.actions.ProjectionProjectAction;
import org.openmicroscopy.shoola.agents.imviewer.actions.ROIToolAction;
import org.openmicroscopy.shoola.agents.imviewer.actions.RefreshAction;
import org.openmicroscopy.shoola.agents.imviewer.actions.RendererAction;
import org.openmicroscopy.shoola.agents.imviewer.actions.SaveAction;
import org.openmicroscopy.shoola.agents.imviewer.actions.SaveRndSettingsAction;
import org.openmicroscopy.shoola.agents.imviewer.actions.ShowViewAction;
import org.openmicroscopy.shoola.agents.imviewer.actions.TextVisibleAction;
import org.openmicroscopy.shoola.agents.imviewer.actions.UnitBarAction;
import org.openmicroscopy.shoola.agents.imviewer.actions.UnitBarSizeAction;
import org.openmicroscopy.shoola.agents.imviewer.actions.UserAction;
import org.openmicroscopy.shoola.agents.imviewer.actions.ViewerAction;
import org.openmicroscopy.shoola.agents.imviewer.actions.ZoomAction;
import org.openmicroscopy.shoola.agents.imviewer.actions.ZoomGridAction;
import org.openmicroscopy.shoola.agents.imviewer.util.PlaneInfoComponent;
import org.openmicroscopy.shoola.agents.imviewer.util.player.MoviePlayerDialog;
import org.openmicroscopy.shoola.agents.imviewer.util.proj.ProjectionRef;
import org.openmicroscopy.shoola.agents.imviewer.view.ImViewer;
import org.openmicroscopy.shoola.agents.imviewer.view.ImViewerFactory;
import org.openmicroscopy.shoola.agents.imviewer.view.ImViewerUI;
import org.openmicroscopy.shoola.agents.imviewer.view.ViewerPreferences;
import org.openmicroscopy.shoola.util.ui.ClosableTabbedPaneComponent;
import org.openmicroscopy.shoola.util.ui.LoadingWindow;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import org.openmicroscopy.shoola.util.ui.colourpicker.ColourPicker;
import pojos.ExperimenterData;
import pojos.ImageData;
import pojos.PixelsData;
import pojos.WellSampleData;

class ImViewerControl
implements ActionListener,
ChangeListener,
ComponentListener,
PropertyChangeListener,
WindowFocusListener {
    static final Integer CLOSE = 0;
    static final Integer RENDERER = 1;
    static final Integer MOVIE = 2;
    static final Integer SAVE = 3;
    static final Integer ZOOM_25 = 4;
    static final Integer ZOOM_50 = 5;
    static final Integer ZOOM_75 = 6;
    static final Integer ZOOM_100 = 7;
    static final Integer ZOOM_125 = 8;
    static final Integer ZOOM_150 = 9;
    static final Integer ZOOM_175 = 10;
    static final Integer ZOOM_200 = 11;
    static final Integer ZOOM_225 = 12;
    static final Integer ZOOM_250 = 13;
    static final Integer ZOOM_275 = 14;
    static final Integer ZOOM_300 = 15;
    static final Integer ZOOM_FIT_TO_WINDOW = 16;
    static final Integer LENS = 17;
    static final Integer GREY_SCALE_MODEL = 18;
    static final Integer RGB_MODEL = 19;
    static final Integer HSB_MODEL = 20;
    static final Integer CHANNEL_MOVIE = 26;
    static final Integer UNIT_BAR = 27;
    static final Integer UNIT_BAR_ONE = 28;
    static final Integer UNIT_BAR_TWO = 29;
    static final Integer UNIT_BAR_FIVE = 30;
    static final Integer UNIT_BAR_TEN = 31;
    static final Integer UNIT_BAR_TWENTY = 32;
    static final Integer UNIT_BAR_FIFTY = 33;
    static final Integer UNIT_BAR_HUNDRED = 34;
    static final Integer UNIT_BAR_CUSTOM = 35;
    static final Integer COLOR_PICKER = 36;
    static final Integer TEXT_VISIBLE = 38;
    static final Integer MEASUREMENT_TOOL = 39;
    static final Integer PLAY_MOVIE_T = 44;
    static final Integer PLAY_MOVIE_Z = 45;
    static final Integer PREFERENCES = 47;
    static final Integer USER = 48;
    static final Integer ZOOM_GRID_25 = 49;
    static final Integer ZOOM_GRID_50 = 50;
    static final Integer ZOOM_GRID_75 = 51;
    static final Integer ZOOM_GRID_100 = 52;
    static final Integer TAB_VIEW = 54;
    static final Integer TAB_PROJECTION = 55;
    static final Integer TAB_GRID = 56;
    static final Integer HISTORY = 57;
    static final Integer PASTE_RND_SETTINGS = 58;
    static final Integer COPY_RND_SETTINGS = 59;
    static final Integer SAVE_RND_SETTINGS = 60;
    static final Integer RESET_RND_SETTINGS = 61;
    static final Integer SET_RND_SETTINGS_MIN_MAX = 62;
    static final Integer SET_OWNER_RND_SETTINGS = 63;
    static final Integer UNDO_RND_SETTINGS = 64;
    static final Integer PROJECTION_PROJECT = 66;
    static final Integer COMPRESSION = 67;
    static final Integer CLEAR_HISTORY = 68;
    static final Integer METADATA = 69;
    static final Integer PLAY_LIFETIME_MOVIE = 70;
    static final Integer CHANNELS_ON = 71;
    static final Integer CHANNELS_OFF = 72;
    static final Integer ACTIVITY = 73;
    static final Integer DETACH = 74;
    static final Integer REFRESH = 75;
    private ImViewer model;
    private ImViewerUI view;
    private Map<Integer, ViewerAction> actionsMap;
    private int historyState;
    private int colorPickerIndex;
    private MoviePlayerDialog moviePlayer;

    private void createActions() {
        this.actionsMap.put(RENDERER, new RendererAction(this.model));
        this.actionsMap.put(MOVIE, new MovieAction(this.model));
        this.actionsMap.put(SAVE, new SaveAction(this.model));
        this.actionsMap.put(ZOOM_25, new ZoomAction(this.model, 0));
        this.actionsMap.put(ZOOM_50, new ZoomAction(this.model, 1));
        this.actionsMap.put(ZOOM_75, new ZoomAction(this.model, 2));
        this.actionsMap.put(ZOOM_100, new ZoomAction(this.model, 3));
        this.actionsMap.put(ZOOM_125, new ZoomAction(this.model, 4));
        this.actionsMap.put(ZOOM_150, new ZoomAction(this.model, 5));
        this.actionsMap.put(ZOOM_175, new ZoomAction(this.model, 6));
        this.actionsMap.put(ZOOM_200, new ZoomAction(this.model, 7));
        this.actionsMap.put(ZOOM_225, new ZoomAction(this.model, 8));
        this.actionsMap.put(ZOOM_250, new ZoomAction(this.model, 9));
        this.actionsMap.put(ZOOM_275, new ZoomAction(this.model, 10));
        this.actionsMap.put(ZOOM_300, new ZoomAction(this.model, 11));
        this.actionsMap.put(ZOOM_FIT_TO_WINDOW, new ZoomAction(this.model, 12));
        this.actionsMap.put(LENS, new LensAction(this.model));
        this.actionsMap.put(GREY_SCALE_MODEL, new ColorModelAction(this.model, 0));
        this.actionsMap.put(RGB_MODEL, new ColorModelAction(this.model, 1));
        this.actionsMap.put(HSB_MODEL, new ColorModelAction(this.model, 2));
        this.actionsMap.put(CHANNEL_MOVIE, new ChannelMovieAction(this.model));
        this.actionsMap.put(UNIT_BAR, new UnitBarAction(this.model));
        this.actionsMap.put(UNIT_BAR_ONE, new UnitBarSizeAction(this.model, 0));
        this.actionsMap.put(UNIT_BAR_TWO, new UnitBarSizeAction(this.model, 1));
        this.actionsMap.put(UNIT_BAR_FIVE, new UnitBarSizeAction(this.model, 2));
        this.actionsMap.put(UNIT_BAR_TEN, new UnitBarSizeAction(this.model, 3));
        this.actionsMap.put(UNIT_BAR_TWENTY, new UnitBarSizeAction(this.model, 4));
        this.actionsMap.put(UNIT_BAR_FIFTY, new UnitBarSizeAction(this.model, 5));
        this.actionsMap.put(UNIT_BAR_HUNDRED, new UnitBarSizeAction(this.model, 6));
        this.actionsMap.put(UNIT_BAR_CUSTOM, new UnitBarSizeAction(this.model, 7));
        this.actionsMap.put(COLOR_PICKER, new ColorPickerAction(this.model));
        this.actionsMap.put(TEXT_VISIBLE, new TextVisibleAction(this.model));
        this.actionsMap.put(MEASUREMENT_TOOL, new ROIToolAction(this.model));
        this.actionsMap.put(PLAY_MOVIE_T, new PlayMovieAction(this.model, 301));
        this.actionsMap.put(PLAY_MOVIE_Z, new PlayMovieAction(this.model, 300));
        this.actionsMap.put(PREFERENCES, new PreferencesAction(this.model));
        this.actionsMap.put(USER, new UserAction(this.model));
        this.actionsMap.put(ZOOM_GRID_25, new ZoomGridAction(this.model, 0));
        this.actionsMap.put(ZOOM_GRID_50, new ZoomGridAction(this.model, 1));
        this.actionsMap.put(ZOOM_GRID_75, new ZoomGridAction(this.model, 2));
        this.actionsMap.put(ZOOM_GRID_100, new ZoomGridAction(this.model, 3));
        this.actionsMap.put(TAB_VIEW, new ShowViewAction(this.model, 0));
        this.actionsMap.put(TAB_PROJECTION, new ShowViewAction(this.model, 2));
        this.actionsMap.put(TAB_GRID, new ShowViewAction(this.model, 1));
        this.actionsMap.put(HISTORY, new HistoryAction(this.model));
        this.actionsMap.put(PASTE_RND_SETTINGS, new ManageRndSettingsAction(this.model, 1));
        this.actionsMap.put(COPY_RND_SETTINGS, new ManageRndSettingsAction(this.model, 0));
        this.actionsMap.put(SAVE_RND_SETTINGS, new SaveRndSettingsAction(this.model));
        this.actionsMap.put(RESET_RND_SETTINGS, new ManageRndSettingsAction(this.model, 2));
        this.actionsMap.put(SET_OWNER_RND_SETTINGS, new ManageRndSettingsAction(this.model, 4));
        this.actionsMap.put(SET_RND_SETTINGS_MIN_MAX, new ManageRndSettingsAction(this.model, 3));
        this.actionsMap.put(UNDO_RND_SETTINGS, new ManageRndSettingsAction(this.model, 5));
        this.actionsMap.put(PROJECTION_PROJECT, new ProjectionProjectAction(this.model));
        this.actionsMap.put(COMPRESSION, new CompressionAction(this.model));
        this.actionsMap.put(CLEAR_HISTORY, new ClearHistoryAction(this.model));
        this.actionsMap.put(METADATA, new MetadataAction(this.model));
        this.actionsMap.put(CHANNELS_ON, new ChannelsSelectionAction(this.model, true));
        this.actionsMap.put(CHANNELS_OFF, new ChannelsSelectionAction(this.model, false));
        this.actionsMap.put(ACTIVITY, new ActivityImageAction(this.model));
        this.actionsMap.put(CLOSE, new CloseAction(this.model));
        this.actionsMap.put(DETACH, new DetachAction(this.model));
        this.actionsMap.put(REFRESH, new RefreshAction(this.model));
        this.actionsMap.put(PLAY_LIFETIME_MOVIE, new PlayMovieAction(this.model, 301));
    }

    private void attachListeners() {
        this.model.addChangeListener(this);
        this.model.addPropertyChangeListener(this);
        JMenu menu = ImViewerFactory.getWindowMenu();
        menu.addMenuListener(new MenuListener(){

            public void menuSelected(MenuEvent e) {
                Object source = e.getSource();
                if (source instanceof JMenu) {
                    ImViewerFactory.register((JMenu)source);
                }
            }

            public void menuCanceled(MenuEvent e) {
            }

            public void menuDeselected(MenuEvent e) {
            }
        });
        menu.addMenuKeyListener(new MenuKeyListener(){

            public void menuKeyReleased(MenuKeyEvent e) {
                Object source = e.getSource();
                if (source instanceof JMenu) {
                    ImViewerFactory.register((JMenu)source);
                }
            }

            public void menuKeyPressed(MenuKeyEvent e) {
            }

            public void menuKeyTyped(MenuKeyEvent e) {
            }
        });
        this.view.setDefaultCloseOperation(0);
        this.view.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                ImViewerControl.this.model.close(true);
            }

            public void windowDeiconified(WindowEvent e) {
                ImViewerControl.this.model.iconified(false);
            }

            public void windowIconified(WindowEvent e) {
                ImViewerControl.this.model.iconified(true);
            }
        });
        this.view.getLoadingWindow().addPropertyChangeListener("closed", this);
        this.view.addWindowFocusListener(this);
    }

    ImViewerControl() {
    }

    void initialize(ImViewer model, ImViewerUI view) {
        if (model == null) {
            throw new NullPointerException("No model.");
        }
        if (view == null) {
            throw new NullPointerException("No view.");
        }
        this.model = model;
        this.view = view;
        this.historyState = -1;
        this.colorPickerIndex = -1;
        this.actionsMap = new HashMap<Integer, ViewerAction>();
        this.createActions();
        this.attachListeners();
        ImViewerFactory.attachWindowMenuToTaskBar();
    }

    ViewerAction getAction(Integer id) {
        return this.actionsMap.get(id);
    }

    void setSelectedXYPlane(int z, int t, int bin) {
        this.model.setSelectedXYPlane(z, t, bin);
    }

    int getHistoryState() {
        return this.historyState;
    }

    void setHistoryState(int s) {
        this.historyState = s;
    }

    void showColorPicker(int index) {
        this.colorPickerIndex = index;
        Color c = this.model.getChannelColor(index);
        ColourPicker dialog = new ColourPicker((JFrame)this.view, c);
        dialog.addPropertyChangeListener(this);
        UIUtilities.setLocationRelativeToAndShow(this.view, dialog);
    }

    MoviePlayerDialog getMoviePlayer() {
        if (this.moviePlayer != null) {
            return this.moviePlayer;
        }
        this.moviePlayer = new MoviePlayerDialog(this.view, this.model);
        this.moviePlayer.addPropertyChangeListener("close", this);
        return this.moviePlayer;
    }

    void setZoomFactor(int zoomIndex) {
        double f = ZoomAction.getZoomFactor(zoomIndex);
        this.model.setZoomFactor(f, zoomIndex);
    }

    void toFront() {
        if (this.view.getExtendedState() != 0) {
            return;
        }
        if (!this.view.isFocused()) {
            this.view.removeWindowFocusListener(this);
            this.view.setVisible(true);
        }
    }

    void setPreferences() {
        int index;
        Rectangle bounds;
        ViewerPreferences pref = ImViewerFactory.getPreferences();
        if (pref == null) {
            pref = new ViewerPreferences();
        }
        if ((bounds = this.view.getBounds()) != null) {
            pref.setViewerBounds(bounds);
        }
        if ((index = this.view.getZoomIndex()) > 0) {
            pref.setZoomIndex(index);
        }
        pref.setRenderer(this.view.isRendererShown());
        pref.setHistory(this.view.isHistoryShown());
        Color c = this.model.getUnitBarColor();
        if (c != null) {
            pref.setScaleBarColor(c);
        }
        if ((index = this.view.getScaleBarIndex()) > 0) {
            pref.setScaleBarIndex(index);
        }
        ImViewerFactory.setPreferences(pref);
    }

    void setGridMagnificationFactor(double factor) {
        this.model.setGridMagnificationFactor(factor);
    }

    void setProjectionRange(boolean released) {
        this.view.setLeftStatus();
        this.view.setPlaneInfoStatus();
        if (released) {
            this.model.renderXYPlane();
        }
    }

    void renderOverlays(boolean selected) {
        this.model.renderOverlays(-1, selected);
    }

    public void actionPerformed(ActionEvent e) {
        String m = this.model.getColorModel();
        ViewerAction a = null;
        if ("rgb".equals(m)) {
            a = this.getAction(GREY_SCALE_MODEL);
            a.actionPerformed(e);
        } else if ("greyscale".equals(m)) {
            a = this.getAction(RGB_MODEL);
            a.actionPerformed(e);
        }
    }

    public void stateChanged(ChangeEvent e) {
        if (e.getSource() instanceof JTabbedPane) {
            JTabbedPane pane = (JTabbedPane)e.getSource();
            Component c = pane.getSelectedComponent();
            if (c instanceof ClosableTabbedPaneComponent) {
                int index = ((ClosableTabbedPaneComponent)c).getIndex();
                this.model.setSelectedPane(index);
            }
            return;
        }
        int state = this.model.getState();
        switch (state) {
            case 7: {
                LoadingWindow window = this.view.getLoadingWindow();
                window.setVisible(false);
                window.dispose();
                this.view.setVisible(false);
                if (this.view.isLensVisible()) {
                    this.view.setLensVisible(false, this.model.getSelectedIndex());
                }
                this.view.dispose();
                this.historyState = state;
                break;
            }
            case 3: {
                if (this.historyState == 4) {
                    this.view.getLoadingWindow().setVisible(false);
                }
                this.view.onStateChange(false);
                this.historyState = state;
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                this.view.setStatus(true);
                this.view.onStateChange(false);
                break;
            }
            case 6: {
                this.view.setStatus(false);
                this.view.getLoadingWindow().setVisible(false);
                if (this.historyState == 8) {
                    this.view.onStateChange(false);
                    break;
                }
                this.view.onStateChange(true);
                this.historyState = state;
                break;
            }
            case 8: {
                this.historyState = 8;
                this.view.onStateChange(false);
            }
        }
    }

    public void propertyChange(PropertyChangeEvent pce) {
        String pName = pce.getPropertyName();
        if ("zSelected".equals(pName)) {
            this.view.setZSection((Integer)pce.getNewValue());
        } else if ("tSelected".equals(pName)) {
            this.view.setTimepoint((Integer)pce.getNewValue());
        } else if ("channelSelected".equals(pName)) {
            Map map = (Map)pce.getNewValue();
            if (map == null) {
                return;
            }
            if (map.size() != 1) {
                return;
            }
            Set set = map.entrySet();
            for (Map.Entry entry : set) {
                Integer index = (Integer)entry.getKey();
                this.model.setChannelSelection(index, (Boolean)entry.getValue());
            }
        } else if ("channelOverlay".equals(pName)) {
            Map map = (Map)pce.getNewValue();
            if (map == null) {
                return;
            }
            if (map.size() != 1) {
                return;
            }
            Set set = map.entrySet();
            for (Map.Entry entry : set) {
                Integer index = (Integer)entry.getKey();
                this.model.renderOverlays(index, (Boolean)entry.getValue());
            }
        } else if ("closed".equals(pName)) {
            this.model.discard();
        } else if ("renderPlane".equals(pName)) {
            this.model.renderXYPlane();
        } else if ("rndLoaded".equals(pName)) {
            boolean b = (Boolean)pce.getNewValue();
            this.model.onRndLoaded(b);
        } else if ("channelColor".equals(pName)) {
            this.model.showColorPicker((Integer)pce.getNewValue());
        } else if ("channelColour".equals(pName) || "channelColor".equals(pName)) {
            if (this.view.isSourceDisplayed(pce.getSource())) {
                this.model.showColorPicker((Integer)pce.getNewValue());
            }
        } else if ("colour".equals(pName)) {
            Color c = (Color)pce.getNewValue();
            if (this.colorPickerIndex != -1) {
                this.model.setChannelColor(this.colorPickerIndex, c);
            }
        } else if ("unitBarValue".equals(pName)) {
            double v = (Double)pce.getNewValue();
            this.model.setUnitBarSize(v);
        } else if ("iconified".equals(pName)) {
            if (this.moviePlayer != null) {
                this.model.playMovie(false, false, -1);
            }
            this.view.onIconified();
        } else if ("lensLocation".equals(pName)) {
            this.view.scrollToNode((Rectangle)pce.getNewValue());
        } else if ("close".equals(pName)) {
            this.model.playMovie(false, false, -1);
        } else if ("movieStateChanged".equals(pName)) {
            boolean b = (Boolean)pce.getNewValue();
            if (!b && !this.getMoviePlayer().isVisible()) {
                PlayMovieAction action = (PlayMovieAction)this.getAction(PLAY_MOVIE_T);
                action.setActionIcon(true);
                action = (PlayMovieAction)this.getAction(PLAY_MOVIE_Z);
                action.setActionIcon(true);
                this.model.playMovie(false, false, -1);
            }
        } else if ("viewerPref".equals(pName)) {
            ViewerPreferences pref;
            Map map = (Map)pce.getNewValue();
            if (map == null) {
                ImViewerFactory.setPreferences(null);
            }
            if ((pref = ImViewerFactory.getPreferences()) == null) {
                pref = new ViewerPreferences();
            }
            pref.setSelectedFields(map);
            ImViewerFactory.setPreferences(pref);
        } else if ("userRndSettings".equals(pName)) {
            ExperimenterData exp = (ExperimenterData)pce.getNewValue();
            this.model.setUserRndSettings(exp);
        } else if ("projection".equals(pName)) {
            this.model.projectImage((ProjectionRef)pce.getNewValue());
        } else if ("planeInfo".equals(pName)) {
            this.view.showPlaneInfoDetails((PlaneInfoComponent)pce.getNewValue());
        } else if ("closedDialog".equals(pName)) {
            this.view.hidePlaneInfoDetails();
        } else if ("loadAll".equals(pName)) {
            this.model.loadAllContainers();
        } else if ("selectedChannel".equals(pName)) {
            int index = (Integer)pce.getNewValue();
            this.model.onChannelSelection(index);
        } else if ("closeRenderer".equals(pName)) {
            PixelsData pixs;
            Object ref = pce.getNewValue();
            ImageData image = null;
            if (ref instanceof ImageData) {
                image = (ImageData)ref;
            } else if (ref instanceof WellSampleData) {
                image = ((WellSampleData)ref).getImage();
            }
            if (image != null && (pixs = image.getDefaultPixels()) != null && pixs.getId() == this.view.getPixelsID()) {
                this.model.discard();
            }
        } else if ("channelColorChanged".equals(pName)) {
            int index = (Integer)pce.getNewValue();
            this.model.onChannelColorChanged(index);
        }
    }

    public void componentResized(ComponentEvent e) {
        if (this.model.isZoomFitToWindow()) {
            this.model.setZoomFactor(-1.0, 12);
        }
        this.view.maximizeWindow();
        this.setPreferences();
    }

    public void windowGainedFocus(WindowEvent e) {
    }

    public void windowLostFocus(WindowEvent e) {
    }

    public void componentShown(ComponentEvent e) {
    }

    public void componentHidden(ComponentEvent e) {
    }

    public void componentMoved(ComponentEvent e) {
    }
}

