/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.imviewer.util.player;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.TitledBorder;
import org.openmicroscopy.shoola.agents.imviewer.IconManager;
import org.openmicroscopy.shoola.agents.imviewer.util.player.MoviePlayer;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import org.openmicroscopy.shoola.util.ui.slider.TwoKnobsSlider;

class MoviePlayerUI
extends JPanel {
    private static final int MAX_RANGE = 100;
    private static final int LOOP_CMD = 0;
    private static final int LOOP_BACKWARD_CMD = 1;
    private static final int BACKWARD_CMD = 2;
    private static final int FORWARD_CMD = 3;
    private static final int PINGPONG_CMD = 4;
    private static final String[] selections = new String[5];
    private int charWidth;
    private MoviePlayer model;
    private JToolBar toolBar;
    JButton play;
    JButton pause;
    JButton stop;
    JSpinner fps;
    JTextField editor;
    JComboBox movieTypes;
    JTextField startZ;
    JTextField endZ;
    JTextField startT;
    JTextField endT;
    JCheckBox acrossZ;
    JCheckBox acrossT;
    TwoKnobsSlider zSlider;
    TwoKnobsSlider tSlider;

    private int getMovieTypeIndex(int v) {
        switch (v) {
            case 200: {
                return 0;
            }
            case 201: {
                return 2;
            }
            case 202: {
                return 3;
            }
            case 203: {
                return 4;
            }
            case 204: {
                return 1;
            }
        }
        throw new IllegalArgumentException("Movie type not supported.");
    }

    private void initComponents() {
        IconManager icons = IconManager.getInstance();
        this.play = new JButton(icons.getIcon(15));
        this.play.setToolTipText(UIUtilities.formatToolTipText("Play movie."));
        this.pause = new JButton(icons.getIcon(17));
        this.pause.setToolTipText(UIUtilities.formatToolTipText("Pause."));
        this.stop = new JButton(icons.getIcon(16));
        this.stop.setToolTipText(UIUtilities.formatToolTipText("Stop movie."));
        this.movieTypes = new JComboBox<String>(selections);
        this.movieTypes.setSelectedIndex(this.getMovieTypeIndex(this.model.getMovieType()));
        int max = this.model.getMaximumTimer();
        this.fps = new JSpinner(new SpinnerNumberModel(this.model.getTimerDelay(), 1, max, 1));
        this.editor = new JTextField("" + this.model.getTimerDelay(), ("" + max).length());
        String s = "Select or enter the movie playback rate (frames per second).";
        this.editor.setToolTipText(UIUtilities.formatToolTipText(s));
        this.fps.setEditor(this.editor);
        int maxZ = this.model.getMaxZ();
        int minZ = this.model.getMinZ();
        int rangeZ = maxZ - minZ;
        this.zSlider = new TwoKnobsSlider(minZ, maxZ, this.model.getStartZ(), this.model.getEndZ());
        this.zSlider.setPaintEndLabels(false);
        this.zSlider.setPaintLabels(false);
        if (rangeZ <= 0 || rangeZ > 100) {
            this.zSlider.setPaintTicks(false);
        }
        int length = ("" + (maxZ + 1)).length();
        this.startZ = new JTextField("" + (this.model.getStartZ() + 1), length);
        this.startZ.setToolTipText(UIUtilities.formatToolTipText("Enter the start z-section."));
        this.endZ = new JTextField("" + (this.model.getEndZ() + 1), length);
        this.endZ.setToolTipText(UIUtilities.formatToolTipText("Enter the end z-section."));
        int maxT = this.model.getMaxT();
        int minT = this.model.getMinZ();
        int rangeT = maxT - minT;
        this.tSlider = new TwoKnobsSlider(minT, maxT, this.model.getStartT(), this.model.getEndT());
        this.tSlider.setPaintEndLabels(false);
        this.tSlider.setPaintLabels(false);
        if (rangeT <= 0 || rangeT > 100) {
            this.tSlider.setPaintTicks(false);
        }
        this.startT = new JTextField("" + this.model.getStartT(), ("" + maxT).length());
        this.startT.setToolTipText(UIUtilities.formatToolTipText("Enter the start timepoint."));
        this.endT = new JTextField("" + this.model.getEndT(), ("" + maxT).length());
        this.endT.setToolTipText(UIUtilities.formatToolTipText("Enter the end timepoint."));
        this.acrossZ = new JCheckBox("Across Z");
        this.acrossT = new JCheckBox("Across T");
    }

    private JToolBar buildToolBar() {
        this.toolBar = new JToolBar();
        this.toolBar.setBorder(BorderFactory.createEtchedBorder());
        this.toolBar.setFloatable(false);
        this.toolBar.putClientProperty("JToolBar.isRollover", Boolean.TRUE);
        this.toolBar.add(this.play);
        this.toolBar.add(this.stop);
        return this.toolBar;
    }

    private JPanel createFPSControls() {
        JPanel p = new JPanel();
        GridBagConstraints c = new GridBagConstraints();
        p.setLayout(new GridBagLayout());
        JLabel l = new JLabel("Frame Rate");
        c.fill = 0;
        c.anchor = 17;
        p.add((Component)l, c);
        c.gridx = 1;
        c.insets = new Insets(0, 10, 0, 0);
        p.add((Component)this.fps, c);
        return p;
    }

    private JPanel createDirectionControls() {
        JPanel contain = new JPanel();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.anchor = 17;
        JLabel l = new JLabel("Play Mode:");
        contain.add((Component)l, gbc);
        gbc.gridx = 1;
        gbc.insets = new Insets(0, 10, 0, 0);
        contain.add((Component)this.movieTypes, gbc);
        return contain;
    }

    private JPanel buildControlsMoviePanel(int length, JTextField start, JTextField end) {
        JPanel p = new JPanel();
        Insets insets = end.getInsets();
        int x = insets.left + length * this.charWidth + insets.left;
        GridBagConstraints c = new GridBagConstraints();
        p.setLayout(new GridBagLayout());
        c.weightx = 0.0;
        c.anchor = 17;
        p.add((Component)new JLabel(" Start "), c);
        c.gridx = 1;
        c.ipadx = x;
        c.weightx = 0.5;
        p.add((Component)UIUtilities.buildComponentPanel(start), c);
        c.gridx = 2;
        c.ipadx = 0;
        c.weightx = 0.0;
        p.add((Component)new JLabel(" End "), c);
        c.gridx = 3;
        c.ipadx = x;
        c.weightx = 0.5;
        p.add((Component)UIUtilities.buildComponentPanel(end), c);
        return p;
    }

    private JPanel buildGroupPanel(TwoKnobsSlider slider, JCheckBox button, JPanel controls) {
        JPanel p = new JPanel();
        JPanel group = new JPanel();
        p.setLayout(new BoxLayout(p, 1));
        p.add(slider);
        p.add(controls);
        group.setLayout(new BoxLayout(group, 0));
        group.add(button);
        group.add(p);
        return group;
    }

    private void buildGUI() {
        JPanel movie = new JPanel();
        movie.setBorder(new TitledBorder("Frame Selection"));
        movie.setLayout(new GridBagLayout());
        GridBagConstraints mc = new GridBagConstraints();
        mc.insets = new Insets(5, 5, 5, 5);
        JPanel p = this.buildGroupPanel(this.zSlider, this.acrossZ, this.buildControlsMoviePanel(("" + this.model.getMaxZ()).length(), this.startZ, this.endZ));
        mc.gridy = 1;
        mc.anchor = 17;
        movie.add((Component)p, mc);
        p = this.buildGroupPanel(this.tSlider, this.acrossT, this.buildControlsMoviePanel(("" + this.model.getMaxT()).length(), this.startT, this.endT));
        mc.gridy = 2;
        movie.add((Component)p, mc);
        JPanel controls = new JPanel();
        controls.setBorder(new TitledBorder("Animation Control"));
        GridBagConstraints c = new GridBagConstraints();
        controls.setLayout(new GridBagLayout());
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 17;
        controls.add((Component)this.buildToolBar(), c);
        c.gridx = 1;
        controls.add((Component)this.createDirectionControls(), c);
        c.insets = new Insets(10, 0, 10, 0);
        c.gridx = 0;
        c.gridy = 1;
        controls.add((Component)this.createFPSControls(), c);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.fill = 2;
        this.add((Component)controls, gbc);
        gbc.gridy = 1;
        gbc.fill = 1;
        gbc.gridy = 2;
        this.add((Component)movie, gbc);
    }

    MoviePlayerUI(MoviePlayer model) {
        if (model == null) {
            throw new NullPointerException("No model.");
        }
        this.model = model;
        this.charWidth = this.getFontMetrics(this.getFont()).charWidth('m');
        this.initComponents();
        this.setDefaults();
        this.buildGUI();
    }

    void setDefaults() {
        int maxZ = this.model.getMaxZ();
        int maxT = this.model.getMaxT();
        this.zSlider.setEnabled(maxZ != 0);
        this.startZ.setEnabled(maxZ != 0);
        this.endZ.setEnabled(maxZ != 0);
        this.tSlider.setEnabled(maxT != 0);
        this.startT.setEnabled(maxT != 0);
        this.endT.setEnabled(maxT != 0);
        this.acrossZ.setEnabled(maxZ != 0);
        this.acrossT.setEnabled(maxT != 0);
        switch (this.model.getMovieIndex()) {
            case 300: {
                this.acrossZ.setSelected(true);
                break;
            }
            case 301: {
                this.acrossT.setSelected(true);
                break;
            }
            case 302: {
                this.acrossZ.setSelected(true);
                this.acrossT.setSelected(true);
            }
        }
    }

    int getMovieType(int uiType) {
        switch (uiType) {
            case 0: {
                return 200;
            }
            case 2: {
                return 201;
            }
            case 3: {
                return 202;
            }
            case 4: {
                return 203;
            }
            case 1: {
                return 204;
            }
        }
        throw new IllegalArgumentException("UI index not supported.");
    }

    void setDefaultMovieType() {
        this.movieTypes.setSelectedIndex(3);
    }

    void setStartZ(int v) {
        this.startZ.setText("" + (v + 1));
        this.zSlider.setStartValue(v);
    }

    void setStartT(int v) {
        this.startT.setText("" + v);
        this.tSlider.setStartValue(v);
    }

    void setEndZ(int v) {
        this.endZ.setText("" + (v + 1));
        this.zSlider.setEndValue(v);
    }

    void setEndT(int v) {
        this.endT.setText("" + v);
        this.tSlider.setEndValue(v);
    }

    void setMoviePlay(boolean b) {
        this.toolBar.removeAll();
        if (b) {
            this.toolBar.add(this.pause);
        } else {
            this.toolBar.add(this.play);
        }
        this.toolBar.add(this.stop);
        this.toolBar.repaint();
    }

    void setTimerDelay(int v) {
        this.fps.setValue(v);
        this.editor.setText("" + v);
    }

    void setMovieIndex(int index) {
        switch (index) {
            case 300: {
                this.acrossZ.setSelected(true);
                break;
            }
            case 301: {
                this.acrossT.setSelected(true);
            }
        }
    }

    void doClick(int index) {
        switch (index) {
            case 1: {
                this.pause.doClick();
                break;
            }
            case 0: {
                this.play.doClick();
            }
        }
    }

    static {
        MoviePlayerUI.selections[0] = "Loop";
        MoviePlayerUI.selections[1] = "Loop Backward";
        MoviePlayerUI.selections[2] = "Backward";
        MoviePlayerUI.selections[3] = "Forward";
        MoviePlayerUI.selections[4] = "Back and Forth";
    }
}

