/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.imviewer.util.cdm;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import javax.swing.JPanel;

class ContrastStretchingUI
extends JPanel {
    static final int WIDTH = 220;
    static final int HEIGHT = 200;
    static final int topBorder = 20;
    static final int leftBorder = 40;
    static final int rightBorder = 10;
    static final int bottomBorder = 30;
    static final int square = 140;
    static final int lS = 180;
    static final int tS = 160;
    static final int lS2 = 110;
    static final int triangleW = 7;
    static final int triangleH = 8;
    private static final Color bgColor = Color.WHITE;
    private static final Color lineColor = Color.RED;
    private static final Color startColor = Color.BLACK;
    private static final Color endColor = Color.GRAY;
    private static final Color gridColor = Color.LIGHT_GRAY;
    private static final Color axisColor = Color.GRAY;
    private Point2D startPt;
    private Point2D endPt;
    private Point2D staticStartPt;
    private Point2D staticEndPt;
    private int xStart1;
    private int xStart2;
    private int xStart3;
    private int yStart1;
    private int yStart2;
    private int yStart3;
    private int xEnd1;
    private int xEnd2;
    private int xEnd3;
    private int yEnd1;
    private int yEnd2;
    private int yEnd3;
    private int xStartOutput1;
    private int xStartOutput2;
    private int xStartOutput3;
    private int yStartOutput1;
    private int yStartOutput2;
    private int yStartOutput3;
    private int xEndOutput1;
    private int xEndOutput2;
    private int xEndOutput3;
    private int yEndOutput1;
    private int yEndOutput2;
    private int yEndOutput3;

    ContrastStretchingUI(int xStart, int xEnd, int yStart, int yEnd) {
        this.setKnobStart(xStart, 170);
        this.setKnobEnd(xEnd, 170);
        this.setKnobOutputStart(30, yStart);
        this.setKnobOutputEnd(30, yEnd);
        this.startPt = new Point2D.Double();
        this.endPt = new Point2D.Double();
        this.staticStartPt = new Point2D.Double();
        this.staticEndPt = new Point2D.Double();
        this.staticStartPt.setLocation(40.0, 160.0);
        this.startPt.setLocation(xStart, yStart);
        this.staticEndPt.setLocation(180.0, 20.0);
        this.endPt.setLocation(xEnd, yEnd);
        this.repaint();
    }

    void setKnobStart(int x, int y) {
        this.xStart1 = x;
        this.xStart2 = x - 7;
        this.xStart3 = x + 7;
        this.yStart1 = y;
        this.yStart2 = y + 8;
        this.yStart3 = y + 8;
    }

    void setKnobEnd(int x, int y) {
        this.xEnd1 = x;
        this.xEnd2 = x - 7;
        this.xEnd3 = x + 7;
        this.yEnd1 = y;
        this.yEnd2 = y + 8;
        this.yEnd3 = y + 8;
    }

    void setKnobOutputStart(int x, int y) {
        this.xStartOutput1 = x;
        this.xStartOutput2 = x - 8;
        this.xStartOutput3 = x - 8;
        this.yStartOutput1 = y;
        this.yStartOutput2 = y - 7;
        this.yStartOutput3 = y + 7;
    }

    void setKnobOutputEnd(int x, int y) {
        this.xEndOutput1 = x;
        this.xEndOutput2 = x - 8;
        this.xEndOutput3 = x - 8;
        this.yEndOutput1 = y;
        this.yEndOutput2 = y - 7;
        this.yEndOutput3 = y + 7;
    }

    void updateStartKnob(int x) {
        this.xStart1 = x;
        this.xStart2 = x - 7;
        this.xStart3 = x + 7;
        this.startPt.setLocation(x, this.startPt.getY());
        this.repaint();
    }

    void updateEndKnob(int x) {
        this.xEnd1 = x;
        this.xEnd2 = x - 7;
        this.xEnd3 = x + 7;
        this.endPt.setLocation(x, this.endPt.getY());
        this.repaint();
    }

    void updateStartOutputKnob(int y) {
        this.yStartOutput1 = y;
        this.yStartOutput2 = y - 7;
        this.yStartOutput3 = y + 7;
        this.startPt.setLocation(this.startPt.getX(), y);
        this.repaint();
    }

    void updateEndOutputKnob(int y) {
        this.yEndOutput1 = y;
        this.yEndOutput2 = y - 7;
        this.yEndOutput3 = y + 7;
        this.endPt.setLocation(this.endPt.getX(), y);
        this.repaint();
    }

    public void paintComponent(Graphics g) {
        int i;
        Graphics2D g2D = (Graphics2D)g;
        g2D.setColor(bgColor);
        g2D.fillRect(0, 0, 330, 300);
        Font font = g2D.getFont();
        FontMetrics fontMetrics = g2D.getFontMetrics();
        int hFont = fontMetrics.getHeight();
        Rectangle2D rInput = font.getStringBounds("Input", g2D.getFontRenderContext());
        int wInput = (int)rInput.getWidth();
        AffineTransform transform = new AffineTransform();
        transform.translate(110.0, 90.0);
        transform.scale(1.0, -1.0);
        transform.scale(10.0, 10.0);
        g2D.setPaint(gridColor);
        GeneralPath path = new GeneralPath();
        for (i = -7; i <= 7; ++i) {
            path.moveTo(i, -7.0f);
            path.lineTo(i, 7.0f);
        }
        for (i = -7; i <= 7; ++i) {
            path.moveTo(-7.0f, i);
            path.lineTo(7.0f, i);
        }
        g2D.draw(transform.createTransformedShape(path));
        g2D.setColor(axisColor);
        g2D.drawLine(40, 12, 40, 165);
        g2D.drawLine(40, 12, 37, 15);
        g2D.drawLine(40, 12, 43, 15);
        g2D.drawLine(35, 20, 40, 20);
        g2D.drawLine(35, 160, 188, 160);
        g2D.drawLine(185, 157, 188, 160);
        g2D.drawLine(185, 163, 188, 160);
        g2D.drawLine(180, 160, 180, 165);
        int[] xStartPoints = new int[]{this.xStart1, this.xStart2, this.xStart3};
        int[] yStartPoints = new int[]{this.yStart1, this.yStart2, this.yStart3};
        GeneralPath filledPolygonStart = new GeneralPath();
        filledPolygonStart.moveTo(xStartPoints[0], yStartPoints[0]);
        for (int index = 1; index < xStartPoints.length; ++index) {
            filledPolygonStart.lineTo(xStartPoints[index], yStartPoints[index]);
        }
        filledPolygonStart.closePath();
        g2D.setColor(startColor);
        g2D.fill(filledPolygonStart);
        int[] xEndPoints = new int[]{this.xEnd1, this.xEnd2, this.xEnd3};
        int[] yEndPoints = new int[]{this.yEnd1, this.yEnd2, this.yEnd3};
        GeneralPath filledPolygonEnd = new GeneralPath();
        filledPolygonEnd.moveTo(xEndPoints[0], yEndPoints[0]);
        for (int index = 1; index < xEndPoints.length; ++index) {
            filledPolygonEnd.lineTo(xEndPoints[index], yEndPoints[index]);
        }
        filledPolygonEnd.closePath();
        g2D.setColor(endColor);
        g2D.fill(filledPolygonEnd);
        int[] xStartOutputPoints = new int[]{this.xStartOutput1, this.xStartOutput2, this.xStartOutput3};
        int[] yStartOutputPoints = new int[]{this.yStartOutput1, this.yStartOutput2, this.yStartOutput3};
        GeneralPath filledPolygonStartOutput = new GeneralPath();
        filledPolygonStartOutput.moveTo(xStartOutputPoints[0], yStartOutputPoints[0]);
        for (int index = 1; index < xStartOutputPoints.length; ++index) {
            filledPolygonStartOutput.lineTo(xStartOutputPoints[index], yStartOutputPoints[index]);
        }
        filledPolygonStartOutput.closePath();
        g2D.setColor(startColor);
        g2D.fill(filledPolygonStartOutput);
        int[] xEndOutputPoints = new int[]{this.xEndOutput1, this.xEndOutput2, this.xEndOutput3};
        int[] yEndOutputPoints = new int[]{this.yEndOutput1, this.yEndOutput2, this.yEndOutput3};
        GeneralPath filledPolygonEndOutput = new GeneralPath();
        filledPolygonEndOutput.moveTo(xEndOutputPoints[0], yEndOutputPoints[0]);
        for (int index = 1; index < xEndOutputPoints.length; ++index) {
            filledPolygonEndOutput.lineTo(xEndOutputPoints[index], yEndOutputPoints[index]);
        }
        filledPolygonEndOutput.closePath();
        g2D.setColor(endColor);
        g2D.fill(filledPolygonEndOutput);
        g2D.drawString("Input", 110 - wInput / 2, 175 + hFont);
        g2D.setColor(lineColor);
        g2D.setStroke(new BasicStroke(1.5f));
        g2D.drawLine((int)this.staticStartPt.getX(), (int)this.staticStartPt.getY(), (int)this.startPt.getX(), (int)this.startPt.getY());
        g2D.drawLine((int)this.endPt.getX(), (int)this.endPt.getY(), (int)this.staticEndPt.getX(), (int)this.staticEndPt.getY());
        g2D.drawLine((int)this.startPt.getX(), (int)this.startPt.getY(), (int)this.endPt.getX(), (int)this.endPt.getY());
    }
}

