/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.imviewer.util;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.openmicroscopy.shoola.agents.imviewer.ImViewerAgent;
import org.openmicroscopy.shoola.env.ui.UserNotifier;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

public class UnitBarSizeDialog
extends JDialog {
    public static final String UNIT_BAR_VALUE_PROPERTY = "unitBarValue";
    private static final Dimension DIM = new Dimension(50, 20);
    private JTextField label;

    private void handleSelection() {
        try {
            double val = Double.parseDouble(this.label.getText());
            if (val > 0.0) {
                this.firePropertyChange(UNIT_BAR_VALUE_PROPERTY, new Double(0.0), new Double(val));
                this.setVisible(false);
                this.dispose();
            } else {
                UserNotifier un = ImViewerAgent.getRegistry().getUserNotifier();
                un.notifyInfo("Invalid value", "Please enter a positive value");
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private void setProperties() {
        this.setModal(true);
        this.setResizable(false);
    }

    private void buildGUI() {
        this.label = new JTextField();
        this.label.setEditable(true);
        this.label.setEnabled(true);
        this.label.setPreferredSize(DIM);
        this.label.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                UnitBarSizeDialog.this.handleSelection();
            }
        });
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        p.add(new JLabel("Value (in \u00b5m): "));
        p.add(this.label);
        this.getContentPane().add(UIUtilities.buildComponentPanel(p));
    }

    public UnitBarSizeDialog(JFrame parent) {
        super(parent);
        this.setProperties();
        this.buildGUI();
        this.pack();
    }
}

