/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.imviewer;

import java.awt.Rectangle;
import java.util.List;
import org.openmicroscopy.shoola.agents.events.FocusGainedEvent;
import org.openmicroscopy.shoola.agents.events.iviewer.CopyRndSettings;
import org.openmicroscopy.shoola.agents.events.iviewer.ImageViewport;
import org.openmicroscopy.shoola.agents.events.iviewer.MeasurementTool;
import org.openmicroscopy.shoola.agents.events.iviewer.RendererUnloadedEvent;
import org.openmicroscopy.shoola.agents.events.iviewer.RndSettingsSaved;
import org.openmicroscopy.shoola.agents.events.iviewer.SaveRelatedData;
import org.openmicroscopy.shoola.agents.events.iviewer.ViewImage;
import org.openmicroscopy.shoola.agents.events.measurement.MeasurementToolLoaded;
import org.openmicroscopy.shoola.agents.events.measurement.SelectPlane;
import org.openmicroscopy.shoola.agents.events.treeviewer.DeleteObjectEvent;
import org.openmicroscopy.shoola.agents.imviewer.view.ImViewer;
import org.openmicroscopy.shoola.agents.imviewer.view.ImViewerFactory;
import org.openmicroscopy.shoola.env.Agent;
import org.openmicroscopy.shoola.env.config.Registry;
import org.openmicroscopy.shoola.env.data.events.UserGroupSwitched;
import org.openmicroscopy.shoola.env.data.util.AgentSaveInfo;
import org.openmicroscopy.shoola.env.event.AgentEvent;
import org.openmicroscopy.shoola.env.event.AgentEventListener;
import org.openmicroscopy.shoola.env.event.EventBus;
import org.openmicroscopy.shoola.env.ui.ViewObjectEvent;
import pojos.DataObject;
import pojos.ExperimenterData;
import pojos.ImageData;
import pojos.PixelsData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImViewerAgent
implements Agent,
AgentEventListener {
    public static final String ERROR = " An error occurred while modifying  the rendering settings.";
    private static Registry registry;

    public static Registry getRegistry() {
        return registry;
    }

    public static boolean hasOpenGLSupport() {
        Boolean support = (Boolean)ImViewerAgent.getRegistry().lookup("/library/opengl");
        return support;
    }

    public static ExperimenterData getUserDetails() {
        return (ExperimenterData)registry.lookup("/current_user/details");
    }

    public static boolean isFastConnection() {
        int value = (Integer)registry.lookup("/connection/speed");
        return value == 0;
    }

    private void handleViewImage(ViewImage evt) {
        if (evt == null) {
            return;
        }
        Boolean available = (Boolean)registry.lookup("/services/SERVER/BinaryAvailable");
        if (available != null && !available.booleanValue()) {
            return;
        }
        DataObject image = evt.getImage();
        Rectangle r = evt.getRequesterBounds();
        boolean b = evt.isSeparateWindow();
        ImViewer view = image != null ? ImViewerFactory.getImageViewer(image, r, b) : ImViewerFactory.getImageViewer(evt.getImageID(), r, b);
        if (view != null) {
            view.activate(evt.getSettings(), evt.getSelectedUserID());
            view.setContext(evt.getParent(), evt.getGrandParent());
        }
    }

    private void handleSaveRelatedData(SaveRelatedData evt) {
        if (evt == null) {
            return;
        }
        ImViewerFactory.storeEvent(evt);
    }

    private void handleMeasurementToolLoaded(MeasurementToolLoaded evt) {
        if (evt == null) {
            return;
        }
        MeasurementTool request = (MeasurementTool)evt.getACT();
        PixelsData pixels = request.getPixels();
        if (pixels == null) {
            return;
        }
        long pixelsID = pixels.getId();
        ImViewer view = ImViewerFactory.getImageViewer(pixelsID);
        if (view != null) {
            switch (evt.getIndex()) {
                case 0: {
                    view.addToView(evt.getView());
                    break;
                }
                case 1: {
                    view.removeFromView(evt.getView());
                }
            }
        }
    }

    private void handleSelectPlane(SelectPlane evt) {
        if (evt == null) {
            return;
        }
        long pixelsID = evt.getPixelsID();
        ImViewer view = ImViewerFactory.getImageViewer(pixelsID);
        if (view != null && !view.isPlayingMovie()) {
            view.setSelectedXYPlane(evt.getDefaultZ(), evt.getDefaultT());
        }
    }

    public void handleCopyRndSettingsEvent(CopyRndSettings evt) {
        if (evt == null) {
            return;
        }
        ImViewerFactory.copyRndSettings(evt.getImage());
    }

    public void handleRndSettingsSavedEvent(RndSettingsSaved evt) {
        if (evt == null) {
            return;
        }
        ImViewerFactory.rndSettingsSaved(evt.getRefPixelsID(), evt.getSettings());
    }

    private void handleFocusGainedEvent(FocusGainedEvent evt) {
        ImViewer viewer = ImViewerFactory.getImageViewer(evt.getPixelsID());
        if (viewer == null) {
            return;
        }
        if (viewer.getState() != 7 || evt.getIndex() != 0) {
            // empty if block
        }
    }

    private void handleImageViewportEvent(ImageViewport evt) {
        if (evt == null) {
            return;
        }
        ImViewer viewer = ImViewerFactory.getImageViewer(evt.getPixelsID());
        if (viewer == null) {
            return;
        }
        viewer.scrollToViewport(evt.getBounds());
    }

    private void handleUserGroupSwitched(UserGroupSwitched evt) {
        if (evt == null) {
            return;
        }
        ImViewerFactory.onGroupSwitched(evt.isSuccessful());
    }

    private void handleViewObjectEvent(ViewObjectEvent evt) {
        ImViewer view;
        if (evt == null) {
            return;
        }
        Object o = evt.getObject();
        if (o instanceof ImageData && (view = ImViewerFactory.getImageViewer(((ImageData)o).getId(), null, true)) != null) {
            view.activate(null, ImViewerAgent.getUserDetails().getId());
        }
    }

    private void handleRendererUnloadedEvent(RendererUnloadedEvent evt) {
        if (evt == null) {
            return;
        }
        ImViewer viewer = ImViewerFactory.getImageViewer(evt.getPixelsID());
        if (viewer == null) {
            return;
        }
        viewer.discard();
    }

    private void handleDeleteObjectEvent(DeleteObjectEvent evt) {
        if (evt == null) {
            return;
        }
        List<DataObject> objects = evt.getObjects();
        if (objects == null) {
            return;
        }
        for (DataObject object : objects) {
            if (object instanceof ImageData) {
                this.checkImageForDelete((ImageData)object);
                continue;
            }
            ImViewer viewer = ImViewerFactory.getImageViewerFromParent(object);
            if (viewer == null) continue;
            viewer.discard();
        }
    }

    private void checkImageForDelete(ImageData image) {
        if (image.getId() < 0L) {
            return;
        }
        PixelsData pixels = image.getDefaultPixels();
        if (pixels == null) {
            return;
        }
        ImViewer viewer = ImViewerFactory.getImageViewer(pixels.getId());
        if (viewer != null) {
            viewer.discard();
        }
    }

    @Override
    public void activate() {
    }

    @Override
    public void terminate() {
    }

    @Override
    public void setContext(Registry ctx) {
        registry = ctx;
        EventBus bus = registry.getEventBus();
        bus.register((AgentEventListener)this, ViewImage.class);
        bus.register((AgentEventListener)this, MeasurementToolLoaded.class);
        bus.register((AgentEventListener)this, SelectPlane.class);
        bus.register((AgentEventListener)this, CopyRndSettings.class);
        bus.register((AgentEventListener)this, SaveRelatedData.class);
        bus.register((AgentEventListener)this, FocusGainedEvent.class);
        bus.register((AgentEventListener)this, ImageViewport.class);
        bus.register((AgentEventListener)this, UserGroupSwitched.class);
        bus.register((AgentEventListener)this, ViewObjectEvent.class);
        bus.register((AgentEventListener)this, RendererUnloadedEvent.class);
        bus.register((AgentEventListener)this, DeleteObjectEvent.class);
        bus.register((AgentEventListener)this, RndSettingsSaved.class);
    }

    @Override
    public boolean canTerminate() {
        return true;
    }

    @Override
    public AgentSaveInfo getDataToSave() {
        List<Object> list = ImViewerFactory.getInstancesToSave();
        if (list == null || list.size() == 0) {
            return null;
        }
        return new AgentSaveInfo("Image Viewer", list);
    }

    @Override
    public void save(List<Object> instances) {
        ImViewerFactory.saveInstances(instances);
    }

    @Override
    public void eventFired(AgentEvent e) {
        if (e instanceof ViewImage) {
            this.handleViewImage((ViewImage)e);
        } else if (e instanceof MeasurementToolLoaded) {
            this.handleMeasurementToolLoaded((MeasurementToolLoaded)e);
        } else if (e instanceof SelectPlane) {
            this.handleSelectPlane((SelectPlane)e);
        } else if (e instanceof CopyRndSettings) {
            this.handleCopyRndSettingsEvent((CopyRndSettings)e);
        } else if (e instanceof SaveRelatedData) {
            this.handleSaveRelatedData((SaveRelatedData)e);
        } else if (e instanceof FocusGainedEvent) {
            this.handleFocusGainedEvent((FocusGainedEvent)e);
        } else if (e instanceof ImageViewport) {
            this.handleImageViewportEvent((ImageViewport)e);
        } else if (e instanceof UserGroupSwitched) {
            this.handleUserGroupSwitched((UserGroupSwitched)e);
        } else if (e instanceof ViewObjectEvent) {
            this.handleViewObjectEvent((ViewObjectEvent)e);
        } else if (e instanceof RendererUnloadedEvent) {
            this.handleRendererUnloadedEvent((RendererUnloadedEvent)e);
        } else if (e instanceof DeleteObjectEvent) {
            this.handleDeleteObjectEvent((DeleteObjectEvent)e);
        } else if (e instanceof RndSettingsSaved) {
            this.handleRndSettingsSavedEvent((RndSettingsSaved)e);
        }
    }
}

