/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.fsimporter.chooser;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.List;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileSystemView;
import org.openmicroscopy.shoola.agents.fsimporter.IconManager;
import org.openmicroscopy.shoola.agents.fsimporter.ImporterAgent;
import org.openmicroscopy.shoola.agents.fsimporter.chooser.ImporterChooser;
import org.openmicroscopy.shoola.env.config.Registry;
import org.openmicroscopy.shoola.env.ui.UserNotifier;
import org.openmicroscopy.shoola.util.ui.TitlePanel;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

public class ImporterChooserDialog
extends JDialog
implements ActionListener {
    public static final String IMPORT_PROPERTY = "import";
    public static final String MONITOR_PROPERTY = "monitorFS";
    private static final int CANCEL = 0;
    private static final int SAVE = 1;
    private static final int MONITOR = 2;
    private static final String SAVE_DESCRIPTION = "Import the selected file.";
    private static final String MONITOR_DESCRIPTION = "Monitor the selected directory.";
    private static final String NOTE = "Import the selected file or monitor a directory.";
    private static final String TITLE = "Import.";
    private static final Dimension H_SPACER_SIZE = new Dimension(3, 10);
    private ImporterChooser chooser;
    private JButton cancelButton;
    private JButton saveButton;
    private JButton monitorButton;

    private void initComponents() {
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.addActionListener(this);
        this.cancelButton.setActionCommand("0");
        this.saveButton = new JButton("Import");
        this.saveButton.setToolTipText(UIUtilities.formatToolTipText(SAVE_DESCRIPTION));
        this.saveButton.addActionListener(this);
        this.saveButton.setActionCommand("1");
        this.monitorButton = new JButton("Monitor");
        this.monitorButton.addActionListener(this);
        this.monitorButton.setActionCommand("2");
        this.monitorButton.setToolTipText(UIUtilities.formatToolTipText(MONITOR_DESCRIPTION));
    }

    private JPanel buildToolbar() {
        JPanel bar = new JPanel();
        bar.setBorder(null);
        bar.add(this.cancelButton);
        bar.add(Box.createRigidArea(H_SPACER_SIZE));
        bar.add(this.monitorButton);
        bar.add(Box.createRigidArea(H_SPACER_SIZE));
        bar.add(this.saveButton);
        return UIUtilities.buildComponentPanelRight(bar);
    }

    private void buildGUI() {
        boolean supportsWindowDecorations;
        JPanel p = new JPanel();
        p.setLayout(new BorderLayout(0, 0));
        p.add((Component)this.chooser, "Center");
        p.add((Component)this.buildToolbar(), "South");
        IconManager im = IconManager.getInstance();
        Container c = this.getContentPane();
        c.setLayout(new BorderLayout(0, 0));
        TitlePanel tp = new TitlePanel(TITLE, NOTE, im.getIcon(2));
        c.add((Component)((Object)tp), "North");
        c.add((Component)p, "Center");
        if (JDialog.isDefaultLookAndFeelDecorated() && (supportsWindowDecorations = UIManager.getLookAndFeel().getSupportsWindowDecorations())) {
            this.getRootPane().setWindowDecorationStyle(6);
        }
    }

    private void close() {
        this.setVisible(false);
        this.dispose();
    }

    private void importFile() {
        File[] files = this.chooser.getSelectedFiles();
        if (files == null || files.length == 0) {
            UserNotifier un = ImporterAgent.getRegistry().getUserNotifier();
            un.notifyInfo("Import", "Please select a file to import.");
            return;
        }
        this.chooser.approveSelection();
        this.firePropertyChange(IMPORT_PROPERTY, null, files);
    }

    private void monitorDirectory() {
        File file = this.chooser.getFSDefaultDirectory();
        if (file == null) {
            UserNotifier un = ImporterAgent.getRegistry().getUserNotifier();
            un.notifyInfo("Import", "Please select a directory to monitor.");
            return;
        }
        this.firePropertyChange(MONITOR_PROPERTY, null, file);
        this.close();
    }

    public ImporterChooserDialog(JFrame parent, FileSystemView fsv) {
        super(parent);
        Registry reg = ImporterAgent.getRegistry();
        List<FileFilter> filters = reg.getImageService().getSupportedFileFilters();
        this.chooser = fsv == null ? new ImporterChooser(filters) : new ImporterChooser(fsv, filters);
        this.initComponents();
        this.buildGUI();
    }

    public void actionPerformed(ActionEvent e) {
        int index = Integer.parseInt(e.getActionCommand());
        switch (index) {
            case 0: {
                this.close();
                this.chooser.cancelSelection();
                break;
            }
            case 1: {
                this.importFile();
                break;
            }
            case 2: {
                this.monitorDirectory();
            }
        }
    }
}

