/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.fsimporter;

import org.openmicroscopy.shoola.agents.fsimporter.ImporterAgent;
import org.openmicroscopy.shoola.agents.fsimporter.view.Importer;
import org.openmicroscopy.shoola.env.config.Registry;
import org.openmicroscopy.shoola.env.data.events.DSCallAdapter;
import org.openmicroscopy.shoola.env.data.views.ImageDataView;
import org.openmicroscopy.shoola.env.data.views.MetadataHandlerView;
import org.openmicroscopy.shoola.env.log.LogMessage;
import pojos.ExperimenterData;

public abstract class DataImporterLoader
extends DSCallAdapter {
    protected final Importer viewer;
    protected final Registry registry;
    protected final ImageDataView ivView;
    protected final MetadataHandlerView mhView;
    protected long userID;
    protected long groupID;

    protected long getCurrentUserID() {
        return ImporterAgent.getUserDetails().getId();
    }

    void setIds() {
        ExperimenterData exp = ImporterAgent.getUserDetails();
        this.userID = exp.getId();
        this.groupID = exp.getDefaultGroup().getId();
        int level = ImporterAgent.getRegistry().getAdminService().getPermissionLevel();
        switch (level) {
            case 102: 
            case 104: {
                this.userID = -1L;
            }
        }
    }

    protected DataImporterLoader(Importer viewer) {
        if (viewer == null) {
            throw new NullPointerException("No viewer.");
        }
        this.viewer = viewer;
        this.registry = ImporterAgent.getRegistry();
        this.ivView = (ImageDataView)this.registry.getDataServicesView(ImageDataView.class);
        this.mhView = (MetadataHandlerView)this.registry.getDataServicesView(MetadataHandlerView.class);
    }

    public void onEnd() {
    }

    public void handleNullResult() {
        this.handleException(new Exception("No data available."));
    }

    public void handleCancellation() {
        String info = "The data retrieval has been cancelled.";
        this.registry.getLogger().info((Object)this, info);
        this.registry.getUserNotifier().notifyInfo("Data Retrieval Cancellation", info);
    }

    public void handleException(Throwable exc) {
        String s = "Data Retrieval Failure: ";
        LogMessage msg = new LogMessage();
        msg.print(s);
        msg.print(exc);
        this.registry.getLogger().error((Object)this, msg);
        this.registry.getUserNotifier().notifyError("Data Retrieval Failure", s, exc);
        this.viewer.cancel();
    }

    public abstract void load();

    public abstract void cancel();
}

