/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.editor.uiComponents;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.openmicroscopy.shoola.agents.editor.util.FilePathMethods;

public class RelativeFileChooser
extends JDialog
implements ActionListener {
    private JCheckBox relLinkCheckBox;
    private String originalDirectory;
    private boolean relativeLink;
    private JFileChooser fc;
    private String fileChooserState = "CancelSelection";

    public RelativeFileChooser(String originalPath) {
        this(null, originalPath, null);
    }

    public RelativeFileChooser(JFrame frame, String originalDir, String currentFilePath) {
        super(frame);
        this.originalDirectory = originalDir;
        this.fc = new JFileChooser();
        this.fc.setDialogType(0);
        this.fc.addActionListener(this);
        if (currentFilePath != null) {
            this.fc.setCurrentDirectory(new File(currentFilePath));
        }
        this.relLinkCheckBox = new JCheckBox("Relative link");
        this.relLinkCheckBox.setToolTipText("<html>The link to the chosen file will be 'relative' to the OMERO.editor file you are editing.<br>Choose this option if the location of both files is likely to change in a similar way (eg saved in the same folder).");
        this.relLinkCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (RelativeFileChooser.this.relLinkCheckBox.isSelected() && RelativeFileChooser.this.originalDirectory == null) {
                    JOptionPane.showMessageDialog(RelativeFileChooser.this, "The current file is not\nsaved, so a relative file path to the chosen file \ncannot be determined.", "Current File Not Saved", 0);
                    RelativeFileChooser.this.relLinkCheckBox.setSelected(false);
                }
                RelativeFileChooser.this.relativeLink = RelativeFileChooser.this.relLinkCheckBox.isSelected();
            }
        });
        Container dialogPane = this.getContentPane();
        dialogPane.setLayout(new BorderLayout());
        dialogPane.add((Component)this.fc, "Center");
        dialogPane.add((Component)this.relLinkCheckBox, "South");
        this.fc.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                RelativeFileChooser.this.setVisible(false);
            }
        });
        this.pack();
        this.setModal(true);
        this.setLocationRelativeTo(this);
        this.setVisible(true);
    }

    public String getPath() {
        File chosenFile = this.fc.getSelectedFile();
        if (chosenFile == null) {
            return null;
        }
        if (!this.fileChooserState.equals("ApproveSelection")) {
            return null;
        }
        String chosenFilePath = chosenFile.getAbsolutePath();
        if (this.relativeLink) {
            String filePath = FilePathMethods.getRelativePathFromAbsolutePath(this.originalDirectory, chosenFilePath);
            return filePath;
        }
        return chosenFilePath;
    }

    public boolean isRelativeLink() {
        return this.relativeLink;
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.fc)) {
            this.fileChooserState = e.getActionCommand();
        }
    }
}

