/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.editor.model.undoableEdits;

import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.swing.undo.AbstractUndoableEdit;
import org.openmicroscopy.shoola.agents.editor.model.IField;
import org.openmicroscopy.shoola.agents.editor.model.Note;
import org.openmicroscopy.shoola.agents.editor.model.TreeModelMethods;

public class AddStepNoteEdit
extends AbstractUndoableEdit {
    private IField field;
    private Note newNote;
    private Note oldNote;
    private JTree tree;
    private TreeNode node;
    private int indexOfNote;

    public AddStepNoteEdit(IField field, JTree tree, TreeNode node) {
        this.field = field;
        this.newNote = new Note();
        this.tree = tree;
        this.node = node;
        this.indexOfNote = field.getNoteCount();
        this.redo();
    }

    public AddStepNoteEdit(IField field, Note note, JTree tree, TreeNode node) {
        this.field = field;
        this.newNote = null;
        this.oldNote = note;
        this.tree = tree;
        this.node = node;
        this.redo();
    }

    public void undo() {
        if (this.newNote != null) {
            this.field.removeNote(this.newNote);
        } else {
            this.field.addNote(this.oldNote, this.indexOfNote);
        }
        this.notifySelectStartEdit();
    }

    public void redo() {
        if (this.newNote != null) {
            this.field.addNote(this.newNote, this.indexOfNote);
        } else {
            this.indexOfNote = this.field.removeNote(this.oldNote);
        }
        this.notifySelectStartEdit();
    }

    public boolean canUndo() {
        return true;
    }

    public boolean canRedo() {
        return true;
    }

    public String getPresentationName() {
        if (this.newNote == null) {
            return "Delete Note";
        }
        return "Add Note";
    }

    private void notifySelectStartEdit() {
        this.notifyNodeChanged();
        TreeModelMethods.selectNode(this.node, this.tree);
        DefaultMutableTreeNode dmtNode = (DefaultMutableTreeNode)this.node;
        TreePath path = new TreePath(dmtNode.getPath());
        if (this.tree != null) {
            this.tree.startEditingAtPath(path);
        }
    }

    private void notifyNodeChanged() {
        if (this.tree != null && this.node != null) {
            DefaultTreeModel treeModel = (DefaultTreeModel)this.tree.getModel();
            treeModel.nodeChanged(this.node);
        }
    }
}

