/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.editor.model.tables;

import java.util.ArrayList;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import org.openmicroscopy.shoola.agents.editor.model.tables.IMutableTableModel;

public class MutableTableModel
extends AbstractTableModel
implements IMutableTableModel {
    protected ArrayList<String> columnNames = new ArrayList();
    protected ArrayList<ArrayList<Object>> data = new ArrayList();

    public MutableTableModel() {
    }

    public MutableTableModel(TableModel tModel) {
        this();
        int rowCount = tModel.getRowCount();
        int colCount = tModel.getColumnCount();
        for (int c = 0; c < colCount; ++c) {
            this.columnNames.add(tModel.getColumnName(c));
        }
        for (int r = 0; r < rowCount; ++r) {
            ArrayList<String> row = new ArrayList<String>();
            for (int c = 0; c < colCount; ++c) {
                row.add(tModel.getValueAt(r, c).toString());
            }
            this.data.add(row);
        }
    }

    public String getColumnName(int column) {
        return this.columnNames.get(column);
    }

    public void setColumnName(int columnIndex, String name) {
        if (columnIndex >= this.getColumnCount()) {
            this.addEmptyColumn(name);
        } else {
            this.columnNames.remove(columnIndex);
            this.columnNames.add(columnIndex, name);
        }
    }

    public boolean isCellEditable(int row, int column) {
        return true;
    }

    public Object getValueAt(int row, int column) {
        if (row < this.getRowCount() && column < this.getColumnCount()) {
            Object value = this.data.get(row).get(column);
            if (value == null) {
                return "";
            }
            return value;
        }
        return "";
    }

    public void setValueAt(Object value, int row, int column) {
        this.data.get(row).set(column, (String)value);
        this.fireTableCellUpdated(row, column);
    }

    public int getRowCount() {
        return this.data.size();
    }

    public int getColumnCount() {
        return this.columnNames.size();
    }

    public void addEmptyRow() {
        ArrayList<String> newRow = new ArrayList<String>();
        for (int i = 0; i < this.getColumnCount(); ++i) {
            newRow.add("");
        }
        this.data.add(newRow);
        this.fireTableRowsInserted(this.getRowCount() - 1, this.getRowCount() - 1);
    }

    public void addEmptyRow(int addAtThisRow) {
        ArrayList<String> newRow = new ArrayList<String>();
        for (int i = 0; i < this.getColumnCount(); ++i) {
            newRow.add("");
        }
        int newRowIndex = addAtThisRow;
        if (newRowIndex > this.data.size()) {
            this.data.add(newRow);
            newRowIndex = this.getRowCount() - 1;
        } else {
            this.data.add(newRowIndex, newRow);
        }
        this.fireTableRowsInserted(newRowIndex, newRowIndex);
    }

    public void addEmptyColumn(String colName) {
        this.columnNames.add(colName);
        for (ArrayList<Object> row : this.data) {
            row.add("");
        }
        this.fireTableStructureChanged();
    }

    public void removeLastColumn() {
        this.columnNames.remove(this.columnNames.size() - 1);
        int colCount = this.getColumnCount();
        for (ArrayList<Object> row : this.data) {
            row.remove(colCount);
        }
        this.fireTableStructureChanged();
    }

    public void removeRows(int[] rowIndecies) {
        for (int i = rowIndecies.length - 1; i > -1; --i) {
            int rowToRemove = rowIndecies[i];
            this.data.remove(rowToRemove);
            this.fireTableRowsDeleted(rowToRemove, rowToRemove);
        }
    }
}

