/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.editor.model.params;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.openmicroscopy.shoola.agents.editor.model.params.AbstractParam;

public class DateTimeParam
extends AbstractParam {
    public static final String DATE_TIME_PARAM = "DATE_TIME";

    public DateTimeParam() {
        super(DATE_TIME_PARAM);
    }

    public String getYYYYMMDD() {
        String dateMillis = this.getAttribute("value");
        if (dateMillis != null) {
            long millis = new Long(dateMillis);
            Date date = new Date();
            date.setTime(millis);
            SimpleDateFormat dateF = new SimpleDateFormat("yyyyMMdd");
            return dateF.format(date);
        }
        return "";
    }

    public String toString() {
        String dateMillis = this.getParamValue();
        return DateTimeParam.formatDate(dateMillis);
    }

    public static String formatDate(String dateMillis) {
        if (dateMillis == null) {
            return "no date";
        }
        try {
            long millis = new Long(dateMillis);
            Date date = new Date();
            date.setTime(millis);
            SimpleDateFormat dateF = new SimpleDateFormat("yyyy, MMM d ' at ' HH:mm");
            return dateF.format(date);
        }
        catch (NumberFormatException ex) {
            return dateMillis;
        }
    }
}

