/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.editor.model;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import javax.swing.table.TableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import net.n3.nanoxml.IXMLElement;
import org.openmicroscopy.shoola.agents.editor.model.DataFieldConstants;
import org.openmicroscopy.shoola.agents.editor.model.DataReference;
import org.openmicroscopy.shoola.agents.editor.model.Field;
import org.openmicroscopy.shoola.agents.editor.model.FieldNode;
import org.openmicroscopy.shoola.agents.editor.model.IField;
import org.openmicroscopy.shoola.agents.editor.model.ProtocolRootField;
import org.openmicroscopy.shoola.agents.editor.model.TextBoxStep;
import org.openmicroscopy.shoola.agents.editor.model.TextContent;
import org.openmicroscopy.shoola.agents.editor.model.params.FieldParamsFactory;
import org.openmicroscopy.shoola.agents.editor.model.params.IParam;
import org.openmicroscopy.shoola.agents.editor.model.tables.TableModelFactory;
import org.openmicroscopy.shoola.agents.editor.util.Ontologies;
import org.openmicroscopy.shoola.util.filter.file.EditorFileFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PROimport {
    private static void buildTreeB3(IXMLElement inputElement, DefaultMutableTreeNode treeNode) {
        ArrayList children = inputElement.getChildren();
        for (IXMLElement node : children) {
            if (node == null) continue;
            IField newField = PROimport.createField(node, false);
            FieldNode child = new FieldNode(newField);
            treeNode.add(child);
            PROimport.buildTreeB3(node, child);
        }
    }

    private static IField createXMLField(IXMLElement element) {
        Map<String, String> allAttributes = PROimport.getAttributeMap(element);
        String fieldName = element.getFullName();
        Field field = new Field();
        field.setAttribute("fieldName", fieldName);
        String textContent = element.getContent();
        if (textContent != null && textContent.trim().length() > 0) {
            field.addContent(new TextContent(textContent));
        }
        for (String name : allAttributes.keySet()) {
            String value = allAttributes.get(name);
            IParam param = PROimport.getFieldParam("TEXT");
            param.setAttribute("paramName", name);
            param.setAttribute("value", value);
            field.addContent(param);
        }
        return field;
    }

    private static Map<String, String> getAttributeMap(IXMLElement element) {
        HashMap<String, String> allAttributes = new HashMap<String, String>();
        Enumeration<Object> atts = element.getAttributes().keys();
        while (atts.hasMoreElements()) {
            String attribute = atts.nextElement().toString();
            String attributeValue = element.getAttribute(attribute, null);
            if (attributeValue == null) continue;
            allAttributes.put(attribute, attributeValue);
        }
        return allAttributes;
    }

    private static IField createField(IXMLElement element, boolean root) {
        Map<String, String> allAttributes = PROimport.getAttributeMap(element);
        String paramType = allAttributes.get("inputType");
        if (paramType != null) {
            paramType = DataFieldConstants.getNewInputTypeFromOldInputType(paramType);
        } else {
            String elementName = element.getFullName();
            if (DataFieldConstants.isInputTypeRecognised(elementName)) {
                paramType = elementName;
            } else {
                return PROimport.createXMLField(element);
            }
        }
        String fieldName = allAttributes.get("elementName");
        fieldName = PROimport.removeHtmlTags(fieldName);
        String description = allAttributes.get("description");
        description = PROimport.removeHtmlTags(description);
        String url = allAttributes.get("url");
        Field field = root ? new ProtocolRootField() : new Field();
        if (description != null) {
            field.addContent(new TextContent(description));
        }
        boolean fieldRequired = "true".equals(allAttributes.get("requiredField"));
        if (paramType.equals("TableField")) {
            String colData = allAttributes.get("tableColumnNames");
            String[] colNames = colData.split(",");
            for (int c = 0; c < colNames.length; ++c) {
                String paramName = colNames[c].trim();
                IParam param = PROimport.getFieldParam("TEXT");
                if (fieldRequired) {
                    param.setAttribute("paramRequired", "true");
                }
                param.setAttribute("paramName", paramName);
                field.addContent(param);
            }
            field.setTableData(TableModelFactory.getFieldTable(field));
            TableModel tabularData = field.getTableData();
            int row = 0;
            String rowDataString = allAttributes.get("rowNumber" + row);
            while (rowDataString != null) {
                String[] cellData = rowDataString.split(",");
                for (int c = 0; c < cellData.length; ++c) {
                    tabularData.setValueAt(cellData[c].trim(), row, c);
                }
                rowDataString = allAttributes.get("rowNumber" + ++row);
            }
        } else if (paramType.equals("LinkField") || paramType.equals("ImageField")) {
            String link = allAttributes.get("absoluteFileLink");
            if (link == null) {
                link = allAttributes.get("relativeFileLink");
            }
            EditorFileFilter ff = new EditorFileFilter();
            if (link != null && ff.accept(link)) {
                IParam param = PROimport.getFieldParam("editorLinkParam");
                param.setAttribute("value", link);
                field.addContent(param);
            } else {
                DataReference dataRef = new DataReference();
                String name = "File link";
                if (link == null) {
                    link = allAttributes.get("urlLink");
                    name = "Url";
                }
                if (link == null) {
                    link = allAttributes.get("imagePath");
                    name = "Image link";
                }
                if (link == null) {
                    link = allAttributes.get("relativeImagePath");
                    name = "Relative image link";
                }
                if (link != null) {
                    dataRef.setAttribute("reference", link);
                    dataRef.setAttribute("name", name);
                } else {
                    dataRef.setAttribute("name", "No link");
                }
                field.addDataRef(dataRef);
            }
        } else if (paramType.equals("TextBox")) {
            String value = allAttributes.get("value");
            field = new TextBoxStep(value);
            if (description != null) {
                field.addContent(new TextContent(description));
            }
        } else {
            IParam param = PROimport.getParameter(paramType, allAttributes);
            if (param != null) {
                if (fieldRequired) {
                    param.setAttribute("paramRequired", "true");
                }
                param.setAttribute("paramName", fieldName);
                field.addContent(param);
            }
        }
        field.setAttribute("fieldName", fieldName);
        if (url != null) {
            field.addContent(new TextContent(url + " "));
        }
        return field;
    }

    private static IParam getParameter(String paramType, Map<String, String> allAttributes) {
        IParam param = null;
        if (paramType.equals("TextField")) {
            param = PROimport.getFieldParam("TEXT");
            PROimport.setValueAndDefault(allAttributes, param);
        } else if (paramType.equals("TextBox")) {
            param = PROimport.getFieldParam("TEXTBOX");
            PROimport.setValueAndDefault(allAttributes, param);
        } else if (paramType.equals("NumberField")) {
            param = PROimport.getFieldParam("NUMERIC");
            PROimport.setValueAndDefault(allAttributes, param);
            String units = allAttributes.get("units");
            param.setAttribute("paramUnits", units);
        } else if (paramType.equals("DropDownMenu")) {
            param = PROimport.getFieldParam("ENUMERATION");
            PROimport.setValueAndDefault(allAttributes, param);
            String ddOptions = allAttributes.get("dropdownOptions");
            param.setAttribute("enumOptions", ddOptions);
        } else if (paramType.equals("CheckBoxField")) {
            param = PROimport.getFieldParam("BOOLEAN");
            PROimport.setValueAndDefault(allAttributes, param);
        } else if (paramType.equals("TimeField")) {
            param = PROimport.getFieldParam("NUMERIC");
            String hhmmss = param.getAttribute("value");
            String secs = hhmmss != null ? PROimport.getSeconds(hhmmss) : allAttributes.get("seconds");
            PROimport.saveTimeAsNumber(param, secs);
        } else if (paramType.equals("DateTimeField")) {
            String millisecs = allAttributes.get("UTCMillisecs");
            if (millisecs != null) {
                GregorianCalendar testForAbsoluteDate = new GregorianCalendar();
                testForAbsoluteDate.setTimeInMillis(new Long(millisecs));
                int year = testForAbsoluteDate.get(1);
                if (year != 1970) {
                    param = PROimport.getFieldParam("DATE_TIME");
                    long utcMillis = new Long(millisecs);
                    millisecs = allAttributes.get("seconds");
                    if (millisecs != null) {
                        utcMillis += new Long(millisecs) * 1000L;
                    }
                    param.setValueAt(0, utcMillis + "");
                } else {
                    param = PROimport.getFieldParam("NUMERIC");
                    int days = testForAbsoluteDate.get(5);
                    param.setValueAt(0, days + "");
                    param.setAttribute("paramUnits", "days");
                }
            }
        } else if (paramType.equals("OntologyLookupServiceField")) {
            param = PROimport.getFieldParam("ONTOLOGYTERM");
            String ontologyTermName = allAttributes.get("ontolgoyTermId");
            String ontologyId = Ontologies.getOntologyIdFromB3(ontologyTermName);
            String termId = Ontologies.getTermIdFromB3(ontologyTermName);
            String termName = Ontologies.getTermNameFromB3(ontologyTermName);
            param.setAttribute("ontolgoyId", ontologyId);
            param.setAttribute("termId", termId);
            param.setAttribute("termName", termName);
        }
        return param;
    }

    private static String getSeconds(String hhmmss) {
        String[] split = hhmmss.split(":");
        if (split.length != 3) {
            return hhmmss;
        }
        int seconds = 0;
        seconds += Integer.parseInt(split[0]) * 3600;
        seconds += Integer.parseInt(split[1]) * 60;
        return (seconds += Integer.parseInt(split[0])) + "";
    }

    private static void saveTimeAsNumber(IParam numberParam, String secs) {
        if (secs == null) {
            return;
        }
        try {
            int seconds = Integer.parseInt(secs);
            String units = "seconds";
            String value = secs;
            if (seconds % 60 == 0) {
                units = "minutes";
                value = seconds / 60 + "";
            }
            if (seconds % 3600 == 0) {
                units = "hours";
                value = seconds / 3600 + "";
            }
            if (seconds == 0) {
                units = "seconds";
            }
            numberParam.setAttribute("paramUnits", units);
            numberParam.setAttribute("value", value);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private static IParam getFieldParam(String paramType) {
        return FieldParamsFactory.getFieldParam(paramType);
    }

    private static void setValueAndDefault(Map<String, String> attributes, IParam param) {
        String value = attributes.get("value");
        String defaultValue = attributes.get("default");
        param.setValueAt(0, value);
        param.setAttribute("default-value", defaultValue);
    }

    private static String removeHtmlTags(String withTags) {
        if (withTags == null) {
            return null;
        }
        String noTags = withTags.replace("<br>", "\n");
        noTags = noTags.replace("<br />", "");
        noTags = noTags.replace("<u>", "");
        noTags = noTags.replace("</u>", "");
        noTags = noTags.replace("<b>", "");
        noTags = noTags.replace("</b>", "");
        return noTags;
    }

    public static TreeModel createTreeModel(IXMLElement root) {
        IField rootField = PROimport.createField(root, true);
        FieldNode rootNode = new FieldNode(rootField);
        PROimport.buildTreeB3(root, rootNode);
        return new DefaultTreeModel(rootNode);
    }
}

