/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.editor.browser.paramUIs.editTemplate;

import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import org.openmicroscopy.shoola.agents.editor.browser.paramUIs.AbstractParamEditor;
import org.openmicroscopy.shoola.agents.editor.browser.paramUIs.EnumEditor;
import org.openmicroscopy.shoola.agents.editor.browser.paramUIs.editTemplate.AttributeEditArea;
import org.openmicroscopy.shoola.agents.editor.browser.paramUIs.editTemplate.AttributeEditLine;
import org.openmicroscopy.shoola.agents.editor.browser.paramUIs.editTemplate.AttributeEditNoLabel;
import org.openmicroscopy.shoola.agents.editor.model.IAttributes;
import org.openmicroscopy.shoola.agents.editor.uiComponents.CustomLabel;

public class EnumTemplate
extends AbstractParamEditor
implements PropertyChangeListener {
    private AttributeEditArea optionsFieldEditor;
    private AbstractParamEditor defaultValueComboBox;
    private AttributeEditLine unitsEditor;

    private void initialise() {
        IAttributes param = this.getParameter();
        this.optionsFieldEditor = new AttributeEditArea(param, "enumOptions", "Drop-down options: separate with commas");
        this.optionsFieldEditor.addPropertyChangeListener("valueChangedProperty", this);
        this.optionsFieldEditor.setToolTipText("Add keywords, separated by commas");
        this.defaultValueComboBox = new EnumEditor(param, "default-value");
        this.defaultValueComboBox.addPropertyChangeListener("valueChangedProperty", this);
        this.unitsEditor = new AttributeEditNoLabel(param, "paramUnits", "units");
        this.unitsEditor.addPropertyChangeListener("valueChangedProperty", this);
    }

    private void buildUI() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.optionsFieldEditor, "North");
        this.add((Component)new CustomLabel("Default Value: "), "West");
        this.add((Component)this.defaultValueComboBox, "Center");
        this.add((Component)this.unitsEditor, "East");
    }

    public EnumTemplate(IAttributes param) {
        super(param);
        this.initialise();
        this.buildUI();
    }

    public String getEditDisplayName() {
        return "Drop-down options";
    }

    private String removeDuplicates(String options) {
        if (options == null) {
            return null;
        }
        ArrayList<String> optionList = new ArrayList<String>();
        String[] ops = options.split(",");
        String optionString = "";
        for (int i = 0; i < ops.length; ++i) {
            String item = ops[i].trim();
            if (optionList.contains(item)) continue;
            optionList.add(item);
            if (optionString.length() > 0) {
                optionString = optionString + ", ";
            }
            optionString = optionString + item;
        }
        return optionString;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if ("valueChangedProperty".equals(evt.getPropertyName())) {
            if (evt.getSource().equals(this.defaultValueComboBox)) {
                String newDefault = null;
                if (evt.getNewValue() != null) {
                    newDefault = evt.getNewValue().toString();
                }
                this.attributeEdited("default-value", newDefault);
            }
            if (evt.getSource().equals(this.optionsFieldEditor)) {
                String newOptions = null;
                if (evt.getNewValue() == null) {
                    return;
                }
                newOptions = evt.getNewValue().toString();
                newOptions = this.removeDuplicates(newOptions);
                String defaultValue = this.getParameter().getAttribute("default-value");
                String paramValue = this.getParameter().getAttribute("value");
                if (defaultValue != null && !newOptions.contains(defaultValue)) {
                    defaultValue = null;
                }
                if (paramValue != null && !newOptions.contains(paramValue)) {
                    paramValue = null;
                }
                HashMap<String, String> newAttributes = new HashMap<String, String>();
                newAttributes.put("default-value", defaultValue);
                newAttributes.put("value", paramValue);
                newAttributes.put("enumOptions", newOptions);
                this.attributeEdited("Drop-down options", newAttributes);
            }
            if (evt.getSource().equals(this.unitsEditor)) {
                String newUnits = null;
                if (evt.getNewValue() != null) {
                    newUnits = evt.getNewValue().toString();
                }
                this.attributeEdited("paramUnits", newUnits);
            }
        }
    }
}

