/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.editor.browser.paramUIs;

import java.awt.Toolkit;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.DocumentFilter;

public class NumberFilter
extends DocumentFilter {
    private Document doc;

    public NumberFilter(Document doc) {
        this.doc = doc;
    }

    private boolean canInsert(String str) throws BadLocationException {
        String currentVal = this.doc.getText(0, this.doc.getLength());
        if (str.contains(".") && currentVal.contains(".")) {
            return false;
        }
        if (str.contains("-") && currentVal.contains("-")) {
            return false;
        }
        if (".".equals(str) || "-".equals(str)) {
            return true;
        }
        try {
            Float s = Float.valueOf(str);
            return true;
        }
        catch (NumberFormatException ex) {
            return false;
        }
    }

    public void insertString(DocumentFilter.FilterBypass fb, int offs, String str, AttributeSet a) throws BadLocationException {
        if (this.canInsert(str)) {
            super.insertString(fb, offs, str, a);
        } else {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    public void replace(DocumentFilter.FilterBypass fb, int offs, int length, String str, AttributeSet a) throws BadLocationException {
        if (this.canInsert(str)) {
            super.insertString(fb, offs, str, a);
        } else {
            Toolkit.getDefaultToolkit().beep();
        }
    }
}

