/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.editor.browser.paramUIs;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.swing.Box;
import org.jdesktop.swingx.JXDatePicker;
import org.openmicroscopy.shoola.agents.editor.browser.paramUIs.AbstractParamEditor;
import org.openmicroscopy.shoola.agents.editor.model.params.IParam;
import org.openmicroscopy.shoola.agents.editor.uiComponents.CustomLabel;
import org.openmicroscopy.shoola.agents.editor.uiComponents.HrsMinsField;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

public class DateTimeField
extends AbstractParamEditor
implements PropertyChangeListener,
ActionListener {
    private JXDatePicker datePicker;
    public static final String PICK_DATE = "Pick Date";
    private HrsMinsField hrsMinsEditor;

    private void initialise() {
        IParam param = (IParam)this.getParameter();
        this.datePicker = UIUtilities.createDatePicker();
        this.datePicker.getEditor().setEditable(false);
        int hrs = 0;
        int mins = 0;
        String millisecs = param.getParamValue();
        if (millisecs != null) {
            long UTCMillisecs = new Long(millisecs);
            Date date = new Date(UTCMillisecs);
            this.datePicker.setDate(date);
            GregorianCalendar cal = new GregorianCalendar();
            cal.setTimeInMillis(UTCMillisecs);
            hrs = cal.get(11);
            mins = cal.get(12);
        } else {
            this.datePicker.setDate(null);
            this.datePicker.getEditor().setText(PICK_DATE);
        }
        this.datePicker.addActionListener((ActionListener)this);
        this.hrsMinsEditor = new HrsMinsField();
        this.hrsMinsEditor.setTime(hrs, mins);
        if (millisecs == null) {
            this.hrsMinsEditor.setVisible(false);
        }
        this.hrsMinsEditor.addPropertyChangeListener("timeInSeconds", this);
    }

    private void buildUI() {
        this.add((Component)this.datePicker);
        this.add(Box.createHorizontalStrut(10));
        this.add(new CustomLabel("Time: "));
        this.add(this.hrsMinsEditor);
    }

    private void dateTimeEdited() {
        String newDateTime = null;
        Date date = this.datePicker.getDate();
        if (date != null) {
            long timeInMillis = date.getTime();
            int secs = this.hrsMinsEditor.getTimeInSecs();
            newDateTime = (timeInMillis += (long)(secs * 1000)) + "";
        }
        this.attributeEdited("value", newDateTime);
    }

    public DateTimeField(IParam param) {
        super(param);
        this.initialise();
        this.buildUI();
    }

    public static int convertMillisecsToDays(long millisecs) {
        int milliseconds = (int)millisecs;
        int millisecsPerDay = 86400000;
        int days = milliseconds / millisecsPerDay;
        return days;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        this.dateTimeEdited();
    }

    public void actionPerformed(ActionEvent e) {
        this.dateTimeEdited();
    }

    public String getEditDisplayName() {
        return "Edit Date-Time";
    }
}

