/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.editor.browser.actions;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openmicroscopy.shoola.agents.editor.IconManager;
import org.openmicroscopy.shoola.agents.editor.browser.Browser;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

public abstract class BrowserAction
extends AbstractAction
implements ChangeListener {
    protected Browser model;

    protected abstract void onStateChange();

    public BrowserAction(Browser model) {
        this.setEnabled(false);
        if (model == null) {
            throw new IllegalArgumentException("No Browser");
        }
        this.model = model;
        model.addChangeListener(this);
    }

    protected void setName(String name) {
        this.putValue("Name", name);
    }

    protected void setDescription(String description) {
        this.putValue("ShortDescription", UIUtilities.formatToolTipText(description));
    }

    protected void setIcon(int iconID) {
        IconManager im = IconManager.getInstance();
        this.putValue("SmallIcon", im.getIcon(iconID));
    }

    public abstract void actionPerformed(ActionEvent var1);

    public void stateChanged(ChangeEvent e) {
        this.onStateChange();
    }
}

