/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.editor.browser;

import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JToolBar;
import javax.swing.JTree;
import org.openmicroscopy.shoola.agents.editor.browser.BrowserControl;
import org.openmicroscopy.shoola.agents.editor.model.undoableEdits.TreeEdit;
import org.openmicroscopy.shoola.agents.editor.uiComponents.CustomButton;

public class ToolBar
extends JPanel {
    private BrowserControl controller;
    private JTree treeUI;

    private void buildUI() {
        this.setLayout(new BoxLayout(this, 0));
        JToolBar bar = new JToolBar();
        bar.setFloatable(false);
        bar.setRollover(true);
        bar.setBorder(null);
        bar.add(this.createButton(BrowserControl.ADD_FIELD_ACTION));
        bar.add(this.createButton(BrowserControl.ADD_TEXTBOX_FIELD_ACTION));
        bar.add(this.createButton(BrowserControl.DELETE_FIELD_ACTION));
        bar.add(this.createButton(BrowserControl.INDENT_LEFT_ACTION));
        bar.add(this.createButton(BrowserControl.INDENT_RIGHT_ACTION));
        bar.add(this.createButton(BrowserControl.MOVE_UP_ACTION));
        bar.add(this.createButton(BrowserControl.MOVE_DOWN_ACTION));
        bar.add(new JSeparator(1));
        bar.add(this.createButton(BrowserControl.UNDO_ACTION));
        bar.add(this.createButton(BrowserControl.REDO_ACTION));
        bar.add(new JSeparator(1));
        bar.add(this.createButton(BrowserControl.ADD_EXP_INFO_ACTION));
        bar.add(this.createButton(BrowserControl.CLEAR_VALUES_ACTION));
        this.add(bar);
        bar.add(new JSeparator(1));
        bar.add(this.createButton(BrowserControl.COPY_FIELDS_ACTION));
        bar.add(this.createButton(BrowserControl.PASTE_FIELDS_ACTION));
    }

    private JButton createButton(int actionID) {
        Action action = this.controller.getAction(actionID);
        if (action instanceof TreeEdit) {
            ((TreeEdit)((Object)action)).setTree(this.treeUI);
        }
        CustomButton b = new CustomButton(action);
        b.setText("");
        return b;
    }

    ToolBar(BrowserControl controller, JTree tree) {
        if (controller == null) {
            throw new NullPointerException("No controller.");
        }
        if (tree == null) {
            throw new NullPointerException("No JTree.");
        }
        this.controller = controller;
        this.treeUI = tree;
        this.buildUI();
    }
}

