/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.editor.browser;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import org.openmicroscopy.shoola.agents.editor.browser.BrowserControl;
import org.openmicroscopy.shoola.agents.editor.browser.paramUIs.editTemplate.FieldContentEditor;
import org.openmicroscopy.shoola.agents.editor.browser.paramUIs.editTemplate.FieldParamEditor;
import org.openmicroscopy.shoola.agents.editor.model.IField;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

public class FieldEditorDisplay
extends JPanel
implements TreeSelectionListener,
TreeModelListener {
    private JTree tree;
    private BrowserControl controller;
    private JScrollPane scrollPane;
    private JComponent currentDisplay;
    private long id;
    private int yScrollPosition;

    private void buildUI() {
        this.setLayout(new BorderLayout());
        this.scrollPane = new JScrollPane();
        this.scrollPane.getViewport().setBackground(UIUtilities.BACKGROUND_COLOR);
        this.scrollPane.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.setMinimumSize(new Dimension(220, 220));
        this.scrollPane.setPreferredSize(new Dimension(250, 250));
        this.add((Component)this.scrollPane, "Center");
    }

    private JComponent getCurrentPanel() {
        int editView = this.controller.getViewingMode();
        if (this.tree.getSelectionCount() == 1) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.tree.getSelectionPath().getLastPathComponent();
            IField field = (IField)node.getUserObject();
            FieldParamEditor fe = editView == 0 ? new FieldContentEditor(field, this.tree, node, this.controller) : new FieldParamEditor(field, this.tree, node, this.controller);
            fe.setId(this.id);
            return fe;
        }
        return new JPanel();
    }

    public FieldEditorDisplay(JTree tree, BrowserControl controller) {
        this.controller = controller;
        this.tree = tree;
        tree.addTreeSelectionListener(this);
        this.buildUI();
    }

    void refreshEditorDisplay() {
        this.setPanel(this.getCurrentPanel(), 0);
    }

    private void updateEditorDisplay() {
        int y = (int)this.scrollPane.getViewport().getViewPosition().getY();
        this.setPanel(this.getCurrentPanel(), y);
    }

    private void setPanel(JComponent panel, int y) {
        this.yScrollPosition = y;
        this.currentDisplay = panel;
        this.scrollPane.setViewportView(this.currentDisplay);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                FieldEditorDisplay.this.scrollPane.getViewport().setViewPosition(new Point(0, FieldEditorDisplay.this.yScrollPosition));
            }
        });
        this.validate();
        this.repaint();
    }

    void setId(long id) {
        this.id = id;
        if (this.currentDisplay != null && this.currentDisplay instanceof FieldParamEditor) {
            ((FieldParamEditor)this.currentDisplay).setId(id);
        }
    }

    public void valueChanged(TreeSelectionEvent e) {
        this.refreshEditorDisplay();
    }

    public void treeNodesChanged(TreeModelEvent e) {
        this.updateEditorDisplay();
    }

    public void treeNodesInserted(TreeModelEvent e) {
    }

    public void treeNodesRemoved(TreeModelEvent e) {
    }

    public void treeStructureChanged(TreeModelEvent e) {
    }
}

