/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.dataBrowser.view;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;
import org.jdesktop.swingx.JXTaskPane;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.RollOverNode;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.WellImageSet;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.WellSampleNode;
import org.openmicroscopy.shoola.agents.dataBrowser.view.DataBrowserControl;
import org.openmicroscopy.shoola.agents.dataBrowser.view.WellFieldsCanvas;
import org.openmicroscopy.shoola.agents.dataBrowser.view.WellsModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class WellFieldsView
extends JPanel {
    static final int MAGNIFICATION_UNSCALED_MIN = 1;
    static final int MAGNIFICATION_UNSCALED_MAX = 4;
    static final int ROW_LAYOUT = 0;
    static final int SPATIAL_LAYOUT = 1;
    static final int DEFAULT_LAYOUT = 1;
    static final int DEFAULT_WIDTH = 512;
    static final int DEFAULT_HEIGHT = 512;
    private static final String DEFAULT_WELL_TEXT = "Well: ";
    private static final String DEFAULT_FIELD_TEXT = "Field #";
    private WellsModel model;
    private DataBrowserControl controller;
    private WellFieldsCanvas canvas;
    private List<WellSampleNode> nodes;
    private int layoutFields;
    private JLabel selectedNode;
    private JLabel selectedField;
    private double magnification;
    private double magnificationUnscaled;
    private JXTaskPane plateTask;

    private void initComponents() {
        this.magnificationUnscaled = 1.0;
        this.layoutFields = 1;
        this.selectedField = new JLabel();
        WellImageSet node = this.model.getSelectedWell();
        this.selectedNode = new JLabel();
        if (node != null) {
            this.selectedNode.setText(DEFAULT_WELL_TEXT + node.getWellLocation());
        }
        this.canvas = new WellFieldsCanvas(this);
        this.canvas.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent e) {
                WellSampleNode node = WellFieldsView.this.canvas.getNode(e.getPoint());
                if (node != null) {
                    WellFieldsView.this.model.setSelectedField(node);
                    if (e.getClickCount() == 2) {
                        WellFieldsView.this.controller.viewDisplay(node);
                    }
                }
            }

            public void mousePressed(MouseEvent e) {
            }
        });
        this.canvas.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseMoved(MouseEvent e) {
                if (WellFieldsView.this.model.getBrowser().isRollOver()) {
                    Point p = e.getPoint();
                    WellSampleNode node = WellFieldsView.this.canvas.getNode(p);
                    SwingUtilities.convertPointToScreen(p, WellFieldsView.this.canvas);
                    WellFieldsView.this.model.getBrowser().setRollOverNode(new RollOverNode(node, p));
                } else {
                    Point p = e.getPoint();
                    WellSampleNode node = WellFieldsView.this.canvas.getNode(p);
                    if (node != null) {
                        StringBuffer buffer = new StringBuffer();
                        buffer.append(WellFieldsView.DEFAULT_FIELD_TEXT + node.getIndex());
                        buffer.append("\n");
                        buffer.append("x=" + node.getPositionX() + ", " + "y=" + node.getPositionY());
                        String s = buffer.toString();
                        WellFieldsView.this.canvas.setToolTipText(s);
                        WellFieldsView.this.selectedField.setText(s);
                    } else {
                        WellFieldsView.this.canvas.setToolTipText("");
                        WellFieldsView.this.selectedField.setText("");
                    }
                }
            }
        });
        this.nodes = null;
    }

    private void buildGUI() {
        this.setBorder(new LineBorder(new Color(99, 130, 191)));
        this.setLayout(new BorderLayout(0, 0));
        JScrollPane pane = new JScrollPane(this.canvas);
        pane.setPreferredSize(new Dimension(512, 512));
        this.add((Component)pane, "Center");
    }

    WellFieldsView(WellsModel model, DataBrowserControl controller, double magnification) {
        this.model = model;
        this.controller = controller;
        this.magnification = magnification;
        this.initComponents();
        this.buildGUI();
    }

    void setLayoutFields(int layoutFields) {
        this.layoutFields = layoutFields;
    }

    int getLayoutFields() {
        return this.layoutFields;
    }

    List<WellSampleNode> getNodes() {
        return this.nodes;
    }

    void displayFields(List<WellSampleNode> nodes) {
        WellSampleNode node;
        this.nodes = nodes;
        if (nodes != null && nodes.size() > 0 && (node = nodes.get(0)) != null) {
            this.selectedNode.setText(DEFAULT_WELL_TEXT + node.getParentWell().getWellLocation());
            this.selectedNode.repaint();
        }
        this.canvas.repaint();
    }

    void setMagnificationFactor(double factor) {
        this.magnification = factor;
        this.canvas.repaint();
    }

    double getMagnification() {
        return this.magnification;
    }

    void setMagnificationUnscaled(double factor) {
        this.magnificationUnscaled = factor;
        this.canvas.repaint();
    }

    double getMagnificationUnscaled() {
        return this.magnificationUnscaled;
    }
}

