/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.dataBrowser.view;

import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import org.openmicroscopy.shoola.agents.dataBrowser.DataBrowserAgent;
import org.openmicroscopy.shoola.agents.dataBrowser.IconManager;
import org.openmicroscopy.shoola.agents.dataBrowser.util.FilteringDialog;
import org.openmicroscopy.shoola.agents.dataBrowser.util.QuickFiltering;
import org.openmicroscopy.shoola.agents.dataBrowser.view.DataBrowserControl;
import org.openmicroscopy.shoola.agents.dataBrowser.view.DataBrowserModel;
import org.openmicroscopy.shoola.agents.dataBrowser.view.DataBrowserUI;
import org.openmicroscopy.shoola.agents.util.SelectionWizard;
import org.openmicroscopy.shoola.agents.util.ui.EditorDialog;
import org.openmicroscopy.shoola.env.config.Registry;
import org.openmicroscopy.shoola.env.data.util.FilterContext;
import org.openmicroscopy.shoola.util.filter.file.ExcelFilter;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import org.openmicroscopy.shoola.util.ui.filechooser.FileChooser;
import org.openmicroscopy.shoola.util.ui.search.SearchObject;
import org.openmicroscopy.shoola.util.ui.search.SearchUtil;
import pojos.DataObject;
import pojos.DatasetData;
import pojos.TagAnnotationData;
import pojos.TextualAnnotationData;

class DataBrowserToolBar
extends JPanel
implements ActionListener,
PropertyChangeListener {
    private static final String ITEMS_PER_ROW_TEXT = "Set the number of elements per row.";
    private static final String FILTER_BY = "Filter by: ";
    private static final int ROLL_OVER = 10;
    private static final int NEW_OBJECT = 11;
    private static final int SLIDE_SHOW_IMAGES = 12;
    private static final int SLIDE_SHOW_SELECTION = 13;
    private static final int ITEMS_PER_ROW = 14;
    private static final int REPORT = 15;
    private static final int EXISTING_OBJECT = 16;
    private static final int TAG_FILTER = 17;
    private DataBrowserControl controller;
    private DataBrowserUI view;
    private DataBrowserModel model;
    private QuickFiltering search;
    private JButton filterButton;
    private JButton filterByMenuButton;
    private FilteringDialog filteringDialog;
    private JToggleButton thumbView;
    private JToggleButton columnsView;
    private JToggleButton orderByName;
    private JToggleButton orderByDate;
    private JButton slideShowView;
    private JButton managementButton;
    private JButton refreshButton;
    private JButton saveButton;
    private JPopupMenu slideViewMenu;
    private JPopupMenu manageMenu;
    private JCheckBoxMenuItem rollOverItem;
    private JToggleButton rollOverButton;
    private JButton createDatasetButton;
    private JTextField itemsPerRow;
    private JLabel status;
    private JLabel filteringLabel;
    private JButton reportButton;
    private JPopupMenu createMenu;
    private JPopupMenu filterByMenu;
    private boolean codeCompletion;

    private void showTagsWizard(Collection existingTags) {
        if (existingTags == null) {
            return;
        }
        IconManager icons = IconManager.getInstance();
        String title = "Filter By Tags";
        String text = "Select the Tags to filter by.";
        ArrayList<Object> selected = new ArrayList<Object>();
        Iterator i = existingTags.iterator();
        List<String> l = SearchUtil.splitTerms(this.search.getSearchValue(), ",");
        ArrayList<Object> available = new ArrayList<Object>();
        while (i.hasNext()) {
            TagAnnotationData tag = (TagAnnotationData)i.next();
            if (l.contains(tag.getTagValue())) {
                selected.add(tag);
                continue;
            }
            available.add(tag);
        }
        long id = DataBrowserAgent.getUserDetails().getId();
        SelectionWizard wizard = new SelectionWizard(DataBrowserAgent.getRegistry().getTaskBar().getFrame(), available, selected, TagAnnotationData.class, false, id);
        wizard.setTitle(title, text, icons.getIcon(48));
        wizard.addPropertyChangeListener(this);
        UIUtilities.centerAndShow(wizard);
    }

    private JPopupMenu createFilterByMenu() {
        if (this.filterByMenu != null) {
            return this.filterByMenu;
        }
        this.filterByMenu = new JPopupMenu();
        IconManager icons = IconManager.getInstance();
        JMenuItem menuItem = new JMenuItem("Load Tags to filter by...");
        menuItem.setToolTipText("Load the existing Tags to filter by.");
        menuItem.setIcon(icons.getIcon(49));
        menuItem.addActionListener(this);
        menuItem.setActionCommand("17");
        this.filterByMenu.add(menuItem);
        return this.filterByMenu;
    }

    private JPopupMenu createNewObjectMenu() {
        if (this.createMenu != null) {
            return this.createMenu;
        }
        IconManager icons = IconManager.getInstance();
        this.createMenu = new JPopupMenu();
        JMenuItem menuItem = new JMenuItem("New Dataset");
        menuItem.setToolTipText("Create a Dataset.");
        menuItem.setIcon(icons.getIcon(22));
        menuItem.addActionListener(this);
        menuItem.setActionCommand("11");
        menuItem.setEnabled(this.model.isParentWritable());
        this.createMenu.add(menuItem);
        menuItem = new JMenuItem("Existing Dataset");
        menuItem.setToolTipText("Select a dataset to add the images to.");
        menuItem.setIcon(icons.getIcon(15));
        menuItem.addActionListener(this);
        menuItem.setActionCommand("16");
        this.createMenu.add(menuItem);
        menuItem.setEnabled(this.model.isParentWritable());
        return this.createMenu;
    }

    private JPopupMenu createManageMenu() {
        if (this.manageMenu != null) {
            return this.manageMenu;
        }
        IconManager icons = IconManager.getInstance();
        this.manageMenu = new JPopupMenu();
        JMenuItem menuItem = new JMenuItem("New Dataset");
        menuItem.setToolTipText("Create a Dataset.");
        menuItem.setIcon(icons.getIcon(22));
        menuItem.addActionListener(this);
        menuItem.setActionCommand("11");
        menuItem.setEnabled(this.model.isParentWritable());
        this.manageMenu.add(menuItem);
        JPanel panel = new JPanel();
        panel.setLayout(new FlowLayout(0, 5, 0));
        JLabel l = new JLabel(icons.getIcon(18));
        l.setText(ITEMS_PER_ROW_TEXT);
        panel.add(Box.createHorizontalStrut(5));
        panel.add(l);
        this.itemsPerRow = new JTextField(3);
        this.itemsPerRow.addActionListener(this);
        this.itemsPerRow.setActionCommand("14");
        panel.add(this.itemsPerRow);
        this.manageMenu.add(panel);
        this.rollOverItem = new JCheckBoxMenuItem();
        this.rollOverItem.setIcon(icons.getIcon(21));
        this.rollOverItem.setText("Mouse over and Magnify");
        this.rollOverItem.addActionListener(this);
        this.rollOverItem.setActionCommand("10");
        this.manageMenu.add(this.rollOverItem);
        return this.manageMenu;
    }

    private JPopupMenu createSlideViewMenu() {
        if (this.slideViewMenu != null) {
            return this.slideViewMenu;
        }
        this.slideViewMenu = new JPopupMenu();
        JMenuItem item = new JMenuItem("View Selected Images");
        item.addActionListener(this);
        item.setActionCommand("13");
        this.slideViewMenu.add(item);
        item = new JMenuItem("View Displayed Images");
        item.addActionListener(this);
        item.setActionCommand("12");
        this.slideViewMenu.add(item);
        return this.slideViewMenu;
    }

    private void setFilteringValue() {
        SearchObject filter = this.search.getSelectedNode();
        if (filter == null) {
            return;
        }
        switch (filter.getIndex()) {
            case 10: {
                this.filteringDialog.setTagsText("");
                break;
            }
            case 0: {
                this.filteringDialog.setTagsText(this.search.getSearchValue());
                break;
            }
            case 11: {
                this.filteringDialog.setCommentsText("");
                break;
            }
            case 1: {
                this.filteringDialog.setCommentsText(this.search.getSearchValue());
                break;
            }
            case 3: {
                this.filteringDialog.setRatingLevel(1);
                break;
            }
            case 4: {
                this.filteringDialog.setRatingLevel(2);
                break;
            }
            case 5: {
                this.filteringDialog.setRatingLevel(3);
                break;
            }
            case 6: {
                this.filteringDialog.setRatingLevel(4);
                break;
            }
            case 7: {
                this.filteringDialog.setRatingLevel(5);
                break;
            }
            case 8: {
                this.filteringDialog.setRatingLevel(0);
            }
        }
    }

    private void showFilteringDialog(Point location) {
        if (this.filteringDialog == null) {
            Registry reg = DataBrowserAgent.getRegistry();
            this.filteringDialog = new FilteringDialog(reg.getTaskBar().getFrame());
            this.filteringDialog.addPropertyChangeListener(this.controller);
            this.filteringDialog.setTags(this.view.getExistingTags(), false);
        }
        this.setFilteringValue();
        SwingUtilities.convertPointToScreen(location, this.filterButton);
        this.filteringDialog.setLocation(location);
        this.filteringDialog.setVisible(true);
    }

    private void initComponents() {
        this.filteringLabel = new JLabel();
        this.filteringLabel.setFont(this.filteringLabel.getFont().deriveFont(1));
        this.status = new JLabel();
        this.status.setFont(this.status.getFont().deriveFont(1));
        IconManager icons = IconManager.getInstance();
        String text = null;
        if (this.model.getType() == 8) {
            text = "users";
        }
        this.search = new QuickFiltering(text);
        this.search.setDefaultText(text);
        this.search.addPropertyChangeListener(this.controller);
        this.filterButton = new JButton(icons.getIcon(5));
        this.filterButton.setToolTipText("Filter elements displayed in the Workspace.");
        this.filterButton.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent e) {
                DataBrowserToolBar.this.showFilteringDialog(e.getPoint());
            }
        });
        this.filterButton.addPropertyChangeListener(this.controller);
        UIUtilities.unifiedButtonLookAndFeel(this.filterButton);
        this.filterByMenuButton = new JButton(icons.getIcon(50));
        this.filterByMenuButton.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent e) {
                DataBrowserToolBar.this.createFilterByMenu();
                Point p = e.getPoint();
                DataBrowserToolBar.this.filterByMenu.show(DataBrowserToolBar.this.filterByMenuButton, p.x, p.y);
            }
        });
        UIUtilities.unifiedButtonLookAndFeel(this.filterByMenuButton);
        ButtonGroup group = new ButtonGroup();
        int index = this.view.getSelectedView();
        this.thumbView = new JToggleButton(icons.getIcon(2));
        this.thumbView.setToolTipText("View as Thumbnails.");
        this.thumbView.addActionListener(this);
        this.thumbView.setActionCommand("0");
        this.thumbView.setSelected(index == 0);
        group.add(this.thumbView);
        this.columnsView = new JToggleButton(icons.getIcon(3));
        this.columnsView.setToolTipText("View as List.");
        this.columnsView.addActionListener(this);
        this.columnsView.setActionCommand("1");
        this.columnsView.setSelected(index == 1);
        group.add(this.columnsView);
        this.slideShowView = new JButton(icons.getIcon(6));
        this.slideShowView.setToolTipText("Show slideshow.");
        UIUtilities.unifiedButtonLookAndFeel(this.slideShowView);
        this.slideShowView.addActionListener(this);
        this.slideShowView.setActionCommand("12");
        this.managementButton = new JButton(icons.getIcon(20));
        UIUtilities.unifiedButtonLookAndFeel(this.managementButton);
        this.managementButton.setToolTipText("Manage elements.");
        this.managementButton.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent e) {
                DataBrowserToolBar.this.createManageMenu().show(DataBrowserToolBar.this.managementButton, e.getX(), e.getY());
            }
        });
        group = new ButtonGroup();
        this.orderByName = new JToggleButton(icons.getIcon(25));
        this.orderByName.setToolTipText("Order elements by name.");
        this.orderByName.addActionListener(this);
        this.orderByName.setActionCommand("2");
        this.orderByName.setSelected(true);
        group.add(this.orderByName);
        this.orderByDate = new JToggleButton(icons.getIcon(24));
        if (this.model.getType() != 8) {
            this.orderByDate.setToolTipText("Order images by acquisition date.");
        } else {
            this.orderByDate.setToolTipText("Order users by creation date.");
        }
        this.orderByDate.addActionListener(this);
        this.orderByDate.setActionCommand("3");
        group.add(this.orderByDate);
        this.refreshButton = new JButton(this.controller.getAction(DataBrowserControl.REFRESH));
        UIUtilities.unifiedButtonLookAndFeel(this.refreshButton);
        this.rollOverButton = new JToggleButton();
        this.rollOverButton.setIcon(icons.getIcon(21));
        this.rollOverButton.setToolTipText("Turn on/off the magnification of a thumbnail while mousing over it.");
        this.rollOverButton.addActionListener(this);
        this.rollOverButton.setActionCommand("10");
        this.createDatasetButton = new JButton();
        this.createDatasetButton.setToolTipText("Create a new dataset containing the displayed images.");
        UIUtilities.unifiedButtonLookAndFeel(this.createDatasetButton);
        this.createDatasetButton.setIcon(icons.getIcon(15));
        this.createDatasetButton.setEnabled(this.model.isParentWritable());
        this.createDatasetButton.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent e) {
                DataBrowserToolBar.this.createNewObjectMenu().show(DataBrowserToolBar.this.createDatasetButton, e.getX(), e.getY());
            }
        });
        this.itemsPerRow = new JTextField(3);
        this.itemsPerRow.setToolTipText(ITEMS_PER_ROW_TEXT);
        this.itemsPerRow.addActionListener(this);
        this.itemsPerRow.setActionCommand("14");
        this.saveButton = new JButton(this.controller.getAction(DataBrowserControl.SAVE_AS));
        UIUtilities.unifiedButtonLookAndFeel(this.saveButton);
        this.reportButton = new JButton();
        this.reportButton.setToolTipText("Create a report.");
        this.reportButton.setIcon(icons.getIcon(37));
        this.reportButton.addActionListener(this);
        this.reportButton.setActionCommand("15");
        this.reportButton.setEnabled(this.model.isParentWritable());
        UIUtilities.unifiedButtonLookAndFeel(this.reportButton);
        this.addPropertyChangeListener(this.controller);
        this.codeCompletion = true;
    }

    private JToolBar buildViewsBar() {
        JToolBar bar = new JToolBar();
        bar.setFloatable(false);
        bar.setBorder(null);
        bar.setRollover(true);
        bar.add(this.thumbView);
        bar.add(this.columnsView);
        bar.add(this.refreshButton);
        bar.add(Box.createHorizontalStrut(2));
        bar.add(new JSeparator(1));
        bar.add(Box.createHorizontalStrut(2));
        bar.add(this.orderByName);
        bar.add(this.orderByDate);
        bar.add(Box.createHorizontalStrut(2));
        bar.add(new JSeparator(1));
        bar.add(Box.createHorizontalStrut(2));
        bar.add(this.rollOverButton);
        if (this.model.getType() != 8) {
            bar.add(this.createDatasetButton);
            bar.add(this.reportButton);
            bar.add(this.saveButton);
            bar.add(new JSeparator(1));
        }
        JPanel panel = new JPanel();
        panel.setLayout(new FlowLayout(0, 5, 0));
        panel.add(new JLabel("# per row:"));
        panel.add(this.itemsPerRow);
        panel.setToolTipText(this.itemsPerRow.getToolTipText());
        bar.add(panel);
        return bar;
    }

    private void buildGUI() {
        JPanel content = new JPanel();
        content.setLayout(new BoxLayout(content, 1));
        JPanel p = new JPanel();
        JToolBar bar = new JToolBar();
        bar.setFloatable(false);
        bar.setBorder(null);
        bar.setRollover(true);
        bar.add(this.filterButton);
        bar.add(this.filterByMenuButton);
        p.add(bar);
        p.add(this.search);
        p.add(this.buildViewsBar());
        content.add(p);
        JPanel text = new JPanel();
        text.setLayout(new FlowLayout(0, 0, 0));
        JPanel labelPane = new JPanel();
        labelPane.setLayout(new BoxLayout(labelPane, 0));
        labelPane.add(this.status);
        labelPane.add(Box.createHorizontalStrut(10));
        labelPane.add(this.filteringLabel);
        text.add(labelPane);
        content.add(text);
        this.setLayout(new FlowLayout(0, 0, 0));
        this.add(content);
    }

    private void report() {
        ArrayList<FileFilter> filterList = new ArrayList<FileFilter>();
        ExcelFilter filter = new ExcelFilter();
        filterList.add(filter);
        JFrame frame = DataBrowserAgent.getRegistry().getTaskBar().getFrame();
        FileChooser chooser = new FileChooser(frame, 1, "Create a report", "Create a tag report", filterList);
        IconManager icons = IconManager.getInstance();
        chooser.setTitleIcon(icons.getIcon(38));
        try {
            File f = UIUtilities.getDefaultFolder();
            if (f != null) {
                chooser.setCurrentDirectory(f);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        int option = chooser.centerDialog();
        if (option != 0) {
            return;
        }
        File file = chooser.getFormattedSelectedFile();
        this.controller.createReport(file.getAbsolutePath());
    }

    DataBrowserToolBar(DataBrowserModel model, DataBrowserUI view, DataBrowserControl controller) {
        if (controller == null) {
            throw new IllegalArgumentException("No control.");
        }
        if (view == null) {
            throw new IllegalArgumentException("No view.");
        }
        if (model == null) {
            throw new IllegalArgumentException("No model.");
        }
        this.model = model;
        this.controller = controller;
        this.view = view;
        this.initComponents();
        this.buildGUI();
    }

    int getItemsPerRow() {
        int row = -1;
        try {
            row = Integer.parseInt(this.itemsPerRow.getText());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (row < 0) {
            row = 10;
        }
        return row;
    }

    void setSelectedViewIndex(int index) {
        this.thumbView.removeActionListener(this);
        this.columnsView.removeActionListener(this);
        this.thumbView.setSelected(index == 0);
        this.columnsView.setSelected(index == 1);
        this.thumbView.addActionListener(this);
        this.columnsView.addActionListener(this);
    }

    void enableSlideShow(boolean enable) {
        this.slideShowView.setEnabled(enable);
    }

    SearchObject getSelectedFilter() {
        return this.search.getSelectedNode();
    }

    void setTags(Collection tags) {
        this.search.setTags(tags);
        if (this.filteringDialog != null && this.filteringDialog.isVisible()) {
            this.filteringDialog.setTags(tags, true);
        } else if (!this.codeCompletion) {
            this.codeCompletion = false;
            this.showTagsWizard(tags);
        }
    }

    void onExperimenterSet() {
        this.createDatasetButton.setEnabled(this.model.isParentWritable());
    }

    void setNumberOfImages(int value, int total) {
        String s = "Workspace: " + value + " of " + total;
        s = this.model.getType() == 8 ? s + " user" : s + " image";
        if (total > 1) {
            s = s + "s";
        }
        this.status.setText(s);
        this.status.repaint();
    }

    void setFilterLabel(String value) {
        if (value != null && value.length() > 0) {
            this.filteringLabel.setText(FILTER_BY + value);
        } else {
            this.filteringLabel.setText("");
        }
    }

    void setFilterStatus(boolean busy) {
        this.search.setFilteringStatus(busy);
    }

    void filterByContext(FilterContext context) {
        if (context == null) {
            return;
        }
        this.search.setSearchEnabled(true);
        switch (context.getContext()) {
            case 3: {
                List<Integer> c = context.getContextList();
                String text = "";
                if (c.contains(0)) {
                    text = text + "Rate";
                }
                if (c.contains(1)) {
                    if (text.length() != 0) {
                        text = text + ", ";
                    }
                    text = text + "Tags";
                }
                if (c.contains(2)) {
                    if (text.length() != 0) {
                        text = text + ", ";
                    }
                    text = text + "Comments";
                }
                if (c.contains(5)) {
                    if (text.length() != 0) {
                        text = text + ", ";
                    }
                    text = text + "Name";
                }
                this.setFilterLabel(text);
                break;
            }
            case 4: {
                this.search.setSearchContext(9);
                this.setFilterLabel("");
                this.search.setSearchEnabled(false);
                this.search.setFilteringStatus(false);
                break;
            }
            case 0: {
                this.search.setSearchEnabled(false);
                this.setFilterLabel("Rate");
                if (context.getIndex() == 1) break;
                switch (context.getRate()) {
                    case 0: {
                        this.setFilterLabel("Unrated");
                        this.search.setSearchContext(8);
                        break;
                    }
                    case 1: {
                        this.search.setSearchContext(3);
                        break;
                    }
                    case 2: {
                        this.search.setSearchContext(4);
                        break;
                    }
                    case 3: {
                        this.search.setSearchContext(5);
                        break;
                    }
                    case 4: {
                        this.search.setSearchContext(6);
                        break;
                    }
                    case 5: {
                        this.search.setSearchContext(7);
                    }
                }
                break;
            }
            case 1: {
                this.setFilterLabel("Tags");
                this.search.setSearchContext(0);
                List<String> terms = context.getAnnotation(TagAnnotationData.class);
                if (terms == null) break;
                this.search.setSearchValue(terms, this.codeCompletion);
                this.codeCompletion = true;
                break;
            }
            case 2: {
                this.setFilterLabel("Comments");
                this.search.setSearchContext(1);
                List<String> terms = context.getAnnotation(TextualAnnotationData.class);
                if (terms == null) break;
                this.search.setSearchValue(terms, true);
                break;
            }
            case 5: {
                this.setFilterLabel("Name");
                this.search.setSearchContext(2);
            }
        }
    }

    public void actionPerformed(ActionEvent e) {
        int index = Integer.parseInt(e.getActionCommand());
        switch (index) {
            case 0: 
            case 1: {
                this.view.setSelectedView(index);
                break;
            }
            case 10: {
                this.view.setRollOver(this.rollOverButton.isSelected());
                break;
            }
            case 11: {
                Registry reg = DataBrowserAgent.getRegistry();
                DatasetData d = new DatasetData();
                EditorDialog dialog = new EditorDialog(reg.getTaskBar().getFrame(), (DataObject)d, false);
                dialog.addPropertyChangeListener(this.controller);
                UIUtilities.centerAndShow(dialog);
                break;
            }
            case 14: {
                this.view.setItemsPerRow(this.getItemsPerRow());
                break;
            }
            case 12: 
            case 13: {
                this.view.slideShowView(true);
                break;
            }
            case 2: 
            case 3: {
                this.view.sortBy(index);
                break;
            }
            case 15: {
                this.report();
                break;
            }
            case 16: {
                this.controller.loadExistingDatasets();
                break;
            }
            case 17: {
                this.codeCompletion = false;
                if (this.search.getTags() == null) {
                    this.firePropertyChange("tagLoading", (Object)false, (Object)true);
                    break;
                }
                this.showTagsWizard(this.search.getTags());
            }
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        String name = evt.getPropertyName();
        if ("selectedItems".equals(name)) {
            Map m = (Map)evt.getNewValue();
            if (m == null || m.size() != 1) {
                return;
            }
            Set set = m.entrySet();
            Iterator i = set.iterator();
            this.codeCompletion = false;
            this.search.setSearchContext(0);
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                Class type = (Class)entry.getKey();
                this.search.setSelectedTags((Collection)entry.getValue());
            }
        } else if ("cancelSelection".equals(name)) {
            this.codeCompletion = false;
            this.search.setFilteringStatus(false);
        }
    }
}

