/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.dataBrowser.view;

import java.awt.Point;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Action;
import org.openmicroscopy.shoola.agents.dataBrowser.DataBrowserAgent;
import org.openmicroscopy.shoola.agents.dataBrowser.actions.CreateExperimentAction;
import org.openmicroscopy.shoola.agents.dataBrowser.actions.FieldsViewAction;
import org.openmicroscopy.shoola.agents.dataBrowser.actions.ManageObjectAction;
import org.openmicroscopy.shoola.agents.dataBrowser.actions.ManageRndSettingsAction;
import org.openmicroscopy.shoola.agents.dataBrowser.actions.RefreshAction;
import org.openmicroscopy.shoola.agents.dataBrowser.actions.SaveAction;
import org.openmicroscopy.shoola.agents.dataBrowser.actions.SendFeedbackAction;
import org.openmicroscopy.shoola.agents.dataBrowser.actions.TaggingAction;
import org.openmicroscopy.shoola.agents.dataBrowser.actions.ViewAction;
import org.openmicroscopy.shoola.agents.dataBrowser.actions.ViewOtherAction;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.CellDisplay;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.ImageDisplay;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.ImageNode;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.RollOverNode;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.Thumbnail;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.WellSampleNode;
import org.openmicroscopy.shoola.agents.dataBrowser.view.DataBrowser;
import org.openmicroscopy.shoola.agents.dataBrowser.view.DataBrowserUI;
import org.openmicroscopy.shoola.agents.events.iviewer.ViewImage;
import org.openmicroscopy.shoola.agents.util.ui.RollOverThumbnailManager;
import org.openmicroscopy.shoola.env.data.model.ApplicationData;
import org.openmicroscopy.shoola.env.data.util.FilterContext;
import org.openmicroscopy.shoola.env.event.EventBus;
import org.openmicroscopy.shoola.util.ui.PlateGridObject;
import org.openmicroscopy.shoola.util.ui.search.SearchObject;
import pojos.DataObject;
import pojos.DatasetData;
import pojos.ImageData;
import pojos.WellSampleData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DataBrowserControl
implements PropertyChangeListener {
    static final Integer VIEW = 0;
    static final Integer COPY_OBJECT = 1;
    static final Integer PASTE_OBJECT = 2;
    static final Integer REMOVE_OBJECT = 3;
    static final Integer CUT_OBJECT = 4;
    static final Integer PASTE_RND_SETTINGS = 5;
    static final Integer COPY_RND_SETTINGS = 6;
    static final Integer RESET_RND_SETTINGS = 7;
    static final Integer SET_MIN_MAX_SETTINGS = 8;
    static final Integer REFRESH = 9;
    static final Integer SAVE_AS = 10;
    static final Integer TAG = 11;
    static final Integer NEW_EXPERIMENT = 12;
    static final Integer FIELDS_VIEW = 13;
    static final Integer OPEN_WITH = 14;
    static final Integer SET_OWNER_RND_SETTINGS = 15;
    static final Integer SEND_FEEDBACK = 16;
    private DataBrowser model;
    private DataBrowserUI view;
    private Map<Integer, Action> actionsMap;

    private void createActions() {
        this.actionsMap.put(VIEW, new ViewAction(this.model));
        this.actionsMap.put(COPY_OBJECT, new ManageObjectAction(this.model, 0));
        this.actionsMap.put(PASTE_OBJECT, new ManageObjectAction(this.model, 1));
        this.actionsMap.put(REMOVE_OBJECT, new ManageObjectAction(this.model, 2));
        this.actionsMap.put(CUT_OBJECT, new ManageObjectAction(this.model, 3));
        this.actionsMap.put(PASTE_RND_SETTINGS, new ManageRndSettingsAction(this.model, 1));
        this.actionsMap.put(COPY_RND_SETTINGS, new ManageRndSettingsAction(this.model, 0));
        this.actionsMap.put(RESET_RND_SETTINGS, new ManageRndSettingsAction(this.model, 2));
        this.actionsMap.put(REFRESH, new RefreshAction(this.model));
        this.actionsMap.put(SET_MIN_MAX_SETTINGS, new ManageRndSettingsAction(this.model, 3));
        this.actionsMap.put(SET_OWNER_RND_SETTINGS, new ManageRndSettingsAction(this.model, 4));
        this.actionsMap.put(SAVE_AS, new SaveAction(this.model));
        this.actionsMap.put(TAG, new TaggingAction(this.model));
        this.actionsMap.put(NEW_EXPERIMENT, new CreateExperimentAction(this.model));
        this.actionsMap.put(FIELDS_VIEW, new FieldsViewAction(this.model));
        this.actionsMap.put(OPEN_WITH, new ViewOtherAction(this.model, null));
        this.actionsMap.put(SEND_FEEDBACK, new SendFeedbackAction(this.model));
    }

    private void filterNodes(SearchObject filter) {
        if (filter == null) {
            return;
        }
        List<String> values = filter.getResult();
        switch (filter.getIndex()) {
            case 2: {
                this.view.setFilterLabel("Name");
                if (values != null && values.size() > 0) {
                    this.model.filterByFullText(values);
                    break;
                }
                this.view.setFilterLabel("");
                this.model.showAll();
                break;
            }
            case 0: {
                this.view.setFilterLabel("Tags");
                if (values != null && values.size() > 0) {
                    this.model.filterByTags(values);
                    break;
                }
                this.showAll();
                break;
            }
            case 1: {
                this.view.setFilterLabel("Comments");
                if (values != null && values.size() > 0) {
                    this.model.filterByComments(values);
                    break;
                }
                this.view.setFilterLabel("");
                this.model.showAll();
                break;
            }
            case 3: {
                this.view.setFilterLabel("Rate");
                this.model.filterByRate(1);
                break;
            }
            case 4: {
                this.view.setFilterLabel("Rate");
                this.model.filterByRate(2);
                break;
            }
            case 5: {
                this.view.setFilterLabel("Rate");
                this.model.filterByRate(3);
                break;
            }
            case 6: {
                this.view.setFilterLabel("Rate");
                this.model.filterByRate(4);
                break;
            }
            case 7: {
                this.view.setFilterLabel("Rate");
                this.model.filterByRate(5);
                break;
            }
            case 8: {
                this.view.setFilterLabel("Unrated");
                this.model.filterByRate(0);
                break;
            }
            case 9: {
                this.view.setFilterLabel("");
                this.model.showAll();
                break;
            }
            case 12: {
                this.view.setFilterLabel("Tagged");
                this.model.filterByTagged(true);
                break;
            }
            case 10: {
                this.view.setFilterLabel("Untagged");
                this.model.filterByTagged(false);
                break;
            }
            case 13: {
                this.view.setFilterLabel("Commented");
                this.model.filterByCommented(true);
                break;
            }
            case 11: {
                this.view.setFilterLabel("Uncommented");
                this.model.filterByCommented(false);
            }
        }
    }

    private void showAll() {
        this.view.setFilterLabel("");
        this.model.showAll();
    }

    DataBrowserControl() {
    }

    void initialize(DataBrowser model, DataBrowserUI view) {
        if (view == null) {
            throw new IllegalArgumentException("No control.");
        }
        if (model == null) {
            throw new IllegalArgumentException("No model.");
        }
        this.model = model;
        this.view = view;
        this.actionsMap = new HashMap<Integer, Action>();
        this.createActions();
    }

    Action getAction(Integer id) {
        return this.actionsMap.get(id);
    }

    void viewField(int field) {
        this.model.viewField(field);
    }

    void createReport(String name) {
        this.model.createReport(name);
    }

    void loadExistingDatasets() {
        this.model.loadExistingDatasets();
    }

    List<ViewOtherAction> getApplicationActions() {
        List<ApplicationData> applications = this.view.getApplications();
        if (applications == null || applications.size() == 0) {
            return null;
        }
        Iterator<ApplicationData> i = applications.iterator();
        ArrayList<ViewOtherAction> actions = new ArrayList<ViewOtherAction>();
        while (i.hasNext()) {
            actions.add(new ViewOtherAction(this.model, i.next()));
        }
        return actions;
    }

    void viewDisplay(ImageDisplay node) {
        if (node instanceof ImageNode) {
            EventBus bus = DataBrowserAgent.getRegistry().getEventBus();
            DataObject data = null;
            Object uo = node.getHierarchyObject();
            if (uo instanceof ImageData) {
                ViewImage event = new ViewImage((DataObject)((ImageData)uo), null);
                Object go = this.view.getParentOfNodes();
                if (go instanceof DataObject) {
                    data = (DataObject)go;
                }
                event.setContext(data, null);
                bus.post(event);
                if (go instanceof DataObject) {
                    data = (DataObject)go;
                }
            } else if (uo instanceof WellSampleData) {
                ViewImage event = new ViewImage((DataObject)((WellSampleData)uo), null);
                WellSampleNode wsn = (WellSampleNode)node;
                Object parent = wsn.getParentObject();
                if (parent instanceof DataObject) {
                    Object go = this.view.getGrandParentOfNodes();
                    if (go instanceof DataObject) {
                        data = (DataObject)go;
                    }
                    event.setContext((DataObject)parent, data);
                }
                bus.post(event);
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String name = evt.getPropertyName();
        if ("selectedDataBrowserNodeDisplay".equals(name)) {
            ImageDisplay node = (ImageDisplay)evt.getNewValue();
            if (node == null) {
                return;
            }
            this.model.setSelectedDisplay(node);
        } else if ("unselectedDataBrowserNodeDisplay".equals(name)) {
            ImageDisplay node = (ImageDisplay)evt.getNewValue();
            if (node == null) {
                return;
            }
            this.model.setUnselectedDisplay(node);
        } else if ("filterData".equals(name)) {
            this.filterNodes((SearchObject)evt.getNewValue());
        } else if ("displayAllNodes".equals(name)) {
            this.showAll();
        } else if ("filter".equals(name) || "filterTags".equals(name)) {
            this.model.filterByContext((FilterContext)evt.getNewValue());
        } else if ("loadTag".equals(name) || "tagLoading".equals(name)) {
            this.model.loadExistingTags();
        } else if ("rollOver".equals(name)) {
            if (this.view.isRollOver()) {
                RollOverNode n = (RollOverNode)evt.getNewValue();
                if (n != null && n.getNode() != null) {
                    ImageNode node = n.getNode();
                    Thumbnail prv = node.getThumbnail();
                    BufferedImage full = prv.getFullScaleThumb();
                    if (prv.getScalingFactor() == 2.5) {
                        full = prv.getZoomedFullScaleThumb();
                    }
                    RollOverThumbnailManager.rollOverDisplay(full, node.getBounds(), n.getLocationOnScreen(), node.toString());
                } else {
                    RollOverThumbnailManager.stopOverDisplay();
                }
            }
        } else if ("closeSlideView".equals(name)) {
            this.view.slideShowView(false);
        } else if ("createNoParent".equals(name) || "create".equals(name)) {
            DataObject object = (DataObject)evt.getNewValue();
            this.model.createDataObject(object);
        } else if ("tableNodesSelection".equals(name)) {
            List selected = (List)evt.getNewValue();
            this.model.setTableNodesSelected(selected);
        } else if ("tableSelectionMenu".equals(name)) {
            Point location = (Point)evt.getNewValue();
            if (location != null) {
                this.view.showPopup(location);
            }
        } else if ("popupPoint".equals(name)) {
            Point p = (Point)evt.getNewValue();
            if (p != null) {
                this.view.showPopup(p);
            }
        } else if ("tableSelectionView".equals(name)) {
            Boolean b = (Boolean)evt.getNewValue();
            if (b.booleanValue()) {
                this.view.viewSelectedNode();
            }
        } else if ("cellSelection".equals(name)) {
            CellDisplay cell = (CellDisplay)evt.getNewValue();
            this.model.setSelectedCell(cell);
        } else if ("selectedItems".equals(name)) {
            Map m = (Map)evt.getNewValue();
            if (m == null || m.size() != 1) {
                return;
            }
            Set set = m.entrySet();
            for (Map.Entry entry : set) {
                Class type = (Class)entry.getKey();
                if (!DatasetData.class.equals((Object)type)) continue;
                this.model.addToDatasets((Collection)entry.getValue());
            }
        } else if ("wellFields".equals(name)) {
            PlateGridObject p = (PlateGridObject)evt.getNewValue();
            if (p == null) {
                return;
            }
            this.model.viewFieldsFor(p.getRow(), p.getColumn(), p.isMultipleSelection());
        } else if ("viewDisplay".equals(name)) {
            this.viewDisplay((ImageDisplay)evt.getNewValue());
        }
    }
}

