/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.dataBrowser.actions;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import org.openmicroscopy.shoola.agents.dataBrowser.IconManager;
import org.openmicroscopy.shoola.agents.dataBrowser.actions.DataBrowserAction;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.Browser;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.ImageDisplay;
import org.openmicroscopy.shoola.agents.dataBrowser.view.DataBrowser;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import pojos.DatasetData;
import pojos.ImageData;
import pojos.PlateData;
import pojos.WellSampleData;

public class ManageRndSettingsAction
extends DataBrowserAction
implements PropertyChangeListener {
    public static final int COPY = 0;
    public static final int PASTE = 1;
    public static final int RESET = 2;
    public static final int SET_MIN_MAX = 3;
    public static final int SET_OWNER = 4;
    private static final String NAME_COPY = "Copy Settings";
    private static final String DESCRIPTION_COPY = "Copy the rendering settings.";
    private static final String NAME_PASTE = "Paste Settings";
    private static final String DESCRIPTION_PASTE = "Paste the rendering settings.";
    private static final String NAME_RESET = "Reset Default Settings";
    private static final String DESCRIPTION_RESET = "Reset the rendering settings created while importing.";
    private static final String NAME_SET_MIN_MAX = "Set Min/Max";
    private static final String DESCRIPTION_SET_MIN_MAX = "Set the Pixels Intensity interval to min/max <br>for all channels.";
    private static final String NAME_SET_OWNER = "Set Owner's Settings";
    private static final String DESCRIPTION_SET_OWNER = "Set the Owner's rendering settings.";
    private IconManager icons;
    private int index;

    private void checkIndex(int value) {
        switch (value) {
            case 0: {
                this.putValue("Name", NAME_COPY);
                this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION_COPY));
                this.putValue("SmallIcon", this.icons.getIcon(27));
                break;
            }
            case 1: {
                this.putValue("Name", NAME_PASTE);
                this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION_PASTE));
                this.putValue("SmallIcon", this.icons.getIcon(28));
                break;
            }
            case 2: {
                this.putValue("Name", NAME_RESET);
                this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION_RESET));
                this.putValue("SmallIcon", this.icons.getIcon(45));
                break;
            }
            case 3: {
                this.putValue("Name", NAME_SET_MIN_MAX);
                this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION_SET_MIN_MAX));
                this.putValue("SmallIcon", this.icons.getIcon(46));
                break;
            }
            case 4: {
                this.putValue("Name", NAME_SET_OWNER);
                this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION_SET_OWNER));
                this.putValue("SmallIcon", this.icons.getIcon(47));
                break;
            }
            default: {
                throw new IllegalArgumentException("Index not supported.");
            }
        }
    }

    protected void onStateChange() {
        Browser browser = this.model.getBrowser();
        if (browser != null) {
            this.onDisplayChange(browser.getLastSelectedDisplay());
        }
    }

    protected void onDisplayChange(ImageDisplay node) {
        Browser browser = this.model.getBrowser();
        if (node == null || browser == null) {
            this.setEnabled(false);
            return;
        }
        Object ho = node.getHierarchyObject();
        Collection selected = browser.getSelectedDataObjects();
        int count = 0;
        switch (this.index) {
            case 0: {
                if (selected.size() > 1) {
                    this.setEnabled(false);
                    break;
                }
                if (ho instanceof WellSampleData || ho instanceof ImageData) {
                    this.setEnabled(true);
                    break;
                }
                this.setEnabled(false);
                break;
            }
            case 1: {
                if (!this.model.hasRndSettings()) {
                    this.setEnabled(false);
                    return;
                }
                if (!(ho instanceof ImageData || ho instanceof DatasetData || ho instanceof PlateData)) {
                    this.setEnabled(false);
                    break;
                }
                if (ho instanceof PlateData || ho instanceof ImageData) {
                    for (Object obj : selected) {
                        if (!this.model.isWritable(obj)) continue;
                        ++count;
                    }
                    this.setEnabled(count == selected.size());
                    break;
                }
                this.setEnabled(true);
                break;
            }
            case 2: 
            case 3: {
                if (!(ho instanceof ImageData || ho instanceof DatasetData || ho instanceof PlateData)) {
                    this.setEnabled(false);
                    break;
                }
                for (Object obj : selected) {
                    if (!this.model.isWritable(obj)) continue;
                    ++count;
                }
                this.setEnabled(count == selected.size());
                break;
            }
            case 4: {
                if (!(ho instanceof ImageData || ho instanceof DatasetData || ho instanceof PlateData)) {
                    this.setEnabled(false);
                    break;
                }
                for (Object obj : selected) {
                    if (!this.model.isWritable(obj) || this.model.isUserOwner(ho)) continue;
                    ++count;
                }
                this.setEnabled(count == selected.size());
            }
        }
    }

    public ManageRndSettingsAction(DataBrowser model, int index) {
        super(model);
        this.setEnabled(false);
        this.icons = IconManager.getInstance();
        this.checkIndex(index);
        this.index = index;
        model.addPropertyChangeListener(this);
    }

    public void actionPerformed(ActionEvent e) {
        switch (this.index) {
            case 0: {
                this.model.copyRndSettings();
                break;
            }
            case 1: {
                this.model.pasteRndSettings();
                break;
            }
            case 2: {
                this.model.resetRndSettings();
                break;
            }
            case 3: {
                this.model.setOriginalSettings();
                break;
            }
            case 4: {
                this.model.setOwnerSettings();
            }
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        Browser browser;
        String name = evt.getPropertyName();
        if (("copyItems".equals(name) || "rndSettingToCopy".equals(name) || "selectedDataBrowserNodeDisplay".equals(name) || "selectionUpdated".equals(name)) && (browser = this.model.getBrowser()) != null) {
            this.onDisplayChange(browser.getLastSelectedDisplay());
        }
    }
}

