/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui.lens;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import org.openmicroscopy.shoola.util.ui.lens.LensModel;
import org.openmicroscopy.shoola.util.ui.lens.ZoomBIPanel;
import org.openmicroscopy.shoola.util.ui.lens.ZoomPanel;

class ZoomWindowUI
extends JScrollPane
implements MouseMotionListener {
    private boolean adjusting;
    private JComponent canvas;
    private JLayeredPane layeredPane;
    private LensModel model;

    private void initComponents() {
        this.layeredPane = new JLayeredPane();
        this.canvas = this.model.hasOpenGLSupport() ? new ZoomPanel(this.model) : new ZoomBIPanel(this.model);
        this.layeredPane.add((Component)this.canvas, (Object)0);
        this.getVerticalScrollBar().addMouseMotionListener(this);
        this.getHorizontalScrollBar().addMouseMotionListener(this);
    }

    private void buildGUI() {
        JViewport viewport = this.getViewport();
        viewport.setLayout(null);
        viewport.setBackground(this.model.getBackgroundColor());
        viewport.add(this.layeredPane);
    }

    private boolean scrollbarsVisible() {
        JScrollBar hBar = this.getHorizontalScrollBar();
        JScrollBar vBar = this.getVerticalScrollBar();
        if (hBar.isVisible()) {
            return true;
        }
        return vBar.isVisible();
    }

    ZoomWindowUI(LensModel model) {
        this.model = model;
        this.initComponents();
        this.buildGUI();
    }

    void setZoomUISize(int w, int h) {
        Dimension d = new Dimension(w, h);
        this.layeredPane.setPreferredSize(d);
        this.layeredPane.setSize(d);
        this.canvas.setSize(d);
        this.canvas.setPreferredSize(d);
    }

    void updateBackgroundColor() {
        this.getViewport().setBackground(this.model.getBackgroundColor());
    }

    public void mouseDragged(MouseEvent e) {
        this.adjusting = true;
    }

    public void setBounds(Rectangle r) {
        this.setBounds(r.x, r.y, r.width, r.height);
    }

    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        if (!this.scrollbarsVisible() && this.adjusting) {
            this.adjusting = false;
        }
        if (this.adjusting) {
            return;
        }
        Rectangle r = this.getViewport().getViewRect();
        Dimension d = this.layeredPane.getPreferredSize();
        int xLoc = (r.width - d.width) / 2;
        int yLoc = (r.height - d.height) / 2;
        this.layeredPane.setBounds(xLoc, yLoc, d.width, d.height);
    }

    public void mouseMoved(MouseEvent e) {
    }
}

