/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui.lens;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLayeredPane;
import javax.swing.JMenuBar;
import org.openmicroscopy.shoola.util.ui.lens.LensComponent;
import org.openmicroscopy.shoola.util.ui.lens.LensMenu;
import org.openmicroscopy.shoola.util.ui.lens.LensModel;
import org.openmicroscopy.shoola.util.ui.lens.StatusPanel;
import org.openmicroscopy.shoola.util.ui.lens.ZoomWindowUI;

class ZoomWindow
extends JDialog
implements ComponentListener {
    static final Dimension DEFAULT_SIZE = new Dimension(300, 300);
    private static final Point DEFAULT_LOC = new Point(900, 200);
    private ZoomWindowUI zoomWindowUI;
    private JMenuBar menu;
    private LensMenu lensMenu;
    private JLayeredPane layeredPane;
    private StatusPanel statusPanel;
    private LensComponent lensComponent;

    private void initComponents() {
        this.setTitle("Zoom Window");
        this.setLocation(DEFAULT_LOC);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                ZoomWindow.this.lensComponent.zoomWindowClosed();
            }
        });
        this.addComponentListener(this);
        this.lensMenu = new LensMenu(this.lensComponent);
        this.statusPanel = new StatusPanel();
    }

    private void buildGUI() {
        Container c = this.getContentPane();
        c.setLayout(new BorderLayout());
        c.add((Component)this.zoomWindowUI, "Center");
        c.add((Component)this.statusPanel, "South");
    }

    ZoomWindow(JFrame parent, LensComponent lensComponent, LensModel model) {
        super(parent);
        if (lensComponent == null) {
            throw new IllegalArgumentException("No parent.");
        }
        this.lensComponent = lensComponent;
        this.zoomWindowUI = new ZoomWindowUI(model);
        this.initComponents();
        this.buildGUI();
    }

    void setDisplayInPixels(boolean b) {
        this.statusPanel.setDisplayInPixels(b);
        this.statusPanel.repaint();
    }

    void setXYPixelMicron(double x, double y) {
        this.statusPanel.setXYPixelMicron(x, y);
        this.statusPanel.repaint();
    }

    void setLensXY(int x, int y) {
        this.statusPanel.setLensXY(x, y);
    }

    void setLensWidthHeight(int w, int h) {
        this.statusPanel.setLensWidthHeight(w, h);
    }

    void setLensZoomFactor(float zoomFactor) {
        this.statusPanel.setLensZoomFactor(zoomFactor);
    }

    void setZoomUISize(float w, float h) {
        this.zoomWindowUI.setZoomUISize((int)w, (int)h);
    }

    ZoomWindowUI getUI() {
        return this.zoomWindowUI;
    }

    void setSelectedSize(int index) {
        this.lensMenu.setSelectedSize(index);
    }

    void setZoomIndex(int index) {
        this.lensMenu.setZoomIndex(index);
    }

    void paintImage() {
        this.zoomWindowUI.repaint();
    }

    void updateBackgroundColor() {
        this.zoomWindowUI.updateBackgroundColor();
    }

    public void componentResized(ComponentEvent e) {
        this.zoomWindowUI.setBounds(this.zoomWindowUI.getBounds());
    }

    public void componentHidden(ComponentEvent e) {
    }

    public void componentMoved(ComponentEvent e) {
    }

    public void componentShown(ComponentEvent e) {
    }

    static /* synthetic */ LensComponent access$000(ZoomWindow x0) {
        return x0.lensComponent;
    }
}

