/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui.drawingtools.figures;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.font.TextLayout;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.BezierFigure;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.TextHolderFigure;
import org.jhotdraw.draw.Tool;
import org.jhotdraw.geom.BezierPath;
import org.jhotdraw.geom.Insets2D;
import org.openmicroscopy.shoola.util.ui.drawingtools.attributes.DrawingAttributes;
import org.openmicroscopy.shoola.util.ui.drawingtools.figures.FigureUtil;
import org.openmicroscopy.shoola.util.ui.drawingtools.texttools.DrawingTextTool;

public class BezierTextFigure
extends BezierFigure
implements TextHolderFigure {
    private boolean editable;
    private transient TextLayout textLayout;
    private Rectangle2D.Double textBounds;

    private TextLayout getTextLayout() {
        if (this.textLayout == null) {
            this.textLayout = FigureUtil.createLayout(this.getText(), this.getFontRenderContext(), this.getFont(), (Boolean)AttributeKeys.FONT_UNDERLINE.get((Figure)this));
        }
        return this.textLayout;
    }

    public BezierTextFigure(String text) {
        this(text, false);
        this.editable = true;
    }

    public BezierTextFigure(String text, boolean closed) {
        super(closed);
        this.setText(text);
        this.textLayout = null;
        this.textBounds = null;
        this.editable = true;
    }

    protected Rectangle2D.Double getTextBounds() {
        if (this.textBounds == null) {
            return new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0);
        }
        return this.textBounds;
    }

    public void setEditable(boolean b) {
        this.editable = b;
    }

    protected void drawFill(Graphics2D g) {
        super.drawFill(g);
        this.drawText(g);
    }

    protected void drawText(Graphics2D g) {
        if (!((Boolean)DrawingAttributes.SHOWTEXT.get((Figure)this)).booleanValue()) {
            return;
        }
        String text = this.getText();
        if (text != null && this.isEditable()) {
            if (text != null) {
                text = text.trim();
            }
            TextLayout layout = this.getTextLayout();
            Rectangle2D.Double r = this.getBounds();
            FontMetrics fm = g.getFontMetrics((Font)AttributeKeys.FONT_FACE.get((Figure)this));
            double textWidth = fm.stringWidth(text);
            double textHeight = fm.getAscent();
            double x = r.x + r.width / 2.0 - textWidth / 2.0;
            double y = r.y + textHeight / 2.0 + r.height / 2.0;
            Font font = (Font)AttributeKeys.FONT_FACE.get((Figure)this);
            Font viewFont = font.deriveFont(((Double)AttributeKeys.FONT_SIZE.get((Figure)this)).intValue());
            g.setFont(viewFont);
            g.setColor((Color)AttributeKeys.TEXT_COLOR.get((Figure)this));
            this.textBounds = new Rectangle2D.Double(x, y, textWidth, textHeight);
            layout.draw(g, (float)this.textBounds.x, (float)this.textBounds.y);
        }
    }

    public void invalidate() {
        super.invalidate();
        this.textLayout = null;
    }

    protected void validate() {
        super.validate();
        this.textLayout = null;
    }

    public Rectangle2D.Double getDrawingArea() {
        Rectangle2D.Double r = super.getDrawingArea();
        r.add(this.getTextBounds());
        return r;
    }

    public Tool getTool(Point2D.Double p) {
        boolean showText = false;
        if (this.isEditable() && this.getBounds().contains(p)) {
            showText = true;
        }
        if (this.path != null && showText) {
            if (!this.isClosed() && this.path.outlineContains(p, 10.0)) {
                showText = false;
            }
            if (this.isClosed() && this.path.outlineContains(p, 3.0)) {
                showText = false;
            }
        }
        if (showText) {
            this.invalidate();
            return new DrawingTextTool(this);
        }
        return null;
    }

    public String getText() {
        return (String)this.getAttribute(AttributeKeys.TEXT);
    }

    public void setText(String newText) {
        this.setAttribute(DrawingAttributes.SHOWTEXT, true);
        this.setAttribute(AttributeKeys.TEXT, newText);
    }

    public int getTextColumns() {
        String t = this.getText();
        int n = 4;
        return t == null ? n : Math.max(t.length(), n);
    }

    public int getTabSize() {
        return 8;
    }

    public TextHolderFigure getLabelFor() {
        return this;
    }

    public Insets2D.Double getInsets() {
        return new Insets2D.Double();
    }

    public Font getFont() {
        return AttributeKeys.getFont((Figure)this);
    }

    public Color getTextColor() {
        return (Color)AttributeKeys.TEXT_COLOR.get((Figure)this);
    }

    public Color getFillColor() {
        return (Color)AttributeKeys.FILL_COLOR.get((Figure)this);
    }

    public float getFontSize() {
        return ((Double)AttributeKeys.FONT_SIZE.get((Figure)this)).floatValue();
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setFontSize(float size) {
        AttributeKeys.FONT_SIZE.set((Figure)this, (Object)new Double(size));
    }

    public boolean isTextOverflow() {
        return false;
    }

    public BezierTextFigure clone() {
        BezierTextFigure that = (BezierTextFigure)super.clone();
        that.setText(this.getText());
        return that;
    }

    public BezierPath.Node removeNode(int node) {
        return super.removeNode(node);
    }
}

