/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.Icon;

public class ColourIcon
implements Icon {
    public static final int DEFAULT_WIDTH = 16;
    public static final int DEFAULT_HEIGHT = 16;
    private static final Color BORDER_COLOR = Color.BLACK;
    private Color colour;
    private int height;
    private int width;
    private boolean paintLineBorder = false;
    private Color borderColor = BORDER_COLOR;

    public ColourIcon() {
        this(16, 16);
    }

    public ColourIcon(Color color) {
        this(16, 16, color);
    }

    public ColourIcon(Dimension d) {
        this(d, null);
    }

    public ColourIcon(int width, int height) {
        this(new Dimension(width, height), null);
    }

    public ColourIcon(int width, int height, Color color) {
        this(new Dimension(width, height), color);
    }

    public ColourIcon(Dimension d, Color color) {
        if (d == null) {
            this.width = 16;
            this.height = 16;
        } else {
            this.width = d.width;
            this.height = d.height;
        }
        if (this.width <= 0) {
            this.width = 16;
        }
        if (this.height <= 0) {
            this.height = 16;
        }
        this.setColour(color);
    }

    public void paintLineBorder(boolean paintLineBorder) {
        this.paintLineBorder = paintLineBorder;
    }

    public void setColour(Color c) {
        this.colour = c;
    }

    public int getIconHeight() {
        return this.height;
    }

    public int getIconWidth() {
        return this.width;
    }

    public void paintIcon(Component c, Graphics g, int x, int y) {
        Graphics2D g2D = (Graphics2D)g;
        if (this.colour != null) {
            g2D.setColor(this.colour);
            g2D.fillRect(4, 4, this.width - 2, this.height - 2);
            g2D.drawRect(4, 4, this.width - 2, this.height - 2);
            if (this.paintLineBorder) {
                g2D.setColor(this.borderColor);
                g2D.drawRect(3, 3, this.width, this.height);
            }
        }
    }
}

