/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.roi.model;

import java.util.TreeMap;
import org.openmicroscopy.shoola.util.roi.exception.NoSuchROIException;
import org.openmicroscopy.shoola.util.roi.exception.ROICreationException;
import org.openmicroscopy.shoola.util.roi.model.ROI;
import org.openmicroscopy.shoola.util.roi.model.ROIShape;
import org.openmicroscopy.shoola.util.roi.model.util.Coord3D;
import org.openmicroscopy.shoola.util.roi.model.util.LongComparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ROIIDMap {
    private TreeMap<Long, ROI> roiMap = new TreeMap(new LongComparator());

    public boolean containsKey(long id) {
        return this.roiMap.containsKey(id);
    }

    public void add(long id, ROI roi) {
        this.roiMap.put(id, roi);
    }

    public TreeMap<Long, ROI> getROIMap() {
        return this.roiMap;
    }

    public ROI getROI(long id) throws NoSuchROIException {
        if (!this.roiMap.containsKey(id)) {
            throw new NoSuchROIException("No ROI with ID : " + id);
        }
        return this.roiMap.get(id);
    }

    public ROIShape getShape(long id, Coord3D coord) throws NoSuchROIException {
        if (!this.roiMap.containsKey(id)) {
            throw new NoSuchROIException("No ROIShape with ROI ID : " + id);
        }
        ROI roi = this.roiMap.get(id);
        if (roi == null) {
            throw new NoSuchROIException("No ROIShape with ROI ID : " + id);
        }
        if (!roi.containsShape(coord)) {
            throw new NoSuchROIException("No ROIShape with ROI ID : " + id + " and Coord : " + coord);
        }
        ROIShape shape = roi.getShape(coord);
        if (shape == null) {
            throw new NoSuchROIException("No ROIShape with ROI ID : " + id + " and Coord : " + coord);
        }
        return shape;
    }

    public void deleteROI(long id) throws NoSuchROIException {
        if (!this.roiMap.containsKey(id)) {
            throw new NoSuchROIException("Cannot delete ROI with id : " + id);
        }
        this.roiMap.remove(id);
    }

    public void addShape(long id, Coord3D coord, ROIShape shape) throws ROICreationException, NoSuchROIException {
        if (!this.roiMap.containsKey(id)) {
            throw new NoSuchROIException("No ROIShape with ROI ID : " + id);
        }
        ROI roi = this.roiMap.get(id);
        if (roi == null) {
            throw new NoSuchROIException("No ROIShape with ROI ID : " + id + " and Coord : " + coord);
        }
        roi.addShape(shape);
    }

    public void deleteShape(long id, Coord3D coord) throws NoSuchROIException {
        if (!this.roiMap.containsKey(id)) {
            throw new NoSuchROIException("No ROI with id : " + id);
        }
        ROI roi = this.roiMap.get(id);
        if (!roi.containsShape(coord)) {
            throw new NoSuchROIException("No ROIShape with ROI ID : " + id + " and Coord : " + coord);
        }
        roi.deleteShape(coord);
        if (roi.getShapes().size() == 0) {
            this.roiMap.remove(id);
        }
    }
}

