/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.roi.io;

import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import net.n3.nanoxml.IXMLElement;
import net.n3.nanoxml.IXMLParser;
import net.n3.nanoxml.IXMLReader;
import net.n3.nanoxml.StdXMLReader;
import net.n3.nanoxml.XMLParserFactory;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.geom.BezierPath;
import org.openmicroscopy.shoola.util.roi.ROIComponent;
import org.openmicroscopy.shoola.util.roi.exception.NoSuchROIException;
import org.openmicroscopy.shoola.util.roi.exception.ParsingException;
import org.openmicroscopy.shoola.util.roi.exception.ROICreationException;
import org.openmicroscopy.shoola.util.roi.figures.MeasureBezierFigure;
import org.openmicroscopy.shoola.util.roi.figures.MeasureEllipseFigure;
import org.openmicroscopy.shoola.util.roi.figures.MeasureLineConnectionFigure;
import org.openmicroscopy.shoola.util.roi.figures.MeasureLineFigure;
import org.openmicroscopy.shoola.util.roi.figures.MeasurePointFigure;
import org.openmicroscopy.shoola.util.roi.figures.MeasureRectangleFigure;
import org.openmicroscopy.shoola.util.roi.figures.MeasureTextFigure;
import org.openmicroscopy.shoola.util.roi.figures.ROIFigure;
import org.openmicroscopy.shoola.util.roi.io.IOConstants;
import org.openmicroscopy.shoola.util.roi.io.attributeparser.SVGAttributeParser;
import org.openmicroscopy.shoola.util.roi.io.attributeparser.SVGFillParser;
import org.openmicroscopy.shoola.util.roi.io.attributeparser.SVGFillRuleParser;
import org.openmicroscopy.shoola.util.roi.io.attributeparser.SVGFontFamilyParser;
import org.openmicroscopy.shoola.util.roi.io.attributeparser.SVGFontSizeParser;
import org.openmicroscopy.shoola.util.roi.io.attributeparser.SVGFontStyleAttribute;
import org.openmicroscopy.shoola.util.roi.io.attributeparser.SVGFontWeightParser;
import org.openmicroscopy.shoola.util.roi.io.attributeparser.SVGMiterLimitParser;
import org.openmicroscopy.shoola.util.roi.io.attributeparser.SVGNullParser;
import org.openmicroscopy.shoola.util.roi.io.attributeparser.SVGStrokeDashArrayParser;
import org.openmicroscopy.shoola.util.roi.io.attributeparser.SVGStrokeDashOffsetParser;
import org.openmicroscopy.shoola.util.roi.io.attributeparser.SVGStrokeLineCapParser;
import org.openmicroscopy.shoola.util.roi.io.attributeparser.SVGStrokeLineJoinParser;
import org.openmicroscopy.shoola.util.roi.io.attributeparser.SVGStrokeOpacityParser;
import org.openmicroscopy.shoola.util.roi.io.attributeparser.SVGStrokeParser;
import org.openmicroscopy.shoola.util.roi.io.attributeparser.SVGStrokeWidthParser;
import org.openmicroscopy.shoola.util.roi.io.attributeparser.SVGTransformParser;
import org.openmicroscopy.shoola.util.roi.io.attributeparser.ShowMeasurementParser;
import org.openmicroscopy.shoola.util.roi.io.attributeparser.ShowTextParser;
import org.openmicroscopy.shoola.util.roi.model.ROI;
import org.openmicroscopy.shoola.util.roi.model.ROIShape;
import org.openmicroscopy.shoola.util.roi.model.annotation.AnnotationKey;
import org.openmicroscopy.shoola.util.roi.model.annotation.AnnotationKeys;
import org.openmicroscopy.shoola.util.roi.model.annotation.MeasurementAttributes;
import org.openmicroscopy.shoola.util.roi.model.util.Coord3D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InputStrategy {
    private static final HashMap<AttributeKey, Object> defaultAttributes = new HashMap();
    private static final HashMap<String, SVGAttributeParser> attributeParserMap;
    private static final HashMap<String, Boolean> basicSVGAttribute;
    private IXMLElement document;
    private List<ROI> roiList;
    private Coord3D currentCoord;
    private long currentROI;
    private ROIComponent component;

    private void setCurrentCoord(Coord3D coord) {
        this.currentCoord = coord;
    }

    private Coord3D getCurrentCoord() {
        return this.currentCoord;
    }

    private void setCurrentROI(long ROIid) {
        this.currentROI = ROIid;
    }

    private long getCurrentROI() {
        return this.currentROI;
    }

    private ROI createROI(IXMLElement roiElement, ROIComponent component) throws NoSuchROIException, ParsingException, ROICreationException {
        if (!roiElement.hasAttribute("id")) {
            return null;
        }
        long id = new Long(roiElement.getAttribute("id", "-1"));
        this.setCurrentROI(id);
        ROI newROI = component.createROI(id);
        ArrayList roiShapeList = roiElement.getChildrenNamed("roishape");
        ArrayList annotationElementList = roiElement.getChildrenNamed("annotation");
        for (IXMLElement annotationTagElement : annotationElementList) {
            ArrayList annotationList = annotationTagElement.getChildren();
            for (IXMLElement annotation : annotationList) {
                this.addAnnotation(annotation, newROI);
            }
        }
        for (IXMLElement roiShape : roiShapeList) {
            ROIShape shape = this.createROIShape(roiShape, newROI);
            shape.getFigure().setMeasurementUnits(component.getMeasurementUnits());
            component.addShape(newROI.getID(), shape.getCoord3D(), shape);
            try {
                ROIShape returnedShape = component.getShape(newROI.getID(), shape.getCoord3D());
            }
            catch (NoSuchROIException e) {
                throw new NoSuchROIException("No shape: ", e);
            }
        }
        return newROI;
    }

    private ROIShape createROIShape(IXMLElement shapeElement, ROI newROI) throws ParsingException {
        int t = new Integer(shapeElement.getAttribute("t", "0"));
        int z = new Integer(shapeElement.getAttribute("z", "0"));
        Coord3D coord = new Coord3D(z, t);
        this.setCurrentCoord(coord);
        IXMLElement figureElement = shapeElement.getFirstChildNamed("svg");
        ROIFigure fig = this.createFigure(figureElement);
        ROIShape shape = new ROIShape(newROI, coord, fig, fig.getBounds());
        ArrayList annotationElementList = shapeElement.getChildrenNamed("annotation");
        for (IXMLElement annotationTagElement : annotationElementList) {
            ArrayList annotationList = annotationTagElement.getChildren();
            for (IXMLElement annotation : annotationList) {
                this.addAnnotation(annotation, shape);
            }
        }
        return shape;
    }

    private boolean isAnnotation(String name) {
        return AnnotationKeys.supportedAnnotations.contains(name);
    }

    private void addAnnotation(IXMLElement annotationElement, ROIShape shape) {
        String key = annotationElement.getName();
        AnnotationKey v = new AnnotationKey(key);
        shape.setAnnotation(v, this.createAnnotationData(annotationElement));
    }

    Object createAnnotationData(IXMLElement annotationElement) {
        String dataType = annotationElement.getAttribute("type", "");
        if (dataType.equals("String")) {
            return annotationElement.getAttribute("value", "");
        }
        if (dataType.equals("Integer")) {
            String value = annotationElement.getAttribute("value", "");
            if (value.equals("")) {
                return 0;
            }
            return Integer.valueOf(value);
        }
        if (dataType.equals("Boolean")) {
            String value = annotationElement.getAttribute("value", "");
            if (value.equals("")) {
                return 0;
            }
            return Boolean.valueOf(value);
        }
        if (dataType.equals("Long")) {
            String value = annotationElement.getAttribute("value", "");
            if (value.equals("")) {
                return 0;
            }
            return Long.valueOf(value);
        }
        if (dataType.equals("Float")) {
            String value = annotationElement.getAttribute("value", "");
            if (value.equals("")) {
                return 0;
            }
            return Float.valueOf(value);
        }
        if (dataType.equals("Double")) {
            String value = annotationElement.getAttribute("value", "");
            if (value.equals("")) {
                return 0;
            }
            return Double.valueOf(value);
        }
        if (dataType.equals("Point2D")) {
            String xValue = annotationElement.getAttribute("x", "");
            String yValue = annotationElement.getAttribute("y", "");
            if (xValue.equals("") || yValue.equals("")) {
                return new Point2D.Double(0.0, 0.0);
            }
            return new Point2D.Double(Double.valueOf(xValue), Double.valueOf(yValue));
        }
        if (dataType.equals("Rectangle2D") || dataType.equals("Ellipse2D")) {
            String xValue = annotationElement.getAttribute("x", "");
            String yValue = annotationElement.getAttribute("y", "");
            String widthValue = annotationElement.getAttribute("width", "");
            String heightValue = annotationElement.getAttribute("height", "");
            if (xValue.equals("") || yValue.equals("") || widthValue.equals("") || heightValue.equals("")) {
                if (dataType.equals("Rectangle2D")) {
                    return new Rectangle2D.Double();
                }
                return new Ellipse2D.Double();
            }
            if (dataType.equals("Rectangle2D")) {
                new Rectangle2D.Double(new Double(xValue), new Double(yValue), new Double(widthValue), new Double(heightValue));
            }
            if (dataType.equals("Ellipse2D")) {
                return new Ellipse2D.Double(new Double(xValue), new Double(yValue), new Double(widthValue), new Double(heightValue));
            }
        } else {
            if (dataType.equals("Coord3D")) {
                String zValue = annotationElement.getAttribute("z", "");
                String tValue = annotationElement.getAttribute("t", "");
                if (zValue.equals("") || tValue.equals("")) {
                    return new Coord3D(0, 0);
                }
                return new Coord3D(new Integer(zValue), new Integer(tValue));
            }
            if (dataType.equals("ArrayList")) {
                ArrayList<Object> list = new ArrayList<Object>();
                ArrayList arrayListElement = annotationElement.getChildren();
                for (IXMLElement dataElement : arrayListElement) {
                    list.add(this.createAnnotationData(dataElement));
                }
                return list;
            }
        }
        return null;
    }

    private void addAnnotation(IXMLElement annotationElement, ROI roi) {
        String key = annotationElement.getName();
        AnnotationKey annotation = new AnnotationKey(key);
        roi.setAnnotation(annotation, this.createAnnotationData(annotationElement));
    }

    private ROIFigure createFigure(IXMLElement svgElement) throws ParsingException {
        IXMLElement parentElement = svgElement.getChildAtIndex(0);
        ROIFigure figure = this.createParentFigure(parentElement);
        if (!parentElement.getName().equals("text")) {
            IXMLElement textElement = svgElement.getChildAtIndex(1);
            this.addTextElementToFigure(figure, textElement);
        }
        this.addMissingAttributes(figure);
        return figure;
    }

    private ROIFigure createParentFigure(IXMLElement figureElement) throws ParsingException {
        ROIFigure figure = null;
        if (figureElement.getName().equals("rect")) {
            figure = this.createRectangleFigure(figureElement);
        }
        if (figureElement.getName().equals("line")) {
            figure = this.createLineFigure(figureElement);
        }
        if (figureElement.getName().equals("ellipse")) {
            figure = this.createEllipseFigure(figureElement);
        }
        if (figureElement.getName().equals("point")) {
            figure = this.createPointFigure(figureElement);
        }
        if (figureElement.getName().equals("text")) {
            figure = this.createTextFigure(figureElement);
        }
        if (figureElement.getName().equals("polyline")) {
            figure = this.createBezierFigure(figureElement, false);
        }
        if (figureElement.getName().equals("polygon")) {
            figure = this.createBezierFigure(figureElement, true);
        }
        return figure;
    }

    public MeasureBezierFigure createBezierFigure(IXMLElement bezierElement, boolean closed) throws ParsingException {
        String pointsValues;
        MeasureBezierFigure fig = new MeasureBezierFigure(closed);
        Point2D.Double[] points = null;
        Point2D.Double[] points1 = null;
        Point2D.Double[] points2 = null;
        Integer[] mask = null;
        if (bezierElement.hasAttribute("points")) {
            pointsValues = bezierElement.getAttribute("points", "");
            points = this.toPoints(pointsValues);
        }
        if (bezierElement.hasAttribute("points-c1")) {
            pointsValues = bezierElement.getAttribute("points-c1", "");
            points1 = this.toPoints(pointsValues);
        }
        if (bezierElement.hasAttribute("points-c2")) {
            pointsValues = bezierElement.getAttribute("points-c2", "");
            points2 = this.toPoints(pointsValues);
        }
        if (bezierElement.hasAttribute("mask")) {
            pointsValues = bezierElement.getAttribute("mask", "");
            mask = this.toIntArray(pointsValues);
        }
        if (points == null || points1 == null || points2 == null || mask == null || points.length != points1.length || points.length != points2.length || points.length != mask.length) {
            throw new ParsingException("Error parsing points attributes in ROI : " + this.currentROI + " ROIShape Coord t : " + this.currentCoord.getTimePoint() + " z : " + this.currentCoord.getZSection());
        }
        for (int i = 0; i < points.length; ++i) {
            BezierPath.Node newNode = new BezierPath.Node(mask[i].intValue(), points[i], points1[i], points2[i]);
            fig.addNode(newNode);
        }
        this.addAttributes(fig, bezierElement);
        return fig;
    }

    private MeasureTextFigure createTextFigure(IXMLElement textElement) {
        String xValue = textElement.getAttribute("x", "");
        String yValue = textElement.getAttribute("y", "");
        MeasureTextFigure textFigure = new MeasureTextFigure(new Double(xValue), new Double(yValue));
        this.addAttributes(textFigure, textElement);
        return textFigure;
    }

    private MeasureEllipseFigure createEllipseFigure(IXMLElement ellipseElement) {
        String cxValue = ellipseElement.getAttribute("cx", "");
        String cyValue = ellipseElement.getAttribute("cy", "");
        String rxValue = ellipseElement.getAttribute("rx", "");
        String ryValue = ellipseElement.getAttribute("ry", "");
        double cx = new Double(cxValue);
        double cy = new Double(cyValue);
        double rx = new Double(rxValue);
        double ry = new Double(ryValue);
        double x = cx - rx;
        double y = cy - ry;
        double width = rx * 2.0;
        double height = ry * 2.0;
        MeasureEllipseFigure ellipseFigure = new MeasureEllipseFigure();
        ellipseFigure.setEllipse(x, y, width, height);
        this.addAttributes(ellipseFigure, ellipseElement);
        return ellipseFigure;
    }

    private MeasurePointFigure createPointFigure(IXMLElement pointElement) {
        String cxValue = pointElement.getAttribute("cx", "");
        String cyValue = pointElement.getAttribute("cy", "");
        String rxValue = pointElement.getAttribute("rx", "");
        String ryValue = pointElement.getAttribute("ry", "");
        double cx = new Double(cxValue);
        double cy = new Double(cyValue);
        double rx = new Double(rxValue);
        double ry = new Double(ryValue);
        double x = cx - rx;
        double y = cy - ry;
        double width = rx * 2.0;
        double height = ry * 2.0;
        MeasurePointFigure pointFigure = new MeasurePointFigure(x, y, width, height);
        this.addAttributes(pointFigure, pointElement);
        return pointFigure;
    }

    private MeasureRectangleFigure createRectangleFigure(IXMLElement rectElement) {
        String xValue = rectElement.getAttribute("x", "");
        String yValue = rectElement.getAttribute("y", "");
        String widthValue = rectElement.getAttribute("width", "");
        String heightValue = rectElement.getAttribute("height", "");
        MeasureRectangleFigure rectFigure = new MeasureRectangleFigure(new Double(xValue), new Double(yValue), new Double(widthValue), new Double(heightValue));
        this.addAttributes(rectFigure, rectElement);
        return rectFigure;
    }

    private ROIFigure createLineFigure(IXMLElement lineElement) throws ParsingException {
        if (lineElement.hasAttribute("to")) {
            return this.createLineConnectionFigure(lineElement);
        }
        return this.createBasicLineFigure(lineElement);
    }

    private MeasureLineConnectionFigure createLineConnectionFigure(IXMLElement lineElement) throws ParsingException {
        MeasureLineConnectionFigure lineFigure = new MeasureLineConnectionFigure();
        long toROIid = new Long(lineElement.getAttribute("to", ""));
        long fromROIid = new Long(lineElement.getAttribute("from", ""));
        try {
            ROI toROI = this.component.getROI(toROIid);
            ROI fromROI = this.component.getROI(fromROIid);
            ROIFigure toFigure = toROI.getFigure(this.getCurrentCoord());
            ROIFigure fromFigure = fromROI.getFigure(this.getCurrentCoord());
            if (lineElement.hasAttribute("points")) {
                lineFigure.removeAllNodes();
                String pointsValues = lineElement.getAttribute("points", "");
                Point2D.Double[] points = this.toPoints(pointsValues);
                for (int i = 0; i < points.length; ++i) {
                    lineFigure.addNode(new BezierPath.Node(points[i].x, points[i].y));
                }
                lineFigure.setStartConnector(toFigure.findCompatibleConnector(lineFigure.getStartConnector(), true));
                lineFigure.setEndConnector(fromFigure.findCompatibleConnector(lineFigure.getEndConnector(), false));
            } else {
                lineFigure.setStartConnector(toFigure.findCompatibleConnector(lineFigure.getStartConnector(), true));
                lineFigure.setEndConnector(fromFigure.findCompatibleConnector(lineFigure.getEndConnector(), false));
            }
        }
        catch (Exception e) {
            throw new ParsingException("In Line connection figure, with ROI :" + this.getCurrentROI() + " on Coord :" + this.getCurrentCoord() + " Connection <to>/<from> tag invalid.");
        }
        this.addAttributes(lineFigure, lineElement);
        return lineFigure;
    }

    private MeasureLineFigure createBasicLineFigure(IXMLElement lineElement) {
        MeasureLineFigure lineFigure = new MeasureLineFigure();
        if (lineElement.hasAttribute("points")) {
            lineFigure.removeAllNodes();
            String pointsValues = lineElement.getAttribute("points", "");
            Point2D.Double[] points = this.toPoints(pointsValues);
            for (int i = 0; i < points.length; ++i) {
                lineFigure.addNode(new BezierPath.Node(points[i].x, points[i].y));
            }
        } else {
            String x1Value = lineElement.getAttribute("x1", "");
            String y1Value = lineElement.getAttribute("y1", "");
            String x2Value = lineElement.getAttribute("x2", "");
            String y2Value = lineElement.getAttribute("y2", "");
            lineFigure.removeAllNodes();
            lineFigure.addNode(new BezierPath.Node(new Double(x1Value).doubleValue(), new Double(y1Value).doubleValue()));
            lineFigure.addNode(new BezierPath.Node(new Double(x2Value).doubleValue(), new Double(y2Value).doubleValue()));
        }
        this.addAttributes(lineFigure, lineElement);
        return lineFigure;
    }

    private Point2D.Double[] toPoints(String str) {
        StringTokenizer tt = new StringTokenizer(str, " ,");
        Point2D.Double[] points = new Point2D.Double[tt.countTokens() / 2];
        for (int i = 0; i < points.length; ++i) {
            points[i] = new Point2D.Double(new Double(tt.nextToken()), new Double(tt.nextToken()));
        }
        return points;
    }

    private Integer[] toIntArray(String str) {
        StringTokenizer tt = new StringTokenizer(str, " ,");
        Integer[] points = new Integer[tt.countTokens()];
        for (int i = 0; i < points.length; ++i) {
            points[i] = new Integer(tt.nextToken());
        }
        return points;
    }

    private void addAttributes(ROIFigure figure, IXMLElement figureElement) {
        Properties attributes = figureElement.getAttributes();
        for (String string : attributes.keySet()) {
            String value = figureElement.getAttribute(string, "");
            this.addAttribute(figure, figureElement, string, value);
        }
    }

    private boolean isBasicSVGAttribute(String attribute) {
        return basicSVGAttribute.containsKey(attribute);
    }

    private boolean isSVGAttribute(String attribute) {
        return attributeParserMap.containsKey(attribute);
    }

    private void parseAttribute(ROIFigure figure, IXMLElement figureElement, String attribute, String value) {
        SVGAttributeParser parser = attributeParserMap.get(attribute);
        parser.parse(figure, figureElement, value);
    }

    private void addAttribute(ROIFigure figure, IXMLElement figureElement, String attribute, String value) {
        if (this.isBasicSVGAttribute(attribute)) {
            return;
        }
        if (this.isSVGAttribute(attribute)) {
            this.parseAttribute(figure, figureElement, attribute, value);
        }
    }

    private void addTextElementToFigure(ROIFigure figure, IXMLElement textElement) {
        String text = textElement.getContent();
        this.setText(figure, text);
        this.addAttributes(figure, textElement);
    }

    private void setText(ROIFigure fig, String text) {
        MeasurementAttributes.TEXT.set((Figure)fig, (Object)text);
    }

    private void addMissingAttributes(ROIFigure figure) {
        Map attributes = figure.getAttributes();
        for (AttributeKey key : defaultAttributes.keySet()) {
            if (attributes.containsKey(key)) continue;
            key.set((Figure)figure, defaultAttributes.get(key));
        }
    }

    InputStrategy() {
    }

    List<ROI> readROI(InputStream in, ROIComponent component) throws ParsingException, ROICreationException, NoSuchROIException {
        IXMLParser parser;
        this.roiList = new ArrayList<ROI>();
        this.component = component;
        try {
            parser = XMLParserFactory.createDefaultXMLParser();
        }
        catch (Exception ex) {
            InternalError e = new InternalError("Unable to instantiate NanoXML Parser");
            e.initCause(ex);
            throw e;
        }
        try {
            StdXMLReader reader = new StdXMLReader(in);
            parser.setReader((IXMLReader)reader);
            this.document = (IXMLElement)parser.parse();
        }
        catch (Exception ex) {
            ParsingException e = new ParsingException(ex.getMessage());
            e.initCause(ex);
            throw e;
        }
        ArrayList roiElements = this.document.getChildrenNamed("roi");
        boolean cnt = false;
        for (IXMLElement roi : roiElements) {
            this.roiList.add(this.createROI(roi, component));
        }
        return this.roiList;
    }

    static {
        defaultAttributes.put(MeasurementAttributes.FILL_COLOR, IOConstants.DEFAULT_FILL_COLOUR);
        defaultAttributes.put(MeasurementAttributes.STROKE_COLOR, IOConstants.DEFAULT_STROKE_COLOUR);
        defaultAttributes.put(MeasurementAttributes.TEXT_COLOR, IOConstants.DEFAULT_TEXT_COLOUR);
        defaultAttributes.put(MeasurementAttributes.FONT_SIZE, new Double(10.0));
        defaultAttributes.put(MeasurementAttributes.FONT_BOLD, false);
        defaultAttributes.put(MeasurementAttributes.STROKE_WIDTH, new Double(1.0));
        defaultAttributes.put(MeasurementAttributes.TEXT, "Text");
        defaultAttributes.put(MeasurementAttributes.MEASUREMENTTEXT_COLOUR, IOConstants.DEFAULT_MEASUREMENT_TEXT_COLOUR);
        defaultAttributes.put(MeasurementAttributes.SHOWMEASUREMENT, false);
        defaultAttributes.put(MeasurementAttributes.SHOWTEXT, false);
        attributeParserMap = new HashMap();
        attributeParserMap.put("ShowBasicTextAnnotation", new ShowTextParser());
        attributeParserMap.put("ShowMeasurement", new ShowMeasurementParser());
        attributeParserMap.put("fill", new SVGFillParser());
        attributeParserMap.put("fill-opacity", new SVGNullParser());
        attributeParserMap.put("fill-rule", new SVGFillRuleParser());
        attributeParserMap.put("stroke", new SVGStrokeParser());
        attributeParserMap.put("stroke-opacity", new SVGStrokeOpacityParser());
        attributeParserMap.put("stroke-width", new SVGStrokeWidthParser());
        attributeParserMap.put("stroke-dashoffset", new SVGStrokeDashOffsetParser());
        attributeParserMap.put("stroke-dasharray", new SVGStrokeDashArrayParser());
        attributeParserMap.put("stroke-linecap", new SVGStrokeLineCapParser());
        attributeParserMap.put("stroke-linejoin", new SVGStrokeLineJoinParser());
        attributeParserMap.put("stroke-miterlimit", new SVGMiterLimitParser());
        attributeParserMap.put("color-interpolation", new SVGNullParser());
        attributeParserMap.put("color-rendering", new SVGNullParser());
        attributeParserMap.put("opacity", new SVGNullParser());
        attributeParserMap.put("marker-end", new SVGNullParser());
        attributeParserMap.put("color-rendering", new SVGNullParser());
        attributeParserMap.put("color-rendering", new SVGNullParser());
        attributeParserMap.put("font-family", new SVGFontFamilyParser());
        attributeParserMap.put("color-rendering", new SVGNullParser());
        attributeParserMap.put("font-size", new SVGFontSizeParser());
        attributeParserMap.put("color-rendering", new SVGNullParser());
        attributeParserMap.put("font-adjust", new SVGNullParser());
        attributeParserMap.put("font-strech", new SVGNullParser());
        attributeParserMap.put("font-style", new SVGFontStyleAttribute());
        attributeParserMap.put("font-variant", new SVGNullParser());
        attributeParserMap.put("font-weight", new SVGFontWeightParser());
        attributeParserMap.put("alignment-baseline", new SVGNullParser());
        attributeParserMap.put("baseline-shift", new SVGNullParser());
        attributeParserMap.put("direction", new SVGNullParser());
        attributeParserMap.put("dominant-baseline", new SVGNullParser());
        attributeParserMap.put("glyph-orientation-horizontal", new SVGNullParser());
        attributeParserMap.put("glyph-orientation-vertical", new SVGNullParser());
        attributeParserMap.put("kerning", new SVGNullParser());
        attributeParserMap.put("letter-spacing", new SVGNullParser());
        attributeParserMap.put("text-anchor", new SVGNullParser());
        attributeParserMap.put("text-decoration", new SVGNullParser());
        attributeParserMap.put("unicode-bidi", new SVGNullParser());
        attributeParserMap.put("word-spacing", new SVGNullParser());
        attributeParserMap.put("rotate", new SVGNullParser());
        attributeParserMap.put("transform", new SVGTransformParser());
        basicSVGAttribute = new HashMap();
        basicSVGAttribute.put("type", true);
        basicSVGAttribute.put("size", true);
        basicSVGAttribute.put("value", true);
        basicSVGAttribute.put("points", true);
        basicSVGAttribute.put("to", true);
        basicSVGAttribute.put("from", true);
        basicSVGAttribute.put("x", true);
        basicSVGAttribute.put("x1", true);
        basicSVGAttribute.put("x2", true);
        basicSVGAttribute.put("y1", true);
        basicSVGAttribute.put("y2", true);
        basicSVGAttribute.put("cx", true);
        basicSVGAttribute.put("cy", true);
        basicSVGAttribute.put("rx", true);
        basicSVGAttribute.put("ry", true);
        basicSVGAttribute.put("z", true);
        basicSVGAttribute.put("c", true);
        basicSVGAttribute.put("t", true);
        basicSVGAttribute.put("width", true);
        basicSVGAttribute.put("height", true);
        basicSVGAttribute.put("r", true);
        basicSVGAttribute.put("b", true);
        basicSVGAttribute.put("g", true);
        basicSVGAttribute.put("a", true);
    }
}

