/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.roi.figures;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.FigureListener;
import org.jhotdraw.geom.BezierPath;
import org.openmicroscopy.shoola.util.roi.figures.ROIFigure;
import org.openmicroscopy.shoola.util.roi.model.ROI;
import org.openmicroscopy.shoola.util.roi.model.ROIShape;
import org.openmicroscopy.shoola.util.roi.model.annotation.AnnotationKeys;
import org.openmicroscopy.shoola.util.roi.model.annotation.MeasurementAttributes;
import org.openmicroscopy.shoola.util.roi.model.util.MeasurementUnits;
import org.openmicroscopy.shoola.util.ui.drawingtools.figures.BezierTextFigure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MeasureBezierFigure
extends BezierTextFigure
implements ROIFigure {
    private boolean readOnly;
    private boolean clientObject;
    private boolean dirty;
    private List<Double> pointArrayX;
    private List<Double> pointArrayY;
    private List<Double> lengthArray;
    private Rectangle2D bounds;
    protected ROI roi;
    protected ROIShape shape;
    private MeasurementUnits units;
    private int status;

    private List<Point> getLinePoints() {
        ArrayList<Point> vector = new ArrayList<Point>();
        for (int i = 0; i < this.getNodeCount() - 1; ++i) {
            Point2D.Double pt1 = this.getPoint(i);
            Point2D.Double pt2 = this.getPoint(i + 1);
            this.iterateLine(new Line2D.Double(pt1, pt2), vector);
        }
        return vector;
    }

    private void iterateLine(Line2D line, List<Point> vector) {
        Point2D start = line.getP1();
        Point2D end = line.getP2();
        Point2D.Double m = new Point2D.Double(end.getX() - start.getX(), end.getY() - start.getY());
        double lengthM = Math.sqrt(((Point2D)m).getX() * ((Point2D)m).getX() + ((Point2D)m).getY() * ((Point2D)m).getY());
        Point2D.Double mNorm = new Point2D.Double(((Point2D)m).getX() / lengthM, ((Point2D)m).getY() / lengthM);
        LinkedHashMap<Point2D.Double, Boolean> map = new LinkedHashMap<Point2D.Double, Boolean>();
        for (double i = 0.0; i < lengthM; i += 0.1) {
            Point2D pt = new Point2D.Double(start.getX() + i * ((Point2D)mNorm).getX(), start.getY() + i * ((Point2D)mNorm).getY());
            Point2D.Double quantisedPoint = new Point2D.Double(Math.floor(pt.getX()), Math.floor(pt.getY()));
            if (map.containsKey(quantisedPoint)) continue;
            map.put(quantisedPoint, Boolean.TRUE);
        }
        for (Point2D pt : map.keySet()) {
            vector.add(new Point((int)pt.getX(), (int)pt.getY()));
        }
    }

    public MeasureBezierFigure() {
        this(false, false, true);
    }

    public MeasureBezierFigure(boolean closed) {
        this(closed, false, true);
    }

    public MeasureBezierFigure(boolean closed, boolean readOnly, boolean clientObject) {
        this("Text", closed, readOnly, clientObject);
    }

    public MeasureBezierFigure(String text) {
        this(text, false, false, true);
    }

    public MeasureBezierFigure(String text, boolean closed) {
        this(text, closed, false, true);
    }

    public MeasureBezierFigure(String text, boolean closed, boolean readOnly, boolean clientObject) {
        super(text, closed);
        this.readOnly = readOnly;
        this.pointArrayX = new ArrayList<Double>();
        this.pointArrayY = new ArrayList<Double>();
        this.lengthArray = new ArrayList<Double>();
        this.status = 0;
        this.setReadOnly(readOnly);
        this.setClientObject(clientObject);
    }

    public void draw(Graphics2D g) {
        super.draw(g);
        if (((Boolean)MeasurementAttributes.SHOWMEASUREMENT.get((Figure)this)).booleanValue() || ((Boolean)MeasurementAttributes.SHOWID.get((Figure)this)).booleanValue()) {
            if (this.isClosed()) {
                DecimalFormat formatter = new DecimalFormat("###.#");
                String polygonArea = formatter.format(this.getArea());
                polygonArea = this.addAreaUnits(polygonArea);
                double sz = (Double)this.getAttribute(MeasurementAttributes.FONT_SIZE);
                g.setFont(new Font("Arial", 0, (int)sz));
                this.bounds = g.getFontMetrics().getStringBounds(polygonArea, g);
                this.bounds = new Rectangle2D.Double(this.getBounds().getCenterX() - this.bounds.getWidth() / 2.0, this.getBounds().getCenterY() + this.bounds.getHeight() / 2.0, this.bounds.getWidth(), this.bounds.getHeight());
                if (((Boolean)MeasurementAttributes.SHOWMEASUREMENT.get((Figure)this)).booleanValue()) {
                    g.setColor((Color)MeasurementAttributes.MEASUREMENTTEXT_COLOUR.get((Figure)this));
                    g.drawString(polygonArea, (int)this.bounds.getX(), (int)this.bounds.getY());
                }
                if (((Boolean)MeasurementAttributes.SHOWID.get((Figure)this)).booleanValue()) {
                    g.setColor(this.getTextColor());
                    g.drawString(this.getROI().getID() + "", (int)this.bounds.getX(), (int)this.bounds.getY());
                }
            } else {
                DecimalFormat formatter = new DecimalFormat("###.#");
                String polygonLength = formatter.format(this.getLength());
                polygonLength = this.addLineUnits(polygonLength);
                double sz = (Double)this.getAttribute(MeasurementAttributes.FONT_SIZE);
                g.setFont(new Font("Arial", 0, (int)sz));
                this.bounds = g.getFontMetrics().getStringBounds(polygonLength, g);
                if (super.getNodeCount() > 1) {
                    int midPoint = this.getNodeCount() / 2 - 1;
                    if (midPoint < 0) {
                        midPoint = 0;
                    }
                    Point2D.Double p0 = this.getPoint(midPoint);
                    Point2D.Double p1 = this.getPoint(midPoint + 1);
                    double x = Math.min(((Point2D)p0).getX(), ((Point2D)p1).getX()) + Math.abs(((Point2D)p0).getX() - ((Point2D)p1).getX());
                    double y = Math.min(((Point2D)p0).getY(), ((Point2D)p1).getY()) + Math.abs(((Point2D)p0).getY() - ((Point2D)p1).getY());
                    this.bounds = new Rectangle2D.Double(x - this.bounds.getWidth() / 2.0, y + this.bounds.getHeight() / 2.0, this.bounds.getWidth(), this.bounds.getHeight());
                    if (((Boolean)MeasurementAttributes.SHOWMEASUREMENT.get((Figure)this)).booleanValue()) {
                        g.setColor((Color)MeasurementAttributes.MEASUREMENTTEXT_COLOUR.get((Figure)this));
                        g.drawString(polygonLength + "", (int)this.path.getCenter().getX(), (int)this.path.getCenter().getY());
                    }
                    if (((Boolean)MeasurementAttributes.SHOWID.get((Figure)this)).booleanValue()) {
                        g.setColor(this.getTextColor());
                        g.drawString(this.getROI().getID() + "", (int)this.path.getCenter().getX(), (int)this.path.getCenter().getY());
                    }
                }
            }
        }
    }

    @Override
    public Rectangle2D.Double getDrawingArea() {
        double diff;
        Rectangle2D.Double newBounds = super.getDrawingArea();
        if (this.bounds == null) {
            return newBounds;
        }
        if (newBounds.getX() > this.bounds.getX()) {
            diff = newBounds.x - this.bounds.getX();
            newBounds.x = this.bounds.getX();
            newBounds.width += diff;
        }
        if (newBounds.getY() > this.bounds.getY()) {
            diff = newBounds.y - this.bounds.getY();
            newBounds.y = this.bounds.getY();
            newBounds.height += diff;
        }
        if (this.bounds.getX() + this.bounds.getWidth() > newBounds.getX() + newBounds.getWidth()) {
            diff = this.bounds.getX() + this.bounds.getWidth() - newBounds.getX() + newBounds.getWidth();
            newBounds.width += diff;
        }
        if (this.bounds.getY() + this.bounds.getHeight() > newBounds.getY() + newBounds.getHeight()) {
            diff = this.bounds.getY() + this.bounds.getHeight() - newBounds.getY() + newBounds.getHeight();
            newBounds.height += diff;
        }
        return newBounds;
    }

    public String addDegrees(String str) {
        return str + "\u00b0";
    }

    public String addLineUnits(String str) {
        if (this.shape == null) {
            return str;
        }
        if (this.units.isInMicrons()) {
            return str + "\u00b5m";
        }
        return str + "px";
    }

    public String addAreaUnits(String str) {
        if (this.shape == null) {
            return str;
        }
        if (this.units.isInMicrons()) {
            return str + "\u00b5m" + "\u00b2";
        }
        return str + "px" + "\u00b2";
    }

    private Point2D.Double getPt(int i) {
        Point2D.Double pt = this.getNode(i).getControlPoint(0);
        if (this.units.isInMicrons()) {
            return new Point2D.Double(pt.getX() * this.units.getMicronsPixelX(), pt.getY() * this.units.getMicronsPixelY());
        }
        return pt;
    }

    public double getLength() {
        double length = 0.0;
        for (int i = 0; i < this.path.size() - 1; ++i) {
            Point2D.Double p0 = ((BezierPath.Node)this.path.get(i)).getControlPoint(0);
            Point2D.Double p1 = ((BezierPath.Node)this.path.get(i + 1)).getControlPoint(0);
            length += p0.distance(p1);
        }
        return length;
    }

    public int getPointCount() {
        return this.getPoints().size();
    }

    public Point2D getCentre() {
        if (this.units.isInMicrons()) {
            Point2D.Double pt1 = this.path.getCenter();
            pt1.setLocation(pt1.getX() * this.units.getMicronsPixelX(), pt1.getY() * this.units.getMicronsPixelY());
            return pt1;
        }
        return this.path.getCenter();
    }

    public double getArea() {
        double area = 0.0;
        Point2D centre = this.getCentre();
        for (int i = 0; i < this.path.size(); ++i) {
            Point2D.Double p0 = this.getPt(i);
            Point2D.Double p1 = i == this.path.size() - 1 ? this.getPt(0) : this.getPt(i + 1);
            ((Point2D)p0).setLocation(((Point2D)p0).getX() - centre.getX(), ((Point2D)p0).getY() - centre.getY());
            ((Point2D)p1).setLocation(((Point2D)p1).getX() - centre.getX(), ((Point2D)p1).getY() - centre.getY());
            area += ((Point2D)p0).getX() * ((Point2D)p1).getY() - ((Point2D)p1).getX() * ((Point2D)p0).getY();
        }
        return Math.abs(area / 2.0);
    }

    public void measureBasicRemoveNode(int index) {
        this.removeNode(index);
    }

    @Override
    public ROI getROI() {
        return this.roi;
    }

    @Override
    public ROIShape getROIShape() {
        return this.shape;
    }

    @Override
    public void setROI(ROI roi) {
        this.roi = roi;
    }

    @Override
    public void setROIShape(ROIShape shape) {
        this.shape = shape;
    }

    @Override
    public void calculateMeasurements() {
        if (this.shape == null) {
            return;
        }
        if (this.getNodeCount() < 2) {
            return;
        }
        this.pointArrayX.clear();
        this.pointArrayY.clear();
        for (int i = 0; i < this.path.size(); ++i) {
            this.pointArrayY.add(((BezierPath.Node)this.path.get(i)).getControlPoint(0).getY());
        }
        AnnotationKeys.POINTARRAYX.set(this.shape, this.pointArrayX);
        AnnotationKeys.POINTARRAYY.set(this.shape, this.pointArrayY);
        if (super.isClosed()) {
            AnnotationKeys.AREA.set(this.shape, (Double)this.getArea());
            AnnotationKeys.PERIMETER.set(this.shape, (Double)this.getLength());
            AnnotationKeys.CENTREX.set(this.shape, (Double)this.getCentre().getX());
            AnnotationKeys.CENTREY.set(this.shape, (Double)this.getCentre().getY());
        } else {
            this.lengthArray.clear();
            this.lengthArray.add(this.getLength());
            AnnotationKeys.LENGTH.set(this.shape, this.lengthArray);
            AnnotationKeys.CENTREX.set(this.shape, (Double)this.getCentre().getX());
            AnnotationKeys.CENTREY.set(this.shape, (Double)this.getCentre().getY());
            AnnotationKeys.STARTPOINTX.set(this.shape, (Double)this.getPt(0).getX());
            AnnotationKeys.STARTPOINTX.set(this.shape, (Double)this.getPt(0).getY());
            AnnotationKeys.ENDPOINTX.set(this.shape, (Double)this.getPt(this.path.size() - 1).getX());
            AnnotationKeys.ENDPOINTY.set(this.shape, (Double)this.getPt(this.path.size() - 1).getY());
        }
    }

    private List<Point> getAreaPoints() {
        Rectangle r = this.path.getBounds();
        double iX = Math.floor(r.getX());
        double iY = Math.floor(r.getY());
        ArrayList<Point> vector = new ArrayList<Point>();
        this.path.toPolygonArray();
        Point2D.Double point = new Point2D.Double(0.0, 0.0);
        int x = 0;
        while ((double)x < Math.ceil(r.getWidth())) {
            int y = 0;
            while ((double)y < Math.ceil(r.getHeight())) {
                ((Point2D)point).setLocation(iX + (double)x, iY + (double)y);
                if (this.path.contains((Point2D)point)) {
                    vector.add(new Point((int)((Point2D)point).getX(), (int)((Point2D)point).getY()));
                }
                ++y;
            }
            ++x;
        }
        return vector;
    }

    @Override
    public String getType() {
        if (this.isClosed()) {
            return "Polygon";
        }
        return "Scribble";
    }

    @Override
    public void setMeasurementUnits(MeasurementUnits units) {
        this.units = units;
    }

    @Override
    public List<Point> getPoints() {
        if (this.isClosed()) {
            return this.getAreaPoints();
        }
        return this.getLinePoints();
    }

    @Override
    public void setStatus(int status) {
        this.status = status;
    }

    @Override
    public int getStatus() {
        return this.status;
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
        this.setEditable(!readOnly);
    }

    public void transform(AffineTransform tx) {
        if (!this.readOnly) {
            super.transform(tx);
            this.setObjectDirty(true);
        }
    }

    public void setBounds(Point2D.Double anchor, Point2D.Double lead) {
        if (!this.readOnly) {
            super.setBounds(anchor, lead);
            this.setObjectDirty(true);
        }
    }

    @Override
    public boolean isClientObject() {
        return this.clientObject;
    }

    @Override
    public void setClientObject(boolean clientSide) {
        this.clientObject = clientSide;
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public void setObjectDirty(boolean dirty) {
        this.dirty = dirty;
    }

    @Override
    public MeasureBezierFigure clone() {
        MeasureBezierFigure that = (MeasureBezierFigure)super.clone();
        that.setReadOnly(this.isReadOnly());
        that.setClientObject(this.isClientObject());
        that.setObjectDirty(true);
        return that;
    }

    public void setClosed(boolean newValue) {
        super.setClosed(newValue);
        this.setObjectDirty(true);
    }

    public void setBezierPath(BezierPath newValue) {
        super.setBezierPath(newValue);
        this.setObjectDirty(true);
    }

    public void setEndPoint(Point2D.Double p) {
        super.setEndPoint(p);
        this.setObjectDirty(true);
    }

    public void setNode(int index, BezierPath.Node p) {
        super.setNode(index, p);
        this.setObjectDirty(true);
    }

    public void setPoint(int index, int coord, Point2D.Double p) {
        super.setPoint(index, coord, p);
        this.setObjectDirty(true);
    }

    public void setStartPoint(Point2D.Double p) {
        super.setStartPoint(p);
        this.setObjectDirty(true);
    }

    public int splitSegment(Point2D.Double split) {
        this.setObjectDirty(true);
        return super.splitSegment(split);
    }

    public int splitSegment(Point2D.Double split, float tolerance) {
        this.setObjectDirty(true);
        return super.splitSegment(split, tolerance);
    }

    public int joinSegments(Point2D.Double join, float tolerance) {
        this.setObjectDirty(true);
        return super.joinSegments(join, tolerance);
    }

    @Override
    public void setText(String text) {
        super.setText(text);
        this.setObjectDirty(true);
    }

    @Override
    public List<FigureListener> getFigureListeners() {
        Object[] listeners;
        ArrayList<FigureListener> figListeners = new ArrayList<FigureListener>();
        for (Object listener : listeners = this.listenerList.getListenerList()) {
            if (!(listener instanceof FigureListener)) continue;
            figListeners.add((FigureListener)listener);
        }
        return figListeners;
    }

    @Override
    public BezierPath.Node removeNode(int node) {
        return super.removeNode(node);
    }
}

