/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.math.geom2D;

import java.awt.geom.Point2D;
import org.openmicroscopy.shoola.util.math.geom2D.PlanePoint;

public class PlanePoint2D
extends Point2D {
    public double x1;
    public double x2;

    public PlanePoint2D(double x1, double x2) {
        this.x1 = x1;
        this.x2 = x2;
    }

    public double distance(PlanePoint2D p) {
        PlanePoint2D tp = this.vec(p);
        return tp.norm();
    }

    public PlanePoint2D sum(PlanePoint2D vec) {
        if (vec == null) {
            throw new NullPointerException("No vector.");
        }
        return new PlanePoint2D(this.x1 + vec.x1, this.x2 + vec.x2);
    }

    public PlanePoint2D diff(PlanePoint2D vec) {
        if (vec == null) {
            throw new NullPointerException("No vector.");
        }
        return new PlanePoint2D(this.x1 - vec.x1, this.x2 - vec.x2);
    }

    public PlanePoint2D scalar(double k) {
        return new PlanePoint2D(k * this.x1, k * this.x2);
    }

    public PlanePoint2D vec(PlanePoint2D p) {
        if (p == null) {
            throw new NullPointerException("No point.");
        }
        return new PlanePoint2D(p.x1 - this.x1, p.x2 - this.x2);
    }

    public double dot(PlanePoint2D vec) {
        if (vec == null) {
            throw new NullPointerException("No vector.");
        }
        return this.x1 * vec.x1 + this.x2 * vec.x2;
    }

    public double norm() {
        return Math.sqrt(this.dot(this));
    }

    public PlanePoint2D normalize() {
        double n = this.norm();
        if (n == 0.0) {
            return this;
        }
        return new PlanePoint2D(this.x1 / n, this.x2 / n);
    }

    public double angle(PlanePoint2D vec) {
        if (vec == null) {
            throw new NullPointerException("No vector.");
        }
        double thisNorm = this.norm();
        double vecNorm = vec.norm();
        double dotPrd = this.dot(vec);
        if (thisNorm == 0.0 || vecNorm == 0.0) {
            throw new IllegalArgumentException("The angle is not defined for a null vector.");
        }
        return Math.acos(dotPrd / (thisNorm * vecNorm));
    }

    public boolean equals(Object o) {
        boolean isEqual = false;
        if (o != null && o instanceof PlanePoint) {
            PlanePoint other = (PlanePoint)o;
            isEqual = this.x1 == other.x1 && this.x2 == other.x2;
        }
        return isEqual;
    }

    public double getX() {
        return this.x1;
    }

    public double getY() {
        return this.x2;
    }

    public void setLocation(double x1, double x2) {
        this.x1 = x1;
        this.x2 = x2;
    }
}

