/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.image.io;

import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;
import org.openmicroscopy.shoola.util.image.io.Encoder;
import org.openmicroscopy.shoola.util.image.io.EncoderException;

public class WriterImage {
    public static final int JPEG = 0;
    public static final int PNG = 1;
    public static final int GIF = 2;

    public static void saveImage(File f, BufferedImage img, String format) throws EncoderException {
        if (f == null) {
            throw new IllegalArgumentException("No file specified.");
        }
        if (img == null) {
            throw new IllegalArgumentException("No image specified.");
        }
        try {
            Iterator<ImageWriter> writers = ImageIO.getImageWritersByFormatName(format);
            ImageWriter writer = writers.next();
            ImageOutputStream ios = ImageIO.createImageOutputStream(f);
            writer.setOutput(ios);
            writer.write(img);
            ios.close();
        }
        catch (Exception e) {
            throw new EncoderException("Cannot encode the image.", e);
        }
    }

    public static void saveImage(Encoder encoder) throws EncoderException {
        if (encoder == null) {
            throw new IllegalArgumentException("No encoder specified.");
        }
        try {
            encoder.write();
            encoder.getOutput().close();
        }
        catch (Exception e) {
            throw new EncoderException("Cannot encode the image.", e);
        }
    }

    public static byte[] imageToByteStream(BufferedImage image) throws EncoderException {
        return WriterImage.imageToByteStream(image, 0);
    }

    public static byte[] imageToByteStream(BufferedImage image, int type) throws EncoderException {
        if (image == null) {
            throw new IllegalArgumentException("No image specified.");
        }
        try {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            switch (type) {
                case 1: {
                    ImageIO.write((RenderedImage)image, "png", stream);
                    break;
                }
                case 2: {
                    ImageIO.write((RenderedImage)image, "gif", stream);
                    break;
                }
                default: {
                    ImageIO.write((RenderedImage)image, "jpeg", stream);
                }
            }
            stream.close();
            return stream.toByteArray();
        }
        catch (Throwable e) {
            throw new EncoderException("Cannot encode the image.", e);
        }
    }

    public static BufferedImage bytesToImage(byte[] values) throws EncoderException {
        if (values == null) {
            throw new IllegalArgumentException("No array specified.");
        }
        try {
            ByteArrayInputStream stream = new ByteArrayInputStream(values);
            return ImageIO.read(stream);
        }
        catch (Exception e) {
            throw new EncoderException("Cannot create buffered image", e);
        }
    }

    public static int[] bytesToDataBuffer(byte[] values) throws EncoderException {
        if (values == null) {
            throw new IllegalArgumentException("No array specified.");
        }
        try {
            BufferedImage img = WriterImage.bytesToImage(values);
            if (img == null) {
                return null;
            }
            DataBufferInt buf = (DataBufferInt)img.getData().getDataBuffer();
            return buf.getData();
        }
        catch (Exception e) {
            throw new EncoderException("Cannot decode the image.", e);
        }
    }
}

