/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.file;

import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.table.TableModel;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFClientAnchor;
import org.apache.poi.hssf.usermodel.HSSFDataFormat;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFHyperlink;
import org.apache.poi.hssf.usermodel.HSSFPatriarch;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Hyperlink;
import org.apache.poi.ss.usermodel.RichTextString;
import org.openmicroscopy.shoola.util.file.SheetInfo;
import org.openmicroscopy.shoola.util.image.io.EncoderException;
import org.openmicroscopy.shoola.util.image.io.WriterImage;

public class ExcelWriter {
    public static final String HYPERLINK = "hyperlink";
    public static final String DEFAULT = "default";
    public static final String ITALIC_DEFAULT = "italic_default";
    public static final String BOLD_DEFAULT = "bold_default";
    public static final String UNDERLINE_DEFAULT = "underline_default";
    public static final String BOLD_UNDERLINE_DEFAULT = "bold_underline_default";
    public static final String BOLD_ITALIC_DEFAULT = "bold_italic_default";
    public static final String BOLD_ITALIC_UNDERLINE_DEFAULT = "bold_italic_underline_default";
    public static final String ITALIC_UNDERLINE_DEFAULT = "italic_underline_default";
    public static final String PLAIN_12 = "plain_12";
    public static final String PLAIN_14 = "plain_14";
    public static final String BOLD_14 = "bold_14";
    public static final String PLAIN_18 = "plain_18";
    public static final String BOLD_18 = "bold_18";
    public static final String TWODECIMALPOINTS = "2 decimal points";
    public static final String INTEGER = "integer";
    public static final String CELLBORDER_UNDERLINE = "cellborder_underline";
    public static final String CELLBORDER_TOPLINE = "cellborder_topline";
    public static final String CELLBORDER_UNDERLINE_TOPLINE = "cellborder_underline_topline";
    private static final String DEFAULT_NAME = "Sheet";
    private String filename;
    private FileOutputStream out;
    private HSSFWorkbook workbook;
    private Map<String, HSSFCellStyle> styleMap;
    private Map<String, HSSFFont> fontMap;
    private Map<String, SheetInfo> sheetMap;
    private Map<String, Integer> imageMap;
    private int numSheets;
    private SheetInfo currentSheet;

    private void setStyles() {
        this.styleMap = new HashMap<String, HSSFCellStyle>();
        this.fontMap = new HashMap<String, HSSFFont>();
        this.createFonts();
        this.createStyles();
    }

    private void createStyles() {
        HSSFCellStyle style;
        for (String fontName : this.fontMap.keySet()) {
            style = this.workbook.createCellStyle();
            style.setFont(this.fontMap.get(fontName));
            this.styleMap.put(fontName, style);
        }
        style = this.workbook.createCellStyle();
        style.setFont(this.fontMap.get(DEFAULT));
        HSSFDataFormat df = this.workbook.createDataFormat();
        style.setDataFormat(df.getFormat("#.##"));
        this.styleMap.put(TWODECIMALPOINTS, style);
        style = this.workbook.createCellStyle();
        style.setFont(this.fontMap.get(DEFAULT));
        df = this.workbook.createDataFormat();
        style.setDataFormat(df.getFormat("0"));
        this.styleMap.put(INTEGER, style);
        style = this.workbook.createCellStyle();
        style.setFont(this.fontMap.get(DEFAULT));
        style.setBorderBottom((short)1);
        style.setBottomBorderColor((short)8);
        this.styleMap.put(CELLBORDER_UNDERLINE, style);
        style = this.workbook.createCellStyle();
        style.setFont(this.fontMap.get(DEFAULT));
        style.setBorderTop((short)1);
        style.setTopBorderColor((short)8);
        this.styleMap.put(CELLBORDER_TOPLINE, style);
        style = this.workbook.createCellStyle();
        style.setFont(this.fontMap.get(DEFAULT));
        style.setBorderTop((short)1);
        style.setTopBorderColor((short)8);
        style.setBorderBottom((short)1);
        style.setBottomBorderColor((short)8);
        this.styleMap.put(CELLBORDER_UNDERLINE_TOPLINE, style);
    }

    private void createFonts() {
        HSSFFont font = this.workbook.createFont();
        font.setUnderline((byte)1);
        font.setColor((short)12);
        this.fontMap.put(HYPERLINK, font);
        font = this.workbook.createFont();
        this.fontMap.put(DEFAULT, font);
        font = this.workbook.createFont();
        font.setBoldweight((short)700);
        this.fontMap.put(BOLD_DEFAULT, font);
        font = this.workbook.createFont();
        font.setUnderline((byte)1);
        this.fontMap.put(UNDERLINE_DEFAULT, font);
        font = this.workbook.createFont();
        font.setItalic(true);
        this.fontMap.put(ITALIC_DEFAULT, font);
        font = this.workbook.createFont();
        font.setItalic(true);
        font.setUnderline((byte)1);
        this.fontMap.put(ITALIC_UNDERLINE_DEFAULT, font);
        font = this.workbook.createFont();
        font.setItalic(true);
        font.setBoldweight((short)700);
        this.fontMap.put(BOLD_ITALIC_DEFAULT, font);
        font = this.workbook.createFont();
        font.setItalic(true);
        font.setBoldweight((short)700);
        font.setUnderline((byte)1);
        this.fontMap.put(BOLD_ITALIC_UNDERLINE_DEFAULT, font);
        font = this.workbook.createFont();
        font.setBoldweight((short)700);
        font.setUnderline((byte)1);
        this.fontMap.put(BOLD_UNDERLINE_DEFAULT, font);
        font = this.workbook.createFont();
        font.setFontHeightInPoints((short)12);
        this.fontMap.put(PLAIN_12, font);
        font = this.workbook.createFont();
        font.setFontHeightInPoints((short)14);
        this.fontMap.put(PLAIN_14, font);
        font = this.workbook.createFont();
        font.setFontHeightInPoints((short)14);
        font.setBoldweight((short)700);
        this.fontMap.put(BOLD_14, font);
        font = this.workbook.createFont();
        font.setFontHeightInPoints((short)18);
        this.fontMap.put(PLAIN_18, font);
        font = this.workbook.createFont();
        font.setFontHeightInPoints((short)18);
        font.setBoldweight((short)700);
        this.fontMap.put(BOLD_18, font);
    }

    private HSSFCellStyle getCellStyle(String style) {
        if (!this.styleMap.containsKey(style)) {
            throw new IllegalArgumentException("No such style");
        }
        return this.styleMap.get(style);
    }

    private void setCellStyle(HSSFCell cell, String style) {
        HSSFCellStyle cellStyle = this.getCellStyle(style);
        cell.setCellStyle(cellStyle);
    }

    public void sizeColumnToFit(int columnIndex) {
        this.currentSheet.sizeColumnToFit(columnIndex);
    }

    public void sizeAllColumnsToFit() {
        this.currentSheet.sizeAllColumnsToFit();
    }

    public void setRowHeight(int rowStart, int rowEnd, int rowHeight) {
        this.currentSheet.setRowHeight(rowStart, rowEnd, rowHeight);
    }

    public void setRowHeight(int rowIndex, int rowHeight) {
        this.currentSheet.setRowHeight(rowIndex, rowHeight);
    }

    public Dimension getImageSize(int width, int height) {
        Dimension d = new Dimension();
        int widthInCells = width / 68;
        int heightInCells = height / 18;
        d.setSize(widthInCells, heightInCells);
        return d;
    }

    private void writeHeader(int startColumn, TableModel tableModel) {
        for (short cellnum = (short)startColumn; cellnum < tableModel.getColumnCount(); cellnum = (short)(cellnum + 1)) {
            HSSFCell cell = this.currentSheet.getCell(this.currentSheet.getCurrentRow(), cellnum);
            cell.setCellValue((RichTextString)new HSSFRichTextString(tableModel.getColumnName(cellnum)));
        }
        this.currentSheet.setCurrentRow(this.currentSheet.getCurrentRow() + 1);
    }

    private void writeTableContents(int startColumn, TableModel tableModel) {
        for (int rowCount = 0; rowCount < tableModel.getRowCount(); ++rowCount) {
            this.writeRow(startColumn, rowCount, tableModel);
        }
    }

    private Object getElement(Object element, int row) {
        if (element instanceof List) {
            List elementList = (List)element;
            if (row < elementList.size()) {
                return elementList.get(row);
            }
        } else if (row == 0) {
            return element;
        }
        return "";
    }

    private boolean isNumber(Object element) {
        return element instanceof Double || element instanceof Integer || element instanceof Float || element instanceof Long;
    }

    private void writeRow(int startColumn, int rowCount, TableModel tableModel) {
        Object element;
        int maxRows = 1;
        for (int columnCount = 0; columnCount < tableModel.getColumnCount(); ++columnCount) {
            element = tableModel.getValueAt(rowCount, columnCount);
            if (!(element instanceof List)) continue;
            List elementList = (List)element;
            maxRows = Math.max(maxRows, elementList.size());
        }
        for (int elementRowCount = 0; elementRowCount < maxRows; ++elementRowCount) {
            for (int columnCount = 0; columnCount < tableModel.getColumnCount(); ++columnCount) {
                HSSFCell cell = this.currentSheet.getCell(this.currentSheet.getCurrentRow() + elementRowCount, startColumn + columnCount);
                element = this.getElement(tableModel.getValueAt(rowCount, columnCount), elementRowCount);
                this.setCellStyle(cell, TWODECIMALPOINTS);
                if (element == null) continue;
                this.writeElement(this.currentSheet.getCurrentRow() + elementRowCount, startColumn + columnCount, element);
            }
        }
        this.currentSheet.setCurrentRow(this.currentSheet.getCurrentRow() + maxRows);
    }

    private void createWorkbook() {
        this.workbook = new HSSFWorkbook();
        this.setStyles();
    }

    public ExcelWriter(String filename) {
        if (filename == null) {
            throw new IllegalArgumentException("No name.");
        }
        this.filename = filename;
        this.sheetMap = new HashMap<String, SheetInfo>();
        this.imageMap = new HashMap<String, Integer>();
        this.numSheets = 0;
        this.currentSheet = null;
    }

    public void openFile() throws FileNotFoundException {
        this.out = new FileOutputStream(this.filename);
        this.createWorkbook();
    }

    public void close() throws IOException {
        if (this.out == null || this.workbook == null) {
            return;
        }
        this.workbook.write((OutputStream)this.out);
        this.out.close();
    }

    public void createSheet(String name) {
        if (name == null || name.trim().length() == 0) {
            name = DEFAULT_NAME + this.numSheets;
        }
        HSSFSheet sheet = this.workbook.createSheet();
        this.currentSheet = new SheetInfo(name, this.numSheets, sheet);
        this.sheetMap.put(name, this.currentSheet);
        this.workbook.setSheetName(this.numSheets, name);
        ++this.numSheets;
    }

    public SheetInfo setCurrentSheet(String sheetname) {
        if (this.sheetMap.containsKey(sheetname)) {
            this.currentSheet = this.sheetMap.get(sheetname);
            return this.currentSheet;
        }
        return null;
    }

    public SheetInfo setCurrentSheet(int sheetIndex) {
        for (SheetInfo sheetInfo : this.sheetMap.values()) {
            if (sheetInfo.getIndex() != sheetIndex) continue;
            this.currentSheet = sheetInfo;
            return sheetInfo;
        }
        return null;
    }

    public int addImageToWorkbook(String imageName, BufferedImage image) throws EncoderException {
        byte[] array = WriterImage.imageToByteStream(image);
        if (array == null) {
            return -1;
        }
        int index = this.workbook.addPicture(array, 5);
        this.imageMap.put(imageName, index);
        return index;
    }

    public void writeImage(int rowStartIndex, int colStartIndex, int width, int height, String imageName) {
        HSSFPatriarch patriarch = this.currentSheet.getDrawingPatriarch();
        double remainderWidth = (double)(width % 68) / 68.0;
        int widthInCells = width / 68;
        double remainderHeight = (double)(height % 18) / 18.0;
        int heightInCells = height / 18;
        HSSFClientAnchor anchor = new HSSFClientAnchor(0, 0, (int)(remainderWidth * 1023.0), (int)(remainderHeight * 255.0), (short)colStartIndex, (int)((short)rowStartIndex), (short)(colStartIndex + widthInCells), (int)((short)(rowStartIndex + heightInCells)));
        anchor.setAnchorType(3);
        int index = this.imageMap.get(imageName);
        patriarch.createPicture(anchor, index);
    }

    private HSSFCell getCell(int row, int column) {
        if (this.currentSheet == null) {
            return null;
        }
        return this.currentSheet.getCell(row, column);
    }

    public int getMaxColumn(int row) {
        if (this.currentSheet == null) {
            return 0;
        }
        return this.currentSheet.getMaxColumn(row);
    }

    public void changeSheetName(String oldName, String newName) {
        if (oldName == null || newName == null) {
            return;
        }
        SheetInfo sheetInfo = this.setCurrentSheet(oldName);
        int index = sheetInfo.getIndex();
        this.workbook.setSheetName(index, newName);
        sheetInfo.setName(newName);
    }

    public int writeTableToSheet(int rowIndex, int columnIndex, TableModel tableModel) {
        if (rowIndex < 0 || columnIndex < 0) {
            throw new IllegalArgumentException("Index not valid.");
        }
        if (tableModel == null) {
            throw new IllegalArgumentException("No table to write.");
        }
        int startColumn = columnIndex;
        this.currentSheet.setCurrentRow(rowIndex);
        this.writeHeader(startColumn, tableModel);
        this.writeTableContents(startColumn, tableModel);
        return this.currentSheet.getCurrentRow();
    }

    public int writeMapToSheet(int rowIndex, int columnIndex, Map map) {
        if (rowIndex < 0 || columnIndex < 0) {
            throw new IllegalArgumentException("Index not valid.");
        }
        if (map == null) {
            throw new IllegalArgumentException("No map to write.");
        }
        for (Map.Entry entry : map.entrySet()) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            if (key != null) {
                this.writeElement(rowIndex, columnIndex, key);
            }
            if (value != null) {
                this.writeElement(rowIndex, columnIndex + 1, value);
            }
            ++rowIndex;
        }
        this.currentSheet.setCurrentRow(rowIndex);
        return rowIndex;
    }

    public int writeElement(int rowIndex, int columnIndex, Object value) {
        if (rowIndex < 0 || columnIndex < 0) {
            throw new IllegalArgumentException("Index not valid.");
        }
        if (value == null) {
            throw new IllegalArgumentException("No object to write.");
        }
        HSSFCell cell = this.currentSheet.getCell(rowIndex, columnIndex);
        if (this.isNumber(value)) {
            if (value instanceof Integer) {
                cell.setCellValue((double)((Integer)value).intValue());
            } else if (value instanceof Double) {
                cell.setCellValue(((Double)value).doubleValue());
            } else if (value instanceof Float) {
                cell.setCellValue((double)((Float)value).floatValue());
            } else if (value instanceof Long) {
                cell.setCellValue((double)((Long)value).longValue());
            }
        } else if (value instanceof Boolean) {
            cell.setCellValue(((Boolean)value).booleanValue());
        } else {
            cell.setCellValue((RichTextString)new HSSFRichTextString(value.toString()));
        }
        this.currentSheet.setCurrentRow(rowIndex);
        return this.currentSheet.getCurrentRow();
    }

    public int writeArrayToRow(int rowIndex, int columnIndex, Object[] values) {
        if (rowIndex < 0 || columnIndex < 0) {
            throw new IllegalArgumentException("Index not valid.");
        }
        if (values == null) {
            throw new IllegalArgumentException("No object to write.");
        }
        this.currentSheet.setCurrentRow(rowIndex + 1);
        for (int i = 0; i < values.length; ++i) {
            this.writeElement(rowIndex, columnIndex + i, values[i]);
        }
        return this.currentSheet.getCurrentRow();
    }

    public int writeArrayToColumn(int rowIndex, int columnIndex, Object[] values) {
        if (rowIndex < 0 || columnIndex < 0) {
            throw new IllegalArgumentException("Index not valid.");
        }
        if (values == null) {
            throw new IllegalArgumentException("No object to write.");
        }
        for (int i = 0; i < values.length; ++i) {
            this.writeElement(rowIndex + i, columnIndex, values[i]);
        }
        this.currentSheet.setCurrentRow(rowIndex + values.length);
        return this.currentSheet.getCurrentRow();
    }

    public void setCellStyle(int startRow, int startCol, int endRow, int endCol, String style) {
        HSSFCellStyle cellStyle = this.getCellStyle(style);
        for (int y = startRow; y <= endRow; ++y) {
            for (int x = startCol; x <= endCol; ++x) {
                HSSFCell cell = this.getCell(y, x);
                cell.setCellStyle(cellStyle);
            }
        }
    }

    public void addHyperlink(int row, int col, String description, String URL2) {
        HSSFCell cell = this.getCell(row, col);
        cell.setCellValue((RichTextString)new HSSFRichTextString(description));
        HSSFHyperlink link = new HSSFHyperlink(1);
        link.setAddress(URL2);
        cell.setHyperlink((Hyperlink)link);
    }

    public void addFont(String fontName, HSSFFont font) {
        this.fontMap.put(fontName, font);
    }

    public void addStyle(String styleName, HSSFCellStyle style) {
        this.styleMap.put(styleName, style);
    }

    public String[] getCellStyles() {
        Set<String> keys = this.styleMap.keySet();
        String[] array = new String[keys.size()];
        Iterator<String> i = keys.iterator();
        int index = 0;
        while (i.hasNext()) {
            array[index] = i.next();
            ++index;
        }
        return array;
    }

    public String[] getFonts() {
        Set<String> keys = this.fontMap.keySet();
        String[] array = new String[keys.size()];
        Iterator<String> i = keys.iterator();
        int index = 0;
        while (i.hasNext()) {
            array[index] = i.next();
            ++index;
        }
        return array;
    }

    public void setCellStyle(int row, int col, String style) {
        HSSFCell cell = this.getCell(row, col);
        this.setCellStyle(cell, style);
    }
}

