/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.concur;

import org.openmicroscopy.shoola.util.concur.AsyncByteBuffer;
import org.openmicroscopy.shoola.util.concur.BufferWriteException;
import org.openmicroscopy.shoola.util.concur.ByteBufferFiller;
import org.openmicroscopy.shoola.util.concur.ControlFlowObserver;
import org.openmicroscopy.shoola.util.concur.tasks.ExecMonitor;
import org.openmicroscopy.shoola.util.concur.tasks.MultiStepTask;

class ProducerLoop
implements MultiStepTask,
ExecMonitor {
    static final int FILLING = 0;
    static final int DONE = 1;
    static final int DATA_DISCARDED = 2;
    private final ByteBufferFiller producer;
    private final AsyncByteBuffer buffer;
    private final int PAYLOAD;
    private int bytesWritten;
    private BufferWriteException discardCause;
    private int state;
    private boolean done;
    static final int LOCK_ACQUIRED = 100;
    private ControlFlowObserver flowObs;

    ProducerLoop(AsyncByteBuffer buffer, ByteBufferFiller producer) {
        if (buffer == null) {
            throw new NullPointerException("No buffer.");
        }
        if (producer == null) {
            throw new NullPointerException("No producer.");
        }
        this.buffer = buffer;
        this.producer = producer;
        this.PAYLOAD = producer.getTotalLength();
        if (this.PAYLOAD < 1) {
            throw new IllegalArgumentException("producer.getTotalLength() didn't return a positive value: " + this.PAYLOAD + ".");
        }
        this.bytesWritten = 0;
        this.discardCause = null;
        this.done = false;
        this.state = 0;
    }

    private synchronized void updateBytesWritten(int writeLength) {
        if (this.flowObs != null) {
            this.flowObs.update(100);
        }
        this.bytesWritten += writeLength;
        this.notifyAll();
    }

    private void checkInterval(int offset, int length) {
        if (offset < 0 || length < 0 || this.PAYLOAD < offset + length) {
            throw new IllegalArgumentException("Illegal data segment: [offset=" + offset + ", offset+length=" + (offset + length) + "] not in [0, PAYLOAD=" + this.PAYLOAD + "].");
        }
    }

    private boolean isAvailable(int offset, int length, long timeout) throws BufferWriteException, InterruptedException {
        boolean available = offset + length <= this.bytesWritten;
        switch (this.state) {
            case 2: {
                throw this.discardCause;
            }
            case 1: {
                return available;
            }
            case 0: {
                if (available) {
                    return true;
                }
                if (0L > timeout) break;
                this.wait(timeout);
            }
        }
        return offset + length <= this.bytesWritten;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean waitForData(int offset, int length, long timeout) throws BufferWriteException, InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        this.checkInterval(offset, length);
        ProducerLoop producerLoop = this;
        synchronized (producerLoop) {
            if (this.flowObs != null) {
                this.flowObs.update(100);
            }
            if (this.isAvailable(offset, length, -1L)) {
                return true;
            }
            if (timeout <= 0L) {
                return false;
            }
            long start = System.currentTimeMillis();
            long delta = timeout;
            do {
                if (!this.isAvailable(offset, length, delta)) continue;
                return true;
            } while ((delta = start + timeout - System.currentTimeMillis()) > 0L);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean waitForData(int offset, int length) throws BufferWriteException, InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        this.checkInterval(offset, length);
        ProducerLoop producerLoop = this;
        synchronized (producerLoop) {
            if (this.flowObs != null) {
                this.flowObs.update(100);
            }
            while (!this.isAvailable(offset, length, 0L)) {
            }
        }
        return true;
    }

    public Object doStep() throws Exception {
        if (this.PAYLOAD < this.bytesWritten) {
            throw new BufferWriteException("Overflow: PAYLOAD=" + this.PAYLOAD + " shouldn't be exceeded (" + this.bytesWritten + " bytes written so far).");
        }
        int writeLength = this.buffer.writeToBuffer(this.producer, this.bytesWritten);
        if (writeLength != -1) {
            this.updateBytesWritten(writeLength);
        } else {
            this.done = true;
        }
        return null;
    }

    public boolean isDone() {
        return this.done;
    }

    public void onStart() {
    }

    public void update(int step) {
    }

    public void onCancel() {
        this.onAbort(new BufferWriteException("Data retrieval cancelled."));
    }

    public synchronized void onAbort(Throwable cause) {
        if (this.flowObs != null) {
            this.flowObs.update(100);
        }
        this.discardCause = cause instanceof BufferWriteException ? (BufferWriteException)cause : new BufferWriteException("Unexpected runtime exception.", cause);
        this.state = 2;
        this.notifyAll();
    }

    public synchronized void onEnd(Object result) {
        if (this.flowObs != null) {
            this.flowObs.update(100);
        }
        if (this.bytesWritten == this.PAYLOAD) {
            this.state = 1;
        } else {
            String msg = "Underflow: PAYLOAD=" + this.PAYLOAD + " hasn't been reached " + "(" + this.bytesWritten + " bytes written in total).";
            this.discardCause = new BufferWriteException(msg);
            this.state = 2;
        }
        this.notifyAll();
    }

    void register(ControlFlowObserver obs) {
        this.flowObs = obs;
    }

    int getPayload() {
        return this.PAYLOAD;
    }

    synchronized int getState() {
        return this.state;
    }

    synchronized int getBytesWritten() {
        return this.bytesWritten;
    }

    synchronized BufferWriteException getDiscardCause() {
        return this.discardCause;
    }
}

