/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.ui.flim;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.filechooser.FileFilter;
import org.jdesktop.swingx.JXTaskPane;
import org.jdesktop.swingx.JXTaskPaneContainer;
import org.jdesktop.swingx.VerticalLayout;
import org.openmicroscopy.shoola.env.data.model.AnalysisResultsHandlingParam;
import org.openmicroscopy.shoola.env.ui.flim.TableIntervals;
import org.openmicroscopy.shoola.util.file.ExcelWriter;
import org.openmicroscopy.shoola.util.filter.file.CSVFilter;
import org.openmicroscopy.shoola.util.filter.file.ExcelFilter;
import org.openmicroscopy.shoola.util.image.geom.Factory;
import org.openmicroscopy.shoola.util.ui.NumericalTextField;
import org.openmicroscopy.shoola.util.ui.TitlePanel;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import org.openmicroscopy.shoola.util.ui.filechooser.FileChooser;
import org.openmicroscopy.shoola.util.ui.graphutils.ChartObject;
import org.openmicroscopy.shoola.util.ui.graphutils.HistogramPlot;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FLIMResultsDialog
extends JDialog
implements ActionListener,
PropertyChangeListener {
    public static final String SAVED_FLIM_RESULTS_PROPERTY = "savedFlimResults";
    private static final int CLOSE = 0;
    private static final int SAVE = 1;
    private static final int PLOT = 2;
    private static final Color DEFAULT_COLOR = Color.RED;
    private static final int BINS = 1001;
    private static final int FACTOR = 1000;
    private static List<FileFilter> FILTERS = new ArrayList<FileFilter>();
    private File file;
    private AnalysisResultsHandlingParam parameters;
    private JButton closeButton;
    private JButton saveButton;
    private JButton plotButton;
    private NumericalTextField maxThreshold;
    private NumericalTextField minThreshold;
    private JComponent body;
    private ChartObject chartObject;
    private FileChooser chooser;
    private List<Double> parseValues;
    private String name;
    private Double[][] data;
    private JXTaskPaneContainer paneContainer;
    private TableIntervals tableIntervals;
    private JTable tableValues;

    private void saveAs(File f) {
        if (f == null) {
            return;
        }
        FileFilter filter = this.chooser.getSelectedFilter();
        Iterator<FileFilter> i = FILTERS.iterator();
        boolean accept = false;
        while (i.hasNext()) {
            filter = i.next();
            if (!filter.accept(f)) continue;
            accept = true;
            break;
        }
        if (!accept) {
            f = new File(f.getAbsolutePath() + "." + "xls");
        }
        boolean b = true;
        File tmpFile = null;
        try {
            String v = f.getAbsolutePath();
            int index = v.lastIndexOf(".");
            tmpFile = new File(v.substring(0, index) + "." + "png");
            this.chartObject.saveAs(tmpFile, 0);
        }
        catch (Exception e) {
            b = false;
        }
        boolean result = true;
        try {
            int index = 0;
            ExcelWriter writer = new ExcelWriter(f.getAbsolutePath());
            writer.openFile();
            writer.createSheet("FLIM Results for ");
            int row = 0;
            if (this.tableIntervals != null) {
                row = this.tableIntervals.getModel().getRowCount() + 1;
                writer.writeTableToSheet(0, 0, this.tableIntervals.getModel());
            }
            if (this.tableValues != null) {
                writer.writeTableToSheet(row + 3, 0, this.tableValues.getModel());
            }
            if (b) {
                BufferedImage image = Factory.createImage(tmpFile);
                if (image != null) {
                    int w = image.getWidth();
                    int h = image.getHeight();
                    writer.addImageToWorkbook(this.name, image);
                    int col = writer.getMaxColumn(0);
                    writer.writeImage(0, index += col + 2, w, h, this.name);
                }
                writer.close();
            }
        }
        catch (Exception e) {
            result = false;
        }
        if (tmpFile != null) {
            tmpFile.delete();
        }
        this.firePropertyChange(SAVED_FLIM_RESULTS_PROPERTY, (Object)(!result ? 1 : 0), (Object)result);
    }

    private void createTable(Map<Double, Double> values) {
        Double[] numbers;
        HashMap<Double, Double> newValues = new HashMap<Double, Double>();
        for (Map.Entry<Double, Double> entry : values.entrySet()) {
            double key = UIUtilities.roundTwoDecimals(entry.getKey());
            Double value = (Double)newValues.get(key);
            value = value != null ? Double.valueOf(value + entry.getValue()) : entry.getValue();
            newValues.put(key, value);
        }
        this.data = new Double[newValues.size() + 1][2];
        Iterator<Map.Entry<Double, Double>> v = newValues.entrySet().iterator();
        int index = 0;
        double totalY = 0.0;
        while (v.hasNext()) {
            Map.Entry<Double, Double> entry;
            entry = v.next();
            numbers = new Double[]{entry.getKey(), entry.getValue()};
            this.data[index] = numbers;
            totalY += entry.getValue().doubleValue();
            ++index;
        }
        numbers = new Double[]{null, totalY};
        this.data[index] = numbers;
    }

    private void createChart(double[] values, int bins) {
        switch (this.parameters.getIndex()) {
            case 0: {
                HistogramPlot hp = new HistogramPlot();
                hp.setXAxisName(this.parameters.getNameXaxis());
                hp.setYAxisName(this.parameters.getNameYaxis());
                if (values == null) {
                    double min = Double.MAX_VALUE;
                    double max = Double.MIN_VALUE;
                    values = new double[this.parseValues.size()];
                    Iterator<Double> i = this.parseValues.iterator();
                    int index = 0;
                    while (i.hasNext()) {
                        double v = i.next();
                        if (v < min) {
                            min = v;
                        }
                        if (v > max) {
                            max = v;
                        }
                        values[index] = v;
                        ++index;
                    }
                }
                if (values.length > 0) {
                    hp.addSeries(this.name, values, DEFAULT_COLOR, 1001);
                }
                this.createTable(hp.getYValues(0));
                this.body = hp.getChart();
                this.chartObject = hp;
                break;
            }
        }
    }

    private void layoutBody(Container container) {
        if (this.body == null) {
            return;
        }
        if (this.data != null) {
            Object[] columns = new String[]{this.parameters.getNameXaxis(), this.parameters.getNameYaxis()};
            JSplitPane sp = new JSplitPane();
            sp.setLeftComponent(this.body);
            JXTaskPane pane = (JXTaskPane)this.paneContainer.getComponent(0);
            pane.removeAll();
            this.tableValues = new JTable(this.data, columns);
            this.tableValues.getTableHeader().setReorderingAllowed(false);
            pane.add((Component)new JScrollPane(this.tableValues));
            sp.setRightComponent((Component)this.paneContainer);
            container.add((Component)sp, "Center");
        } else {
            container.add((Component)this.body, "Center");
        }
    }

    private String getLegend() {
        return this.file.getName();
    }

    private void initComponents(String name) {
        this.tableIntervals = new TableIntervals(this, this.parameters.getNameYaxis());
        this.paneContainer = new JXTaskPaneContainer();
        VerticalLayout layout = (VerticalLayout)this.paneContainer.getLayout();
        layout.setGap(0);
        this.paneContainer.add(UIUtilities.createTaskPane("Graph Data", null));
        JXTaskPane p = UIUtilities.createTaskPane("Intervals Data", null);
        p.add((Component)new JScrollPane(this.tableIntervals));
        this.paneContainer.add(p);
        this.minThreshold = new NumericalTextField();
        this.minThreshold.setToolTipText("Plot only values greater than the value entered.");
        this.minThreshold.setNumberType(Double.class);
        this.minThreshold.setColumns(3);
        this.maxThreshold = new NumericalTextField();
        this.maxThreshold.setColumns(3);
        this.maxThreshold.setNumberType(Double.class);
        this.maxThreshold.setToolTipText("Plot only values lower than the value entered.");
        this.plotButton = new JButton("Plot");
        this.plotButton.setActionCommand("2");
        this.plotButton.addActionListener(this);
        this.closeButton = new JButton("Close");
        this.closeButton.setActionCommand("0");
        this.closeButton.addActionListener(this);
        this.saveButton = new JButton("Save");
        this.saveButton.setActionCommand("1");
        this.saveButton.addActionListener(this);
        this.parseValues = this.parseFile();
        if (this.parseValues == null || this.parseValues.size() == 0) {
            JLabel l = new JLabel();
            l.setText("Cannot display the results");
            this.body = l;
        } else {
            if (name == null || name.trim().length() == 0) {
                name = this.getLegend();
            }
            this.name = name;
            this.createChart(null, 1001);
        }
        this.saveButton.setEnabled(this.chartObject != null);
    }

    private void close() {
        this.setVisible(false);
        this.dispose();
        this.file.delete();
    }

    private void save() {
        this.chooser = new FileChooser((JFrame)this.getOwner(), 1, "Save Results", "Saves the results", FILTERS);
        this.chooser.setCurrentDirectory(UIUtilities.getDefaultFolder());
        int index = this.name.lastIndexOf(".");
        String value = this.name;
        if (index > 0) {
            value = this.name.substring(0, index);
        }
        this.chooser.setSelectedFile(value);
        this.chooser.addPropertyChangeListener(this);
        this.chooser.centerDialog();
    }

    private void plot() {
        double[] results;
        if (this.parseValues == null || this.parseValues.size() == 0) {
            return;
        }
        Number nMin = this.minThreshold.getValueAsNumber();
        Number nMax = this.maxThreshold.getValueAsNumber();
        Iterator<Double> i = this.parseValues.iterator();
        int index = 0;
        double binMin = Double.MAX_VALUE;
        double binMax = Double.MIN_VALUE;
        if (nMin == null && nMax == null) {
            results = new double[this.parseValues.size()];
            for (double v : this.parseValues) {
                if (v < binMin) {
                    binMin = v;
                }
                if (v > binMax) {
                    binMax = v;
                }
                results[index] = v;
                ++index;
            }
        } else if (nMin == null && nMax != null) {
            double max = nMax.doubleValue();
            ArrayList<Double> values = new ArrayList<Double>();
            while (i.hasNext()) {
                double v = i.next();
                if (!(v < max)) continue;
                if (v < binMin) {
                    binMin = v;
                }
                if (v > binMax) {
                    binMax = v;
                }
                values.add(v);
            }
            results = new double[values.size()];
            i = values.iterator();
            while (i.hasNext()) {
                results[index] = i.next();
                ++index;
            }
        } else if (nMax == null && nMin != null) {
            double min = nMin.doubleValue();
            ArrayList<Double> values = new ArrayList<Double>();
            while (i.hasNext()) {
                double v = i.next();
                if (!(v > min)) continue;
                if (v < binMin) {
                    binMin = v;
                }
                if (v > binMax) {
                    binMax = v;
                }
                values.add(v);
            }
            results = new double[values.size()];
            i = values.iterator();
            while (i.hasNext()) {
                results[index] = i.next();
                ++index;
            }
        } else {
            double min = nMin.doubleValue();
            double max = nMax.doubleValue();
            ArrayList<Double> values = new ArrayList<Double>();
            while (i.hasNext()) {
                double v = i.next();
                if (!(v > min) || !(v < max)) continue;
                if (v < binMin) {
                    binMin = v;
                }
                if (v > binMax) {
                    binMax = v;
                }
                values.add(v);
            }
            results = new double[values.size()];
            i = values.iterator();
            while (i.hasNext()) {
                results[index] = i.next();
                ++index;
            }
        }
        int bins = (int)(binMax - binMin);
        this.createChart(results, bins);
        this.tableIntervals.populateTable();
        Container container = this.getContentPane();
        Component c = container.getComponent(0);
        container.removeAll();
        container.add(c, "North");
        this.layoutBody(container);
        container.add((Component)this.buildControlsBar(), "South");
        container.validate();
        container.repaint();
    }

    private List<Double> parseCSV() {
        ArrayList<Double> list = new ArrayList<Double>();
        try {
            BufferedReader reader = new BufferedReader(new FileReader(this.file));
            String line = null;
            while ((line = reader.readLine()) != null) {
                StringTokenizer st = new StringTokenizer(line, ",");
                while (st.hasMoreTokens()) {
                    double v = Double.parseDouble(st.nextToken());
                    list.add(UIUtilities.roundTwoDecimals(v * 1000.0));
                }
            }
            reader.close();
            return list;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private List<Double> parseFile() {
        CSVFilter filter = new CSVFilter();
        if (((FileFilter)filter).accept(this.file)) {
            return this.parseCSV();
        }
        return null;
    }

    private JComponent buildControlsBar() {
        JPanel content = new JPanel();
        content.setLayout(new FlowLayout());
        JLabel l = new JLabel();
        l.setText("Min Threshold:");
        l.setToolTipText(this.minThreshold.getToolTipText());
        content.add(l);
        content.add(this.minThreshold);
        l = new JLabel();
        l.setText("Max Threshold:");
        l.setToolTipText(this.maxThreshold.getToolTipText());
        content.add(l);
        content.add(this.maxThreshold);
        JPanel p = new JPanel();
        p.add(this.plotButton);
        p.add(Box.createHorizontalStrut(10));
        p.add(this.saveButton);
        p.add(Box.createHorizontalStrut(10));
        p.add(this.closeButton);
        JPanel bar = new JPanel();
        bar.setLayout(new BoxLayout(bar, 0));
        bar.add(UIUtilities.buildComponentPanel(content));
        bar.add(Box.createHorizontalGlue());
        bar.add(UIUtilities.buildComponentPanelRight(p));
        return UIUtilities.buildComponentPanel(bar);
    }

    private void buildGUI(Icon icon) {
        TitlePanel tp = new TitlePanel("Results", "Follow a view of the results.", icon);
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        container.add((Component)((Object)tp), "North");
        this.layoutBody(container);
        container.add((Component)this.buildControlsBar(), "South");
    }

    public FLIMResultsDialog(JFrame owner, Icon icon, File file, String name, AnalysisResultsHandlingParam parameters) {
        super(owner);
        if (file == null) {
            throw new IllegalArgumentException("No results to display.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("No parameters set.");
        }
        this.file = file;
        this.parameters = parameters;
        this.initComponents(name);
        this.buildGUI(icon);
        this.pack();
    }

    Double getValueInInterval(Double lowerBound, Double upperBound) {
        if (this.data == null) {
            return null;
        }
        if (lowerBound == null && upperBound == null) {
            return null;
        }
        int n = this.data.length - 1;
        double count = 0.0;
        if (lowerBound != null && upperBound != null) {
            double min = lowerBound;
            double max = upperBound;
            for (int i = 0; i < n; ++i) {
                Double value = this.data[i][0];
                if (!(value >= min) || !(value < max)) continue;
                count += this.data[i][1].doubleValue();
            }
            return count;
        }
        if (lowerBound != null && upperBound == null) {
            double min = lowerBound;
            for (int i = 0; i < n; ++i) {
                Double value = this.data[i][0];
                if (!(value >= min)) continue;
                count += this.data[i][1].doubleValue();
            }
            return count;
        }
        return null;
    }

    Double getTotalValue() {
        return this.data[this.data.length - 1][1];
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int index = Integer.parseInt(e.getActionCommand());
        switch (index) {
            case 0: {
                this.close();
                break;
            }
            case 1: {
                this.save();
                break;
            }
            case 2: {
                this.plot();
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String name = evt.getPropertyName();
        if ("approveSelection".equals(name)) {
            this.saveAs((File)evt.getNewValue());
        }
    }

    static {
        FILTERS.add(new ExcelFilter());
    }
}

