/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.ui;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.openmicroscopy.shoola.env.Container;
import org.openmicroscopy.shoola.env.config.Registry;
import org.openmicroscopy.shoola.env.log.LogMessage;
import org.openmicroscopy.shoola.env.log.Logger;
import org.openmicroscopy.shoola.env.ui.ActivityComponent;
import org.openmicroscopy.shoola.env.ui.DownloadsDialog;
import org.openmicroscopy.shoola.env.ui.FileUploader;
import org.openmicroscopy.shoola.env.ui.IconManager;
import org.openmicroscopy.shoola.env.ui.UserNotifier;
import org.openmicroscopy.shoola.env.ui.UserNotifierLoader;
import org.openmicroscopy.shoola.svc.SvcRegistry;
import org.openmicroscopy.shoola.svc.communicator.Communicator;
import org.openmicroscopy.shoola.svc.communicator.CommunicatorDescriptor;
import org.openmicroscopy.shoola.util.ui.MessengerDetails;
import org.openmicroscopy.shoola.util.ui.MessengerDialog;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import pojos.ExperimenterData;

class UserNotifierManager
implements PropertyChangeListener {
    private static final String MESSAGE_START = "Sorry, but due to an error we were not able to automatically \n";
    private static final String MESSAGE_END = "\n\nYou can still send us the error message by clicking on the \nerror message tab, copying the error message to the clipboard, \nand sending it to ";
    private static final String ERROR_MSG = "send your debug information.";
    private static final String COMMENT_MSG = "send your comment.";
    private static final String COMMENT_REPLY = "Thanks, your comments have been successfully posted.";
    private static final String ERROR_REPLY = "Thanks, the error message has been successfully posted.";
    private static final String INVOKER_ERROR = "insight_bugs";
    private static final String INVOKER_COMMENT = "insight_comments";
    private static final String DEFAULT_COMMENT_TITLE = "Comment";
    private Container container;
    private UserNotifier component;
    private Map<String, UserNotifierLoader> loaders;
    private MessengerDialog commentDialog;
    private DownloadsDialog activityDialog;
    private List<ActivityComponent> activities;

    private void submitFiles(MessengerDialog source, MessengerDetails details) {
        FileUploader loader = new FileUploader(this.component, this.container.getRegistry(), source, details);
        loader.load();
    }

    private void handleSendMessage(MessengerDialog source, MessengerDetails details) {
        if (details.getObjectToSubmit() != null) {
            this.submitFiles(source, details);
            return;
        }
        Registry reg = this.container.getRegistry();
        boolean bug = true;
        String error = details.getError();
        if (error == null || error.length() == 0) {
            bug = false;
        }
        String url = (String)reg.lookup("/services/DEBUGGER/hostnameToken");
        String appName = bug ? (String)reg.lookup("/services/DEBUGGER/applicationNameBug") : (String)reg.lookup("/services/DEBUGGER/applicationNameComment");
        String teamAddress = (String)reg.lookup("/services/DEBUGGER/email");
        CommunicatorDescriptor desc = new CommunicatorDescriptor(1, url, -1);
        Object version = reg.lookup("Version");
        String v = "";
        if (version != null && version instanceof String) {
            v = (String)version;
        }
        try {
            Communicator c = SvcRegistry.getCommunicator(desc);
            StringBuilder builder = new StringBuilder();
            String reply = "";
            if (!bug) {
                c.submitComment(INVOKER_COMMENT, details.getEmail(), details.getComment(), details.getExtra(), appName, v, builder);
            } else {
                c.submitError(INVOKER_ERROR, details.getEmail(), details.getComment(), details.getExtra(), error, appName, v, builder);
            }
            reply = !bug ? reply + COMMENT_REPLY : reply + ERROR_REPLY;
            JOptionPane.showMessageDialog(source, reply);
        }
        catch (Exception e) {
            LogMessage msg = new LogMessage();
            msg.println("Failed to send message.");
            msg.println("Reason: " + e.getMessage());
            Logger logger = this.container.getRegistry().getLogger();
            logger.error((Object)this, msg);
            String s = MESSAGE_START;
            s = source.getDialogType() == 0 ? s + ERROR_MSG : s + COMMENT_MSG;
            s = s + MESSAGE_END;
            JOptionPane.showMessageDialog(source, s + teamAddress + ".");
        }
        source.setVisible(false);
        source.dispose();
    }

    private void createActivity() {
        if (this.activityDialog != null) {
            return;
        }
        Registry reg = this.getRegistry();
        JFrame f = reg.getTaskBar().getFrame();
        this.activityDialog = new DownloadsDialog(f, IconManager.getInstance(reg), 2);
    }

    UserNotifierManager(UserNotifier component, Container c) {
        this.container = c;
        this.component = component;
        this.loaders = new HashMap<String, UserNotifierLoader>();
        JFrame f = this.getRegistry().getTaskBar().getFrame();
        if (f != null) {
            f.addPropertyChangeListener("activities", this);
        }
    }

    ExperimenterData getExperimenter() {
        Object exp = this.container.getRegistry().lookup("/current_user/details");
        if (exp == null) {
            return null;
        }
        return (ExperimenterData)exp;
    }

    void registerActivity(ActivityComponent activity, boolean uiRegister) {
        if (activity == null) {
            return;
        }
        if (uiRegister) {
            this.createActivity();
            this.activityDialog.addActivityEntry(activity);
            this.showActivity();
        }
        if (this.activities == null) {
            this.activities = new ArrayList<ActivityComponent>();
        }
        activity.addPropertyChangeListener(this);
        this.activities.add(activity);
    }

    String getServerVersion() {
        String name;
        if (this.container == null) {
            return "";
        }
        String version = this.container.getRegistry().getAdminService().getServerVersion();
        if (version == null || version.trim().length() == 0) {
            version = "not available";
        }
        if ((name = this.container.getRegistry().getAdminService().getServerName()) == null) {
            name = "";
        }
        return "Server name: " + name + ", version: " + version;
    }

    Registry getRegistry() {
        return this.container.getRegistry();
    }

    MessengerDialog getCommentDialog(JFrame frame, String email) {
        if (this.commentDialog != null) {
            return this.commentDialog;
        }
        this.commentDialog = new MessengerDialog(frame, DEFAULT_COMMENT_TITLE, email);
        this.commentDialog.setServerVersion(this.getServerVersion());
        this.commentDialog.addPropertyChangeListener(this);
        this.commentDialog.setModal(false);
        this.commentDialog.setAlwaysOnTop(false);
        return this.commentDialog;
    }

    void showActivity() {
        if (this.activityDialog == null) {
            this.createActivity();
        }
        if (!this.activityDialog.isVisible()) {
            UIUtilities.centerAndShow(this.activityDialog);
        }
        this.activityDialog.requestFocusInWindow();
        this.activityDialog.toFront();
    }

    int getRunningActivitiesCount() {
        if (this.activities == null) {
            return 0;
        }
        return this.activities.size();
    }

    public void propertyChange(PropertyChangeEvent pce) {
        String name = pce.getPropertyName();
        if ("send".equals(name)) {
            MessengerDialog source = (MessengerDialog)pce.getSource();
            this.handleSendMessage(source, (MessengerDetails)pce.getNewValue());
        } else if ("closeMessenger".equals(name)) {
            this.commentDialog = null;
        } else if (!"saveToDisk".equals(name)) {
            ActivityComponent c;
            if ("cancelLoading".equals(name)) {
                String fileName = (String)pce.getNewValue();
                UserNotifierLoader loader = this.loaders.get(fileName);
                if (loader != null) {
                    loader.cancel();
                }
            } else if ("unregisterActivity".equals(name) && (c = (ActivityComponent)pce.getNewValue()) != null) {
                this.activities.remove(c);
            }
        }
    }
}

