/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.ui;

import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import org.openmicroscopy.shoola.env.ui.AbstractIconManager;
import org.openmicroscopy.shoola.env.ui.TaskBar;
import org.openmicroscopy.shoola.env.ui.TopWindowManager;
import org.openmicroscopy.shoola.util.ui.AnimatedJFrame;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

public abstract class TopWindow
extends AnimatedJFrame {
    private JButton quickLaunchBtn;
    private JMenuItem winMenuEntry;
    private TaskBar taskBar;

    private void configureButtons() {
        this.enableButtons(true);
    }

    protected void configureQuickLaunchBtn(Icon icon, String tooltip) {
        if (this.quickLaunchBtn != null) {
            this.quickLaunchBtn.setIcon(icon);
        }
        if (this.quickLaunchBtn != null) {
            this.quickLaunchBtn.setToolTipText(UIUtilities.formatToolTipText(tooltip));
        }
    }

    protected void configureWinMenuEntry(String name, Icon icon) {
        if (this.winMenuEntry != null) {
            this.winMenuEntry.setText(name);
        }
        if (this.winMenuEntry != null) {
            this.winMenuEntry.setIcon(icon);
        }
    }

    protected TopWindow(String title, TaskBar tb) {
        super(title);
        this.setIconImage(AbstractIconManager.getOMEImageIcon());
        if (tb == null) {
            throw new NullPointerException("No reference to the TaskBar.");
        }
        this.taskBar = tb;
        this.quickLaunchBtn = new JButton();
        this.winMenuEntry = new JMenuItem();
        this.configureButtons();
        new TopWindowManager(this, new AbstractButton[]{this.quickLaunchBtn, this.winMenuEntry});
    }

    protected TopWindow(String title) {
        super(title);
        this.setIconImage(AbstractIconManager.getOMEImageIcon());
    }

    public void deIconify() {
        if (this.getExtendedState() == 1) {
            this.setExtendedState(0);
        }
        this.setVisible(true);
    }

    public void iconify() {
        if (this.getExtendedState() == 0) {
            this.setExtendedState(1);
        }
        this.setVisible(false);
    }

    public void enableButtons(boolean b) {
        if (this.quickLaunchBtn != null) {
            this.quickLaunchBtn.setEnabled(b);
        }
        if (this.winMenuEntry != null) {
            this.winMenuEntry.setEnabled(b);
        }
    }

    public void open() {
        this.quickLaunchBtn.doClick();
    }

    public void close() {
        this.dispose();
    }

    public void setOnScreen() {
        this.pack();
        UIUtilities.centerAndShow(this);
    }
}

