/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.ui;

import java.awt.Dimension;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.awt.event.WindowStateListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JFrame;
import org.openmicroscopy.shoola.env.Container;
import org.openmicroscopy.shoola.env.config.OMEROInfo;
import org.openmicroscopy.shoola.env.config.Registry;
import org.openmicroscopy.shoola.env.data.login.UserCredentials;
import org.openmicroscopy.shoola.env.ui.IconManager;
import org.openmicroscopy.shoola.env.ui.SplashScreen;
import org.openmicroscopy.shoola.env.ui.SplashScreenFuture;
import org.openmicroscopy.shoola.env.ui.UIFactory;
import org.openmicroscopy.shoola.env.ui.UserNotifier;
import org.openmicroscopy.shoola.util.image.geom.Factory;
import org.openmicroscopy.shoola.util.ui.login.LoginCredentials;
import org.openmicroscopy.shoola.util.ui.login.ScreenLogin;
import org.openmicroscopy.shoola.util.ui.login.ScreenLogo;

class SplashScreenManager
implements PropertyChangeListener,
WindowFocusListener,
WindowStateListener {
    private ScreenLogin view;
    private ScreenLogo viewTop;
    private boolean isOpen;
    private SplashScreenFuture userCredentials;
    private int totalTasks;
    private int doneTasks;
    private Container container;
    private SplashScreen component;
    private Icon splashLogin;

    private void login(LoginCredentials lc) {
        try {
            UserCredentials uc = new UserCredentials(lc.getUserName(), lc.getPassword(), lc.getHostName(), lc.getSpeedLevel());
            uc.setPort(lc.getPort());
            uc.setEncrypted(lc.isEncrypted());
            uc.setGroup(lc.getGroup());
            this.userCredentials.set(uc);
        }
        catch (Exception e) {
            UserNotifier un = UIFactory.makeUserNotifier(this.container);
            un.notifyError("Login Incomplete", e.getMessage());
            this.view.setControlsEnabled(true);
            this.updateView();
        }
    }

    private void setWindowState(JFrame f, int state) {
        if (f == null) {
            return;
        }
        f.removeWindowStateListener(this);
        f.setState(state);
        f.addWindowStateListener(this);
    }

    private void updateView() {
        if (this.view != null) {
            this.view.setAlwaysOnTop(true);
        }
        this.viewTop.setAlwaysOnTop(true);
        if (this.view != null) {
            this.view.requestFocusOnField();
        }
    }

    private void initializedView() {
        if (this.view != null) {
            return;
        }
        Image img = IconManager.getOMEImageIcon();
        Object version = this.container.getRegistry().lookup("Version");
        String v = "";
        if (version != null && version instanceof String) {
            v = (String)version;
        }
        OMEROInfo omeroInfo = (OMEROInfo)this.container.getRegistry().lookup("/services/OMERODS");
        String port = "" + omeroInfo.getPortSSL();
        this.view = new ScreenLogin("Open Microscopy Environment", this.splashLogin, img, v, port, omeroInfo.getHostName());
        this.view.showConnectionSpeed(true);
        Dimension d = this.viewTop.getExtendedSize();
        Dimension dlogin = this.view.getPreferredSize();
        Rectangle r = this.viewTop.getBounds();
        this.view.setBounds(r.x, r.y + d.height, dlogin.width, dlogin.height);
        this.view.addPropertyChangeListener(this);
        this.view.addWindowStateListener(this);
        this.view.addWindowFocusListener(this);
    }

    SplashScreenManager(SplashScreen component, Container c) {
        this.container = c;
        this.component = component;
        Image img = IconManager.getOMEImageIcon();
        Registry reg = c.getRegistry();
        String n = (String)reg.lookup("SplashScreenLogo");
        String f = this.container.resolveFilePath(null, "config");
        Icon splashScreen = Factory.createIcon(n, f);
        if (splashScreen == null) {
            Boolean online = (Boolean)this.container.getRegistry().lookup("/services/SERVER/available");
            splashScreen = online == false ? IconManager.getEditorSplashScreen() : IconManager.getSplashScreen();
        }
        n = (String)reg.lookup("SplashScreenLogin");
        this.splashLogin = Factory.createIcon(n, f);
        if (this.splashLogin == null) {
            this.splashLogin = IconManager.getLoginBackground();
        }
        this.view = new ScreenLogin("Open Microscopy Environment", this.splashLogin, img);
        this.viewTop = new ScreenLogo("Open Microscopy Environment", splashScreen, img);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension d = this.viewTop.getExtendedSize();
        Dimension dlogin = this.view.getPreferredSize();
        int totalHeight = d.height + dlogin.height;
        this.viewTop.setBounds((screenSize.width - d.width) / 2, (screenSize.height - totalHeight) / 2, d.width, this.viewTop.getSize().height);
        this.view = null;
        this.viewTop.addPropertyChangeListener(this);
        this.viewTop.addWindowStateListener(this);
        this.viewTop.addWindowFocusListener(this);
        this.isOpen = false;
        this.doneTasks = 0;
    }

    void open() {
        if (this.viewTop == null) {
            return;
        }
        this.initializedView();
        this.viewTop.setVisible(true);
        this.isOpen = true;
    }

    void close() {
        if (this.view == null || this.viewTop == null) {
            return;
        }
        this.view.setVisible(false);
        this.viewTop.setVisible(false);
        this.view.dispose();
        this.viewTop.dispose();
        this.view = null;
        this.viewTop = null;
        this.isOpen = false;
    }

    void setTotalTasks(int value) {
        if (!this.isOpen) {
            return;
        }
        this.totalTasks = value;
        ++this.totalTasks;
        this.viewTop.initProgressBar(value);
    }

    void updateProgress(String task) {
        if (!this.isOpen) {
            return;
        }
        int n = this.doneTasks++;
        this.viewTop.setStatus(task, n);
        if (this.doneTasks == this.totalTasks) {
            this.viewTop.setStatusVisible(false);
            Boolean online = (Boolean)this.container.getRegistry().lookup("/services/SERVER/available");
            if (online.booleanValue()) {
                this.view.setVisible(true);
            } else {
                this.viewTop.setVisible(false);
            }
        }
    }

    void collectUserCredentials(SplashScreenFuture future, boolean init) {
        this.userCredentials = future;
        if (this.view != null) {
            this.view.setControlsEnabled(true);
        }
        if (!init) {
            if (this.view != null) {
                this.view.cleanField(1);
            }
            this.updateView();
        }
    }

    void collectUserCredentialsInit(SplashScreenFuture future) {
        this.userCredentials = future;
        if (this.view != null) {
            this.view.setControlsEnabled(true);
        }
    }

    void onLoginFailure() {
        this.view.setControlsEnabled(true);
        this.updateView();
    }

    public void propertyChange(PropertyChangeEvent evt) {
        String name = evt.getPropertyName();
        if ("login".equals(name)) {
            LoginCredentials lc = (LoginCredentials)evt.getNewValue();
            if (this.userCredentials != null && lc != null) {
                this.login(lc);
            }
        } else if ("quit".equals(name)) {
            this.container.exit();
            this.component.close();
        } else if ("toFront".equals(name) || "moveFront".equals(name)) {
            this.updateView();
        }
    }

    public void windowStateChanged(WindowEvent e) {
        Object src = e.getSource();
        int state = e.getNewState();
        if (!(src instanceof ScreenLogo) && src instanceof ScreenLogin) {
            this.setWindowState(this.viewTop, state);
        }
        if (this.view != null) {
            this.view.setAlwaysOnTop(state == 0);
        }
        if (this.viewTop != null) {
            this.viewTop.setAlwaysOnTop(state == 0);
        }
    }

    public void windowLostFocus(WindowEvent e) {
        if (e.getOppositeWindow() == null) {
            if (this.view != null) {
                this.view.setAlwaysOnTop(false);
            }
            if (this.view != null) {
                this.viewTop.setAlwaysOnTop(false);
            }
        }
    }

    public void windowGainedFocus(WindowEvent e) {
    }
}

