/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.ui;

import org.openmicroscopy.shoola.env.config.Registry;
import org.openmicroscopy.shoola.env.data.model.ScriptObject;
import org.openmicroscopy.shoola.env.data.views.CallHandle;
import org.openmicroscopy.shoola.env.ui.ActivityComponent;
import org.openmicroscopy.shoola.env.ui.UserNotifier;
import org.openmicroscopy.shoola.env.ui.UserNotifierLoader;

public class ScriptUploader
extends UserNotifierLoader {
    private CallHandle handle;
    private ScriptObject script;

    protected void onException(String message, Throwable ex) {
        this.activity.notifyError("Unable to upload the script", message, ex);
    }

    public ScriptUploader(UserNotifier viewer, Registry registry, ScriptObject script, ActivityComponent activity) {
        super(viewer, registry, activity);
        if (script == null) {
            throw new IllegalArgumentException("No script to run.");
        }
        this.script = script;
    }

    public void load() {
        this.handle = this.ivView.uploadScript(this.script, this);
    }

    public void cancel() {
        this.handle.cancel();
    }

    public void handleResult(Object result) {
        if (result == null) {
            this.onException("No result returned.", null);
        } else if (result instanceof Long) {
            Long value = (Long)result;
            if (value < 0L) {
                this.onException("No result returned.", null);
            } else {
                this.activity.endActivity(result);
            }
        }
    }
}

