/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.ui;

import org.openmicroscopy.shoola.env.config.Registry;
import org.openmicroscopy.shoola.env.data.model.MovieActivityParam;
import org.openmicroscopy.shoola.env.ui.ActivityComponent;
import org.openmicroscopy.shoola.env.ui.MovieCreator;
import org.openmicroscopy.shoola.env.ui.UserNotifier;
import org.openmicroscopy.shoola.env.ui.UserNotifierLoader;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

public class MovieActivity
extends ActivityComponent {
    private static final String DESCRIPTION_CREATION = "Creating movie for";
    private static final String DESCRIPTION_CREATED = "Movie created for";
    private static final String DESCRIPTION_CANCEL = "Movie creation cancelled for";
    private MovieActivityParam parameters;

    public MovieActivity(UserNotifier viewer, Registry registry, MovieActivityParam parameters) {
        super(viewer, registry, DESCRIPTION_CREATION, parameters.getIcon());
        if (parameters == null) {
            throw new IllegalArgumentException("Parameters not valid.");
        }
        this.parameters = parameters;
        String name = parameters.getImage().getName();
        this.messageLabel.setText(UIUtilities.getPartialName(name));
        this.messageLabel.setToolTipText(name);
    }

    protected UserNotifierLoader createLoader() {
        this.loader = new MovieCreator(this.viewer, this.registry, this.parameters.getParameters(), this.parameters.getChannels(), this.parameters.getImage(), this);
        return this.loader;
    }

    protected void notifyActivityEnd() {
        this.type.setText(DESCRIPTION_CREATED);
    }

    protected void notifyActivityCancelled() {
        this.type.setText(DESCRIPTION_CANCEL);
    }

    protected void notifyActivityError() {
    }
}

