/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.ui;

import java.io.File;
import org.openmicroscopy.shoola.env.config.Registry;
import org.openmicroscopy.shoola.env.data.views.CallHandle;
import org.openmicroscopy.shoola.env.ui.ActivityComponent;
import org.openmicroscopy.shoola.env.ui.UserNotifier;
import org.openmicroscopy.shoola.env.ui.UserNotifierLoader;
import pojos.ImageData;

public class ExportLoader
extends UserNotifierLoader {
    public static final int EXPORT_AS_OME_TIFF = 0;
    public static final int EXPORT_AS_OME_XML = 1;
    private CallHandle handle;
    private ImageData image;
    private File file;
    private int index;

    protected void onException(String message, Throwable ex) {
        switch (this.index) {
            case 0: {
                this.activity.notifyError("Unable to export as OME-TIFF", message, ex);
                break;
            }
            case 1: {
                this.activity.notifyError("Unable to export as OME-XML", message, ex);
            }
        }
    }

    public ExportLoader(UserNotifier viewer, Registry registry, ImageData image, File file, int index, ActivityComponent activity) {
        super(viewer, registry, activity);
        if (image == null) {
            throw new IllegalArgumentException("Image not valid.");
        }
        this.image = image;
        this.file = file;
        this.index = index;
    }

    public void load() {
        this.handle = this.ivView.exportImageAsOMETiff(this.image.getId(), this.file, this);
    }

    public void cancel() {
        this.handle.cancel();
    }

    public void handleResult(Object result) {
        if (result == null) {
            this.onException("No result returned.", null);
        } else {
            this.activity.endActivity(result);
        }
    }
}

