/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.ui;

import java.util.List;
import org.openmicroscopy.shoola.env.config.Registry;
import org.openmicroscopy.shoola.env.data.ScriptCallback;
import org.openmicroscopy.shoola.env.data.events.DSCallFeedbackEvent;
import org.openmicroscopy.shoola.env.data.views.CallHandle;
import org.openmicroscopy.shoola.env.ui.ActivityComponent;
import org.openmicroscopy.shoola.env.ui.UserNotifier;
import org.openmicroscopy.shoola.env.ui.UserNotifierLoader;
import pojos.FileAnnotationData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Analyser
extends UserNotifierLoader {
    private CallHandle handle;
    private Object param;
    private List<Long> ids;
    private Class type;
    private FileAnnotationData data;
    private int index;
    private ScriptCallback callBack;

    @Override
    protected void onException(String message, Throwable ex) {
        this.activity.notifyError("Unable to analyse data", message, ex);
    }

    protected void onException() {
        this.handleNullResult();
    }

    public Analyser(UserNotifier viewer, Registry registry, Object param, List<Long> ids, Class type, int index, ActivityComponent activity) {
        super(viewer, registry, activity);
        if (ids == null || ids.size() == 0) {
            throw new IllegalArgumentException("Objects not valid.");
        }
        if (param == null) {
            throw new IllegalArgumentException("Parameters cannot be null.");
        }
        this.param = param;
        this.ids = ids;
        this.type = type;
        this.index = index;
    }

    @Override
    public void load() {
        switch (this.index) {
            case 0: {
                break;
            }
            case 1: {
                this.handle = this.ivView.analyseFRAP(this.ids, this.type, this.param, this);
            }
        }
    }

    @Override
    public void cancel() {
        try {
            if (this.callBack != null) {
                this.callBack.cancel();
                this.activity.onActivityCancelled();
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
        this.handle.cancel();
    }

    @Override
    public void update(DSCallFeedbackEvent fe) {
        Object o = fe.getPartialResult();
        if (o != null) {
            if (o instanceof Boolean) {
                Boolean b = (Boolean)o;
                if (!b.booleanValue()) {
                    this.onException("Unable to start the script.", null);
                }
            } else {
                this.callBack = (ScriptCallback)((Object)o);
                this.callBack.setAdapter(this);
                this.activity.onCallBackSet();
            }
        }
    }

    @Override
    public void handleResult(Object result) {
        if (result == null) {
            this.onException("No result returned.", null);
        } else if (!(result instanceof Boolean)) {
            this.activity.endActivity(result);
        }
    }
}

