/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.ui;

import info.clearthought.layout.TableLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import omero.model.OriginalFile;
import org.jdesktop.swingx.JXBusyLabel;
import org.openmicroscopy.shoola.env.Environment;
import org.openmicroscopy.shoola.env.config.Registry;
import org.openmicroscopy.shoola.env.data.model.AnalysisResultsHandlingParam;
import org.openmicroscopy.shoola.env.data.model.ApplicationData;
import org.openmicroscopy.shoola.env.data.model.DownloadActivityParam;
import org.openmicroscopy.shoola.env.event.EventBus;
import org.openmicroscopy.shoola.env.ui.ActivityProcessEvent;
import org.openmicroscopy.shoola.env.ui.ActivityResultDialog;
import org.openmicroscopy.shoola.env.ui.ActivityResultMenu;
import org.openmicroscopy.shoola.env.ui.DeleteActivity;
import org.openmicroscopy.shoola.env.ui.IconManager;
import org.openmicroscopy.shoola.env.ui.UserNotifier;
import org.openmicroscopy.shoola.env.ui.UserNotifierLoader;
import org.openmicroscopy.shoola.env.ui.ViewObjectEvent;
import org.openmicroscopy.shoola.env.ui.flim.FLIMResultsDialog;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import org.openmicroscopy.shoola.util.ui.filechooser.FileChooser;
import pojos.DatasetData;
import pojos.FileAnnotationData;
import pojos.ImageData;
import pojos.ProjectData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ActivityComponent
extends JPanel
implements ActionListener {
    static final String REMOVE_ACTIVITY_PROPERTY = "removeActivity";
    static final String UNREGISTER_ACTIVITY_PROPERTY = "unregisterActivity";
    static final String VIEW_TEXT = "View";
    private static final String BROWSE_TEXT = "Browse";
    private static final Dimension SIZE = new Dimension(22, 22);
    private static final int REMOVE = 0;
    private static final int DOWNLOAD = 1;
    private static final int CANCEL = 2;
    private static final int VIEW = 3;
    private static final int INFO = 4;
    private static final int RESULT = 5;
    private static final int ERROR = 6;
    private static final int EXCEPTION = 7;
    private static final int PLOT = 8;
    private static final String MESSAGE = "Message";
    static final String STD_ERR = "stderr";
    static final String STD_OUT = "stdout";
    private JXBusyLabel status;
    private JButton removeButton;
    private JButton cancelButton;
    protected JLabel iconLabel;
    private JComponent statusPane;
    private int index;
    private int buttonIndex;
    private JToolBar toolBar;
    private JButton exceptionButton;
    private ActivityResultMenu errorMenu;
    private ActivityResultMenu infoMenu;
    private Throwable exception;
    protected JButton downloadButton;
    protected JButton viewButton;
    protected JButton infoButton;
    protected JButton resultButton;
    protected JButton errorButton;
    private JButton plotButton;
    protected JLabel type;
    protected JLabel messageLabel;
    protected final Registry registry;
    protected final UserNotifier viewer;
    protected Object result;
    protected UserNotifierLoader loader;

    private void open(Object object, Object parameters) {
        File f;
        if (!(object instanceof FileAnnotationData) && !(object instanceof OriginalFile)) {
            return;
        }
        Environment env = (Environment)this.registry.lookup("/env");
        int index = -1;
        long id = -1L;
        String name = "";
        OriginalFile of = null;
        if (object instanceof FileAnnotationData) {
            FileAnnotationData data = (FileAnnotationData)object;
            if (data.isLoaded()) {
                of = (OriginalFile)data.getContent();
                name = data.getFileName();
            } else {
                id = data.getId();
                index = 1;
                name = "Annotation_" + id;
            }
        } else {
            of = (OriginalFile)object;
            id = of.getId().getValue();
            if (!of.isLoaded()) {
                index = 0;
                name = "File_" + id;
            } else {
                name = of.getName() != null ? of.getName().getValue() : "File_" + id;
            }
        }
        String path = env.getOmeroFilesHome();
        if (index != -1) {
            f = new File(path = path + File.separator + name);
            if (f.exists()) {
                f.delete();
                f = new File(path);
            }
            f.deleteOnExit();
        } else {
            String v = path + File.separator + name;
            File ff = new File(v);
            if (ff.exists()) {
                ff.delete();
            }
            f = new File(path);
        }
        DownloadActivityParam activity = index != -1 ? new DownloadActivityParam(id, index, f, null) : new DownloadActivityParam(of, f, null);
        if (parameters instanceof ApplicationData) {
            activity.setApplicationData((ApplicationData)parameters);
        } else if (parameters instanceof AnalysisResultsHandlingParam) {
            activity.setResults((AnalysisResultsHandlingParam)parameters);
        }
        this.viewer.notifyActivity(activity);
    }

    private void initComponents(String text, Icon icon) {
        this.exceptionButton = this.createButton("Error", 7, this);
        this.exceptionButton.setVisible(false);
        this.removeButton = this.createButton("Remove", 0, this);
        this.cancelButton = this.createButton("Cancel", 2, this);
        this.downloadButton = this.createButton("Download", 1, this);
        this.downloadButton.setVisible(false);
        this.plotButton = this.createButton("Plot", 8, this);
        this.plotButton.setVisible(false);
        this.viewButton = this.createButton(VIEW_TEXT, 3, this);
        this.viewButton.setVisible(false);
        this.infoButton = this.createButton("Info", 4, this);
        this.infoButton.setVisible(false);
        this.resultButton = this.createButton("Show result", 5, this);
        this.resultButton.setVisible(false);
        this.errorButton = this.createButton("Error", 6, this);
        this.errorButton.setVisible(false);
        this.errorButton.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent e) {
                Point p = e.getPoint();
                ActivityComponent.this.errorMenu.show((Component)e.getSource(), p.x, p.y);
            }
        });
        this.infoButton.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent e) {
                Point p = e.getPoint();
                ActivityComponent.this.infoMenu.show((Component)e.getSource(), p.x, p.y);
            }
        });
        this.status = new JXBusyLabel(SIZE);
        this.type = UIUtilities.setTextFont(text);
        this.messageLabel = UIUtilities.setTextFont("", 2, 10);
        this.iconLabel = new JLabel();
        this.iconLabel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        if (icon != null) {
            this.iconLabel.setIcon(icon);
        }
        this.statusPane = this.status;
    }

    private void buildGUI() {
        JPanel barPane = new JPanel();
        barPane.setOpaque(false);
        barPane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        double[][] size = new double[][]{{-1.0}, {-2.0, -2.0}};
        barPane.setLayout((LayoutManager)new TableLayout((double[][])size));
        barPane.add((Component)this.type, "0, 0, LEFT, CENTER");
        barPane.add((Component)this.messageLabel, "0, 1, CENTER, CENTER");
        double[][] tl = new double[][]{{-2.0, -1.0, -2.0}, {-2.0}};
        this.setLayout((LayoutManager)new TableLayout((double[][])tl));
        this.add((Component)this.statusPane, "0, 0, CENTER, CENTER");
        JPanel p = UIUtilities.buildComponentPanel(barPane);
        p.setOpaque(false);
        p.setBackground(barPane.getBackground());
        this.add((Component)p, "1, 0");
        this.add((Component)this.createToolBar(), "2, 0");
    }

    private JComponent createToolBar() {
        this.toolBar = new JToolBar();
        this.toolBar.setOpaque(false);
        this.toolBar.setFloatable(false);
        this.toolBar.setBorder(null);
        this.buttonIndex = 0;
        this.toolBar.add(this.exceptionButton);
        this.toolBar.add(Box.createHorizontalStrut(5));
        this.toolBar.add(this.downloadButton);
        this.toolBar.add(Box.createHorizontalStrut(5));
        this.toolBar.add(this.viewButton);
        this.toolBar.add(Box.createHorizontalStrut(5));
        this.toolBar.add(this.resultButton);
        this.toolBar.add(Box.createHorizontalStrut(5));
        this.toolBar.add(this.errorButton);
        this.toolBar.add(Box.createHorizontalStrut(5));
        this.toolBar.add(this.infoButton);
        this.toolBar.add(Box.createHorizontalStrut(5));
        this.buttonIndex = 12;
        this.toolBar.add(this.cancelButton);
        JLabel l = new JLabel();
        Font f = l.getFont();
        l.setForeground(UIUtilities.LIGHT_GREY.darker());
        l.setFont(f.deriveFont(f.getStyle(), f.getSize() - 2));
        String s = UIUtilities.formatShortDateTime(null);
        String[] values = s.split(" ");
        if (values.length > 1) {
            String v = values[1];
            if (values.length > 2) {
                v = v + " " + values[2];
            }
            l.setText(v);
            this.toolBar.add(Box.createHorizontalStrut(5));
            this.toolBar.add(l);
            this.toolBar.add(Box.createHorizontalStrut(5));
        }
        return this.toolBar;
    }

    private void reset() {
        this.toolBar.remove(this.buttonIndex);
        this.toolBar.add((Component)this.removeButton, this.buttonIndex);
        this.removeButton.setEnabled(true);
        this.downloadButton.setVisible(false);
        this.viewButton.setVisible(false);
        this.infoButton.setVisible(false);
        this.resultButton.setVisible(false);
        this.errorButton.setVisible(false);
        this.exceptionButton.setVisible(false);
        this.status.setBusy(false);
        this.status.setVisible(false);
        this.statusPane = this.iconLabel;
        this.remove(this.statusPane);
        this.add((Component)this.statusPane, "0, 0, CENTER, CENTER");
        this.repaint();
    }

    private Map<String, Object> convertResult(Map<String, Object> m) {
        HashMap<String, Object> objects = new HashMap<String, Object>();
        if (m == null) {
            return objects;
        }
        this.messageLabel.setText("");
        Object v = m.get(MESSAGE);
        if (v != null && v instanceof String) {
            this.messageLabel.setText((String)v);
        }
        m.remove(MESSAGE);
        if (m.containsKey(STD_ERR)) {
            this.errorButton.setVisible(true);
            this.errorMenu = new ActivityResultMenu(m.get(STD_ERR), this);
            m.remove(STD_ERR);
        }
        if (m.containsKey(STD_OUT)) {
            this.infoButton.setVisible(true);
            this.infoMenu = new ActivityResultMenu(m.get(STD_OUT), this);
            m.remove(STD_OUT);
        }
        return m;
    }

    private void showResult() {
        JFrame f = this.registry.getTaskBar().getFrame();
        ActivityResultDialog d = new ActivityResultDialog(f, this, this.result);
        UIUtilities.centerAndShow(d);
    }

    private void showException() {
        if (this.exception == null) {
            return;
        }
        this.viewer.notifyError(this.type.getText(), this.messageLabel.getText(), this.exception);
    }

    ActivityComponent(UserNotifier viewer, Registry registry, String text, Icon icon) {
        if (viewer == null) {
            throw new NullPointerException("No viewer.");
        }
        if (registry == null) {
            throw new NullPointerException("No registry.");
        }
        this.viewer = viewer;
        this.registry = registry;
        this.initComponents(text, icon);
        this.buildGUI();
    }

    void setIndex(int index) {
        this.index = index;
    }

    JButton createButton(String text, int actionID, ActionListener l) {
        JButton b = new JButton(text);
        Font f = b.getFont();
        b.setFont(f.deriveFont(f.getStyle(), f.getSize() - 2));
        b.setActionCommand("" + actionID);
        b.addActionListener(l);
        b.setOpaque(false);
        b.setForeground(UIUtilities.HYPERLINK_COLOR);
        UIUtilities.unifiedButtonLookAndFeel(b);
        return b;
    }

    String getFileName(File[] files, String fileName, String original, String dirPath, int index, String extension) {
        String path = dirPath + original;
        boolean exist = false;
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                if (!files[i].getAbsolutePath().equals(path)) continue;
                exist = true;
                break;
            }
        }
        if (!exist) {
            return original;
        }
        if (fileName == null || fileName.trim().length() == 0) {
            return original;
        }
        if (extension != null && extension.trim().length() > 0) {
            int n = fileName.lastIndexOf(extension);
            String v = fileName.substring(0, n) + "_(" + index + ")" + extension;
            return this.getFileName(files, fileName, v, dirPath, ++index, extension);
        }
        int lastDot = fileName.lastIndexOf(".");
        if (lastDot != -1) {
            extension = fileName.substring(lastDot, fileName.length());
            String v = fileName.substring(0, lastDot) + "_(" + index + ")" + extension;
            return this.getFileName(files, fileName, v, dirPath, ++index, null);
        }
        return original;
    }

    public void onActivityCancelled() {
        this.reset();
        this.notifyActivityCancelled();
        this.firePropertyChange(UNREGISTER_ACTIVITY_PROPERTY, null, this);
        EventBus bus = this.registry.getEventBus();
        bus.post(new ActivityProcessEvent(this, false));
    }

    public void onCallBackSet() {
        this.cancelButton.setEnabled(true);
    }

    public void startActivity() {
        this.status.setBusy(true);
    }

    String getViewText(Object object) {
        if (!this.isViewable(object)) {
            return VIEW_TEXT;
        }
        if (object instanceof DatasetData || object instanceof ProjectData) {
            return BROWSE_TEXT;
        }
        return VIEW_TEXT;
    }

    boolean isViewable(Object object) {
        OriginalFile of;
        String mimetype = null;
        if (object instanceof ImageData) {
            return true;
        }
        if (object instanceof DatasetData) {
            return true;
        }
        if (object instanceof ProjectData) {
            return true;
        }
        if (object instanceof FileAnnotationData) {
            OriginalFile of2;
            FileAnnotationData fa = (FileAnnotationData)object;
            if (fa.isLoaded() && (of2 = (OriginalFile)fa.getContent()).isLoaded() && of2.getMimetype() != null) {
                mimetype = of2.getMimetype().getValue();
            }
        } else if (object instanceof OriginalFile && (of = (OriginalFile)object).isLoaded() && of.getMimetype() != null) {
            mimetype = of.getMimetype().getValue();
        }
        if (mimetype != null) {
            return "image/jpeg".equals(mimetype) || "image/png".equals(mimetype) || "image/tiff".equals(mimetype) || "image/gif".equals(mimetype);
        }
        return false;
    }

    boolean canPlotResult(Object object) {
        FileAnnotationData fa;
        if (object instanceof FileAnnotationData && (fa = (FileAnnotationData)object).isLoaded()) {
            return fa.getFileName().endsWith(".csv");
        }
        return false;
    }

    boolean isDownloadable(Object object) {
        return object instanceof FileAnnotationData || object instanceof OriginalFile;
    }

    void download(String text, Object object) {
        if (!(object instanceof FileAnnotationData) && !(object instanceof OriginalFile)) {
            return;
        }
        int index = -1;
        if (text == null) {
            text = "";
        }
        String name = "";
        String description = "";
        long dataID = -1L;
        OriginalFile of = null;
        if (object instanceof FileAnnotationData) {
            FileAnnotationData data = (FileAnnotationData)object;
            if (data.isLoaded()) {
                name = data.getFileName();
                description = data.getDescription();
                of = (OriginalFile)data.getContent();
            } else {
                of = null;
                dataID = data.getId();
                index = 1;
                if (text.length() == 0) {
                    text = "Annotation";
                }
                name = text + "_" + dataID;
            }
        } else {
            of = (OriginalFile)object;
            if (!of.isLoaded()) {
                dataID = of.getId().getValue();
                index = 0;
                if (text.length() == 0) {
                    text = "File";
                }
                name = text + "_" + dataID;
                of = null;
            }
        }
        final OriginalFile original = of;
        final int type = index;
        final String desc = description;
        final long id = dataID;
        JFrame f = this.registry.getTaskBar().getFrame();
        FileChooser chooser = new FileChooser(f, 1, "Download", "Select where to download the file.", null, true);
        IconManager icons = IconManager.getInstance(this.registry);
        chooser.setTitleIcon(icons.getIcon(18));
        chooser.setSelectedFileFull(name);
        chooser.setApproveButtonText("Download");
        chooser.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                String name = evt.getPropertyName();
                if ("approveSelection".equals(name)) {
                    File folder = (File)evt.getNewValue();
                    if (original == null && type == -1) {
                        return;
                    }
                    IconManager icons = IconManager.getInstance(ActivityComponent.this.registry);
                    DownloadActivityParam activity = original != null ? new DownloadActivityParam(original, folder, icons.getIcon(17)) : new DownloadActivityParam(id, type, folder, icons.getIcon(17));
                    activity.setLegend(desc);
                    ActivityComponent.this.viewer.notifyActivity(activity);
                }
            }
        });
        chooser.centerDialog();
    }

    void view(Object object) {
        if (object instanceof FileAnnotationData || object instanceof OriginalFile) {
            this.open(object, new ApplicationData(""));
        } else if (object instanceof File) {
            this.viewer.openApplication(null, ((File)object).getAbsolutePath());
        } else {
            EventBus bus = this.registry.getEventBus();
            bus.post(new ViewObjectEvent(object));
        }
    }

    void plotResult(Object result) {
        if (result instanceof FileAnnotationData || result instanceof OriginalFile) {
            this.open(result, new AnalysisResultsHandlingParam(0));
        }
    }

    void plotResult(Object result, AnalysisResultsHandlingParam parameters, String name) {
        if (result instanceof File) {
            IconManager icons = IconManager.getInstance(this.registry);
            FLIMResultsDialog d = new FLIMResultsDialog(this.registry.getTaskBar().getFrame(), icons.getIcon(21), (File)result, name, parameters);
            d.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent evt) {
                    String name = evt.getPropertyName();
                    if ("savedFlimResults".equals(name)) {
                        boolean b = (Boolean)evt.getNewValue();
                        UserNotifier un = ActivityComponent.this.registry.getUserNotifier();
                        if (b) {
                            un.notifyInfo("Saving Results", "The file has successfully been saved.");
                        } else {
                            un.notifyInfo("Saving Results", "An error occurred while saving the results.");
                        }
                    }
                }
            });
            UIUtilities.centerAndShow(d);
        }
    }

    boolean isOngoingActivity() {
        return this.status.isBusy();
    }

    public void notifyError(String text, String message, Throwable ex) {
        this.reset();
        if (text != null) {
            this.type.setText(text);
        }
        if (message != null) {
            this.messageLabel.setText(message);
        }
        this.exception = ex;
        if (this.exception != null) {
            this.exceptionButton.setVisible(true);
        }
        this.notifyActivityError();
        this.firePropertyChange(UNREGISTER_ACTIVITY_PROPERTY, null, this);
        EventBus bus = this.registry.getEventBus();
        bus.post(new ActivityProcessEvent(this, false));
    }

    public void endActivity(Object result) {
        this.result = result;
        boolean busy = this.status.isBusy();
        this.reset();
        if (result instanceof Map) {
            Map<String, Object> m = this.convertResult((Map)result);
            int size = m.size();
            if (size == 1) {
                for (Map.Entry<String, Object> entry : m.entrySet()) {
                    this.result = entry.getValue();
                }
            } else {
                this.result = m;
            }
        }
        this.downloadButton.setVisible(this.isDownloadable(this.result));
        if (this.isViewable(this.result)) {
            this.viewButton.setText(this.getViewText(this.result));
            this.viewButton.setVisible(true);
        } else {
            this.viewButton.setVisible(false);
        }
        if (!this.viewButton.isVisible() && !this.downloadButton.isVisible()) {
            Object l;
            if (this.result instanceof Collection) {
                l = (Collection)this.result;
                if (this instanceof DeleteActivity) {
                    this.resultButton.setText("Show error");
                }
                this.resultButton.setVisible(l.size() > 0);
            } else if (this.result instanceof Map) {
                l = (Map)this.result;
                this.resultButton.setVisible(l.size() > 0);
            }
        }
        this.notifyActivityEnd();
        this.firePropertyChange(UNREGISTER_ACTIVITY_PROPERTY, null, this);
        EventBus bus = this.registry.getEventBus();
        bus.post(new ActivityProcessEvent(this, busy));
    }

    public JComponent getActivityType() {
        return new JLabel(this.type.getText());
    }

    protected abstract void notifyActivityCancelled();

    protected abstract void notifyActivityEnd();

    protected abstract void notifyActivityError();

    protected abstract UserNotifierLoader createLoader();

    @Override
    public void actionPerformed(ActionEvent e) {
        int index = Integer.parseInt(e.getActionCommand());
        switch (index) {
            case 0: {
                this.firePropertyChange(REMOVE_ACTIVITY_PROPERTY, null, this);
                break;
            }
            case 1: {
                this.download("", this.result);
                break;
            }
            case 2: {
                if (this.loader == null) break;
                this.loader.cancel();
                break;
            }
            case 3: {
                this.view(this.result);
                break;
            }
            case 5: {
                this.showResult();
                break;
            }
            case 7: {
                this.showException();
            }
        }
    }

    @Override
    public void setBackground(Color color) {
        super.setBackground(color);
        if (this.removeButton != null) {
            this.removeButton.setBackground(color);
        }
        if (this.cancelButton != null) {
            this.cancelButton.setBackground(color);
        }
        if (this.downloadButton != null) {
            this.downloadButton.setBackground(color);
        }
        if (this.viewButton != null) {
            this.viewButton.setBackground(color);
        }
        if (this.infoButton != null) {
            this.infoButton.setBackground(color);
        }
        if (this.errorButton != null) {
            this.errorButton.setBackground(color);
        }
        if (this.exceptionButton != null) {
            this.exceptionButton.setBackground(color);
        }
    }
}

