/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.init;

import javax.swing.JFrame;
import javax.swing.UIManager;
import org.openmicroscopy.shoola.env.config.Registry;
import org.openmicroscopy.shoola.env.config.RegistryFactory;
import org.openmicroscopy.shoola.env.init.InitializationTask;
import org.openmicroscopy.shoola.env.init.StartupException;
import org.openmicroscopy.shoola.env.ui.TaskBar;
import org.openmicroscopy.shoola.env.ui.UIFactory;

public final class TaskBarInit
extends InitializationTask {
    private static final String SYSTEM_LF = "system";

    String getName() {
        return "Creating Task Bar";
    }

    void configure() {
    }

    void execute() throws StartupException {
        Registry reg = this.container.getRegistry();
        String lookAndFeelClass = null;
        try {
            lookAndFeelClass = (String)reg.lookup("LookAndFeel");
            if (SYSTEM_LF.equalsIgnoreCase(lookAndFeelClass)) {
                lookAndFeelClass = UIManager.getSystemLookAndFeelClassName();
            }
            UIManager.setLookAndFeel(lookAndFeelClass);
            JFrame.setDefaultLookAndFeelDecorated(true);
            reg.getLogger().info((Object)this, "Loaded L&F: " + lookAndFeelClass);
        }
        catch (Exception e) {
            reg.getLogger().warn((Object)this, "Can't load L&F: " + lookAndFeelClass + ", will use default.");
        }
        TaskBar tb = UIFactory.makeTaskBar(this.container);
        RegistryFactory.linkTaskBar(tb, reg);
    }

    void rollback() {
    }
}

