/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.data.views.calls;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.openmicroscopy.shoola.env.data.OmeroDataService;
import org.openmicroscopy.shoola.env.data.views.BatchCall;
import org.openmicroscopy.shoola.env.data.views.BatchCallTree;
import pojos.DatasetData;
import pojos.ImageData;

public class ImagesLoader
extends BatchCallTree {
    private Object results;
    private BatchCall loadCall;

    private BatchCall makeBatchCall(final long userID) {
        return new BatchCall("Loading user's images: "){

            public void doCall() throws Exception {
                OmeroDataService os = ImagesLoader.this.context.getDataService();
                ImagesLoader.this.results = os.getExperimenterImages(userID);
            }
        };
    }

    private BatchCall makeBatchCall(final long imageID, final long userID) {
        return new BatchCall("Loading user's images: "){

            public void doCall() throws Exception {
                Iterator i;
                OmeroDataService os = ImagesLoader.this.context.getDataService();
                ArrayList<Long> ids = new ArrayList<Long>(1);
                ids.add(imageID);
                Set set = os.getImages(ImageData.class, ids, userID);
                if (set != null && set.size() == 1 && (i = set.iterator()).hasNext()) {
                    ImagesLoader.this.results = i.next();
                }
            }
        };
    }

    private BatchCall makeImagesInContainerBatchCall(final Class nodeType, final List nodeIDs, final long userID) {
        return new BatchCall("Loading container tree: "){

            public void doCall() throws Exception {
                OmeroDataService os = ImagesLoader.this.context.getDataService();
                ImagesLoader.this.results = os.getImages(nodeType, nodeIDs, userID);
            }
        };
    }

    private BatchCall makeBatchCall(final Timestamp startTime, final Timestamp endTime, final long userID) {
        return new BatchCall("Loading images: "){

            public void doCall() throws Exception {
                OmeroDataService os = ImagesLoader.this.context.getDataService();
                ImagesLoader.this.results = os.getImagesPeriod(startTime, endTime, userID, true);
            }
        };
    }

    protected void buildTree() {
        this.add(this.loadCall);
    }

    protected Object getResult() {
        return this.results;
    }

    public ImagesLoader(long rootLevelID) {
        this.loadCall = this.makeBatchCall(rootLevelID);
    }

    public ImagesLoader(Class nodeType, List nodeIDs, long userID) {
        if (nodeType == null) {
            throw new IllegalArgumentException("No node type.");
        }
        if (nodeIDs == null || nodeIDs.size() == 0) {
            throw new IllegalArgumentException("Collection of node ID not valid.");
        }
        if (!nodeType.equals(DatasetData.class) && !nodeType.equals(ImageData.class)) {
            throw new IllegalArgumentException("Unsupported type: " + nodeType);
        }
        this.loadCall = this.makeImagesInContainerBatchCall(nodeType, nodeIDs, userID);
    }

    public ImagesLoader(Timestamp startTime, Timestamp endTime, long userID) {
        this.loadCall = this.makeBatchCall(startTime, endTime, userID);
    }

    public ImagesLoader(long imageID, long rootLevelID) {
        this.loadCall = this.makeBatchCall(imageID, rootLevelID);
    }
}

