/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.data.views.calls;

import java.util.List;
import java.util.Set;
import org.openmicroscopy.shoola.env.data.OmeroDataService;
import org.openmicroscopy.shoola.env.data.views.BatchCall;
import org.openmicroscopy.shoola.env.data.views.BatchCallTree;
import pojos.DatasetData;
import pojos.ProjectData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HierarchyLoader
extends BatchCallTree {
    private long userID;
    private long groupID;
    private Set rootNodes;
    private BatchCall loadCall;

    private void validate(Class rootNodeType, List<Long> rootNodeIDs) {
        if (rootNodeType == null) {
            throw new IllegalArgumentException("No root node type.");
        }
        if (rootNodeIDs == null) {
            throw new IllegalArgumentException("No root node ids.");
        }
        if (rootNodeIDs.size() == 0) {
            throw new IllegalArgumentException("No root node ids.");
        }
        if (!rootNodeType.equals(ProjectData.class) && !rootNodeType.equals(DatasetData.class)) {
            throw new IllegalArgumentException("Unsupported type: " + rootNodeType);
        }
        this.loadCall = this.makeBatchCall(rootNodeType, rootNodeIDs);
    }

    private BatchCall makeBatchCall(final Class rootNodeType, final List rootNodeIDs) {
        return new BatchCall("Loading container tree: "){

            public void doCall() throws Exception {
                OmeroDataService os = HierarchyLoader.this.context.getDataService();
                HierarchyLoader.this.rootNodes = os.loadContainerHierarchy(rootNodeType, rootNodeIDs, true, HierarchyLoader.this.userID, HierarchyLoader.this.groupID);
            }
        };
    }

    @Override
    protected void buildTree() {
        this.add(this.loadCall);
    }

    @Override
    protected Object getResult() {
        return this.rootNodes;
    }

    public HierarchyLoader(Class rootNodeType, List<Long> rootNodeIDs, long userID, long groupID) {
        this.userID = userID;
        this.groupID = groupID;
        this.validate(rootNodeType, rootNodeIDs);
    }
}

